/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.learningdesign.dto.LibraryActivityDTO;

public class LearningLibraryDTO
extends BaseDTO {
    private Long learningLibraryID;
    private String description;
    private String title;
    private Boolean validFlag;
    private Vector templateActivities;

    public LearningLibraryDTO() {
    }

    public LearningLibraryDTO(Long learningLibraryID, String description, String title, Boolean validFlag, Vector templateActivities) {
        this.learningLibraryID = learningLibraryID;
        this.description = description;
        this.title = title;
        this.validFlag = validFlag;
        this.templateActivities = templateActivities;
    }

    public LearningLibraryDTO(LearningLibrary learningLibrary) {
        this.learningLibraryID = learningLibrary.getLearningLibraryId();
        this.description = learningLibrary.getDescription();
        this.title = learningLibrary.getTitle();
        this.validFlag = learningLibrary.getValidLibrary();
        this.templateActivities = this.populateActivities(learningLibrary.getActivities().iterator());
    }

    public LearningLibraryDTO(LearningLibrary learningLibrary, List templateActivity) {
        this.learningLibraryID = learningLibrary.getLearningLibraryId();
        this.description = learningLibrary.getDescription();
        this.title = learningLibrary.getTitle();
        this.validFlag = learningLibrary.getValidLibrary();
        this.templateActivities = this.populateActivities(templateActivity.iterator());
    }

    public String getDescription() {
        return this.description;
    }

    public Long getLearningLibraryID() {
        return this.learningLibraryID;
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getValidFlag() {
        return this.validFlag;
    }

    public Vector getTemplateActivities() {
        return this.templateActivities;
    }

    public Vector populateActivities(Iterator iterator) {
        Vector<LibraryActivityDTO> activities = new Vector<LibraryActivityDTO>();
        Vector<LibraryActivityDTO> childActivities = null;
        while (iterator.hasNext()) {
            Activity object = (Activity)iterator.next();
            if (object.isComplexActivity()) {
                ComplexActivity complexActivity = (ComplexActivity)object;
                Iterator childIterator = complexActivity.getActivities().iterator();
                childActivities = new Vector<LibraryActivityDTO>();
                while (childIterator.hasNext()) {
                    Activity activity = (Activity)childIterator.next();
                    childActivities.add(activity.getLibraryActivityDTO());
                }
                activities.add(complexActivity.getLibraryActivityDTO());
                activities.addAll(childActivities);
                continue;
            }
            activities.add(object.getLibraryActivityDTO());
        }
        return activities;
    }
}

