/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.test;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;
import servletunit.HttpServletRequestSimulator;
import servletunit.struts.MockStrutsTestCase;

public abstract class AbstractLamsStrutsTestCase
extends MockStrutsTestCase {
    protected HttpServletRequestSimulator httpRequest;
    protected HttpSession httpSession;
    protected WebApplicationContext wac;

    public AbstractLamsStrutsTestCase(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ContextLoader ctxLoader = new ContextLoader();
        this.context.setInitParameter("contextClass", XmlWebApplicationContext.class.getName());
        this.context.setInitParameter("contextConfigLocation", this.getContextConfigLocation());
        ctxLoader.initWebApplicationContext((ServletContext)this.context);
        this.wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.context);
        this.initializeHibernateSession();
        this.httpRequest = (HttpServletRequestSimulator)this.getRequest();
        this.httpSession = this.getSession();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void initializeHibernateSession() throws HibernateException {
        SessionFactory sessionFactory = (SessionFactory)this.wac.getBean(this.getHibernateSessionFactoryBeanName());
        Session s = sessionFactory.openSession();
        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)new SessionHolder((org.hibernate.Session)s));
    }

    protected void finalizeHibernateSession() throws HibernateException {
        SessionFactory sessionFactory = (SessionFactory)this.wac.getBean(this.getHibernateSessionFactoryBeanName());
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (holder != null) {
            org.hibernate.Session s = holder.getSession();
            s.flush();
            TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            SessionFactoryUtils.releaseSession((org.hibernate.Session)s, (SessionFactory)sessionFactory);
        }
    }

    protected abstract String getHibernateSessionFactoryBeanName();

    protected abstract String getContextConfigLocation();
}

