/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSVideoObject;
import com.flagstone.transform.Transform;

public final class FSAudioData
extends FSVideoObject {
    private int format = 0;
    private int playbackRate = 5512;
    private int playbackChannels = 1;
    private int playbackSampleSize = 1;
    private byte[] soundData = null;

    FSAudioData(FSCoder fSCoder) {
        super(8, 0);
        this.decode(fSCoder);
    }

    public FSAudioData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        super(8, n);
        this.setFormat(n2);
        this.setPlaybackRate(n3);
        this.setPlaybackChannels(n4);
        this.setPlaybackSampleSize(n5);
        this.setSoundData(byArray);
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public int getPlaybackRate() {
        return this.playbackRate;
    }

    public void setPlaybackRate(int n) {
        this.playbackRate = n;
    }

    public int getPlaybackChannels() {
        return this.playbackChannels;
    }

    public void setPlaybackChannels(int n) {
        this.playbackChannels = n;
    }

    public int getPlaybackSampleSize() {
        return this.playbackSampleSize;
    }

    public void setPlaybackSampleSize(int n) {
        this.playbackSampleSize = n;
    }

    public byte[] getSoundData() {
        return this.soundData;
    }

    public void setSoundData(byte[] byArray) {
        this.soundData = byArray;
    }

    public Object clone() {
        FSAudioData fSAudioData = (FSAudioData)super.clone();
        fSAudioData.soundData = Transform.clone(this.soundData);
        return fSAudioData;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSAudioData fSAudioData = (FSAudioData)object;
            bl = this.format == fSAudioData.format;
            bl = bl && this.playbackRate == fSAudioData.playbackRate;
            bl = bl && this.playbackChannels == fSAudioData.playbackChannels;
            bl = bl && this.playbackSampleSize == fSAudioData.playbackSampleSize;
            bl = bl && Transform.equals(this.soundData, fSAudioData.soundData);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "format", this.format);
            Transform.append(stringBuffer, "playbackRate", this.playbackRate);
            Transform.append(stringBuffer, "playbackChannels", this.playbackChannels);
            Transform.append(stringBuffer, "playbackSampleSize", this.playbackSampleSize);
            stringBuffer.append("}");
        } else {
            stringBuffer.append(this.name());
        }
    }

    int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 1 + this.soundData.length;
        return this.length;
    }

    void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeBits(this.format, 4);
        switch (this.playbackRate) {
            case 5512: {
                fSCoder.writeBits(0, 2);
                break;
            }
            case 11025: {
                fSCoder.writeBits(1, 2);
                break;
            }
            case 22050: {
                fSCoder.writeBits(2, 2);
                break;
            }
            case 44100: {
                fSCoder.writeBits(3, 2);
            }
        }
        fSCoder.writeBits(this.playbackSampleSize - 1, 1);
        fSCoder.writeBits(this.playbackChannels - 1, 1);
        fSCoder.writeBytes(this.soundData);
    }

    void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        this.format = fSCoder.readBits(4, false);
        switch (fSCoder.readBits(2, false)) {
            case 0: {
                this.playbackRate = 5512;
                break;
            }
            case 1: {
                this.playbackRate = 11025;
                break;
            }
            case 2: {
                this.playbackRate = 22050;
                break;
            }
            case 3: {
                this.playbackRate = 44100;
            }
        }
        this.playbackSampleSize = fSCoder.readBits(1, false) + 1;
        this.playbackChannels = fSCoder.readBits(1, false) + 1;
        this.soundData = new byte[this.length - 1];
        fSCoder.readBytes(this.soundData);
    }
}

