/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;

public class FSBounds
extends FSTransformObject {
    private int minX = 0;
    private int minY = 0;
    private int maxX = 0;
    private int maxY = 0;

    public FSBounds(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSBounds(int n, int n2, int n3, int n4) {
        this.setMinX(n);
        this.setMinY(n2);
        this.setMaxX(n3);
        this.setMaxY(n4);
    }

    public FSBounds(FSBounds fSBounds) {
        this.minX = fSBounds.minX;
        this.maxX = fSBounds.maxX;
        this.minY = fSBounds.minY;
        this.maxY = fSBounds.maxY;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setMinX(int n) {
        this.minX = n;
    }

    public void setMaxX(int n) {
        this.maxX = n;
    }

    public void setMinY(int n) {
        this.minY = n;
    }

    public void setMaxY(int n) {
        this.maxY = n;
    }

    public int getWidth() {
        return this.maxX - this.minX;
    }

    public int getHeight() {
        return this.maxY - this.minY;
    }

    public void setMin(int n, int n2) {
        this.minX = n;
        this.minY = n2;
    }

    public void setMax(int n, int n2) {
        this.maxX = n;
        this.maxY = n2;
    }

    public void setPoints(int n, int n2, int n3, int n4) {
        this.minX = n;
        this.minY = n2;
        this.maxX = n3;
        this.maxY = n4;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSBounds fSBounds = (FSBounds)object;
            bl = this.minX == fSBounds.minX;
            bl = bl && this.minY == fSBounds.minY;
            bl = bl && this.maxX == fSBounds.maxX;
            bl = bl && this.maxY == fSBounds.maxY;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "minX", this.minX);
            Transform.append(stringBuffer, "minY", this.minY);
            Transform.append(stringBuffer, "maxX", this.maxX);
            Transform.append(stringBuffer, "maxY", this.maxY);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = 0;
        int n2 = FSCoder.size(new int[]{this.minX, this.maxX, this.minY, this.maxY}, true);
        return (n += (n = 5 + n2 * 4) % 8 > 0 ? 8 - n % 8 : 0) >> 3;
    }

    public void encode(FSCoder fSCoder) {
        int n = FSCoder.size(new int[]{this.minX, this.maxX, this.minY, this.maxY}, true);
        fSCoder.alignToByte();
        fSCoder.writeBits(n, 5);
        fSCoder.writeBits(this.minX, n);
        fSCoder.writeBits(this.maxX, n);
        fSCoder.writeBits(this.minY, n);
        fSCoder.writeBits(this.maxY, n);
        fSCoder.alignToByte();
    }

    public void decode(FSCoder fSCoder) {
        fSCoder.alignToByte();
        int n = fSCoder.readBits(5, false);
        this.minX = fSCoder.readBits(n, true);
        this.maxX = fSCoder.readBits(n, true);
        this.minY = fSCoder.readBits(n, true);
        this.maxY = fSCoder.readBits(n, true);
        fSCoder.alignToByte();
    }
}

