/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSColorTransform;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;

public class FSButton
extends FSTransformObject {
    public static final int Up = 1;
    public static final int Over = 2;
    public static final int Down = 4;
    public static final int Active = 8;
    private int state = 0;
    private int identifier = 0;
    private int layer = 0;
    private FSCoordTransform transform = null;
    private FSColorTransform colorTransform = null;

    public FSButton(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSButton(int n, int n2, int n3) {
        this.setState(n);
        this.setIdentifier(n2);
        this.setLayer(n3);
        this.setTransform(new FSCoordTransform(0, 0));
        this.setColorTransform(new FSColorTransform());
    }

    public FSButton(int n, int n2, int n3, FSCoordTransform fSCoordTransform) {
        this.setState(n);
        this.setIdentifier(n2);
        this.setLayer(n3);
        this.setTransform(fSCoordTransform);
        this.setColorTransform(new FSColorTransform());
    }

    public FSButton(int n, int n2, int n3, FSCoordTransform fSCoordTransform, FSColorTransform fSColorTransform) {
        this.setState(n);
        this.setIdentifier(n2);
        this.setLayer(n3);
        this.setTransform(fSCoordTransform);
        this.setColorTransform(fSColorTransform);
    }

    public FSButton(FSButton fSButton) {
        this.state = fSButton.state;
        this.identifier = fSButton.identifier;
        this.layer = fSButton.layer;
        this.transform = new FSCoordTransform(fSButton.transform);
        if (fSButton.colorTransform != null) {
            this.colorTransform = new FSColorTransform(fSButton.colorTransform);
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean isActive() {
        return (this.state & 8) != 0;
    }

    public boolean isDown() {
        return (this.state & 4) != 0;
    }

    public boolean isOver() {
        return (this.state & 2) != 0;
    }

    public boolean isUp() {
        return (this.state & 1) != 0;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public int getLayer() {
        return this.layer;
    }

    public FSCoordTransform getTransform() {
        return this.transform;
    }

    public FSColorTransform getColorTransform() {
        return this.colorTransform;
    }

    public void setState(int n) {
        this.state = n;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public void setTransform(FSCoordTransform fSCoordTransform) {
        this.transform = fSCoordTransform;
    }

    public void setColorTransform(FSColorTransform fSColorTransform) {
        this.colorTransform = fSColorTransform;
    }

    public Object clone() {
        FSButton fSButton = (FSButton)super.clone();
        fSButton = (FSButton)super.clone();
        fSButton.transform = this.transform != null ? (FSCoordTransform)this.transform.clone() : null;
        fSButton.colorTransform = this.colorTransform != null ? (FSColorTransform)this.colorTransform.clone() : null;
        return fSButton;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSButton fSButton = (FSButton)object;
            bl = this.state == fSButton.state;
            bl = bl && this.identifier == fSButton.identifier;
            boolean bl2 = bl = bl && this.layer == fSButton.layer;
            if (this.transform != null) {
                bl = bl && this.transform.equals(fSButton.transform);
            } else {
                boolean bl3 = bl = bl && this.transform == fSButton.transform;
            }
            bl = this.colorTransform != null ? bl && this.colorTransform.equals(fSButton.colorTransform) : bl && this.colorTransform == fSButton.colorTransform;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "state", this.state);
            Transform.append(stringBuffer, "identifier", this.identifier);
            Transform.append(stringBuffer, "layer", this.layer);
            Transform.append(stringBuffer, "transform", this.transform, n);
            Transform.append(stringBuffer, "colorTransform", this.colorTransform, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = 0;
        n += 5;
        n += this.transform.length(fSCoder);
        if (fSCoder.context[3] == 34) {
            n += this.colorTransform.length(fSCoder);
        }
        return n;
    }

    public void encode(FSCoder fSCoder) {
        fSCoder.writeBits(0, 4);
        fSCoder.writeBits(this.state, 4);
        fSCoder.writeWord(this.identifier, 2);
        fSCoder.writeWord(this.layer, 2);
        this.transform.encode(fSCoder);
        if (fSCoder.context[3] == 34) {
            this.colorTransform.encode(fSCoder);
        }
    }

    public void decode(FSCoder fSCoder) {
        fSCoder.readBits(4, false);
        this.state = fSCoder.readBits(4, false);
        this.identifier = fSCoder.readWord(2, false);
        this.layer = fSCoder.readWord(2, false);
        this.transform = new FSCoordTransform(fSCoder);
        if (fSCoder.context[3] == 34) {
            this.colorTransform = new FSColorTransform(fSCoder);
        }
    }
}

