/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.FSSound;
import com.flagstone.transform.Transform;

public class FSButtonSound
extends FSMovieObject {
    private int identifier = 0;
    private FSSound[] sound = new FSSound[]{null, null, null, null};

    public FSButtonSound(FSCoder fSCoder) {
        super(17);
        this.decode(fSCoder);
    }

    public FSButtonSound(int n, int n2, FSSound fSSound) {
        super(17);
        this.setIdentifier(n);
        this.setSoundForEvent(n2, fSSound);
    }

    public FSButtonSound(FSButtonSound fSButtonSound) {
        super(fSButtonSound);
        this.identifier = fSButtonSound.identifier;
        for (int i = 0; i < 4; ++i) {
            if (fSButtonSound.sound[i] == null) continue;
            this.sound[i] = new FSSound(fSButtonSound.sound[i]);
        }
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public FSSound getSoundForEvent(int n) {
        FSSound fSSound = null;
        fSSound = n == 2 ? this.sound[0] : (n == 1 ? this.sound[1] : (n == 4 ? this.sound[2] : this.sound[3]));
        return fSSound;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }

    public void setSoundForEvent(int n, FSSound fSSound) {
        if (n == 2) {
            this.sound[0] = fSSound;
        } else if (n == 1) {
            this.sound[1] = fSSound;
        } else if (n == 4) {
            this.sound[2] = fSSound;
        } else {
            this.sound[3] = fSSound;
        }
    }

    public Object clone() {
        FSButtonSound fSButtonSound = (FSButtonSound)super.clone();
        for (int i = 0; i < 4; ++i) {
            fSButtonSound.sound[i] = this.sound[i] != null ? (FSSound)this.sound[i].clone() : null;
        }
        return fSButtonSound;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSButtonSound fSButtonSound = (FSButtonSound)object;
            bl = this.identifier == fSButtonSound.identifier;
            for (int i = 0; i < 4; ++i) {
                bl = this.sound[i] != null ? bl && this.sound[i].equals(fSButtonSound.sound[i]) : bl && this.sound[i] == fSButtonSound.sound[i];
            }
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(this.name() + ": {");
            Transform.append(stringBuffer, "identifier", this.identifier);
            if (n - 1 > 0) {
                for (int i = 0; i < 4; ++i) {
                    stringBuffer.append("sound[" + i + "] = ");
                    if (this.sound[i] != null) {
                        this.sound[i].appendDescription(stringBuffer, n);
                        continue;
                    }
                    stringBuffer.append("null; ");
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    stringBuffer.append("sound[" + i + "] =");
                    if (this.sound[i] != null) {
                        Transform.append(stringBuffer, this.sound[i].name(), n);
                        continue;
                    }
                    stringBuffer.append("null");
                }
            }
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 2;
        for (int i = 0; i < 4; ++i) {
            if (this.sound[i] != null && this.sound[i].getIdentifier() != 0) {
                this.length += this.sound[i].length(fSCoder);
                continue;
            }
            this.length += 2;
        }
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeWord(this.identifier, 2);
        for (int i = 0; i < 4; ++i) {
            if (this.sound[i] != null && this.sound[i].getIdentifier() != 0) {
                this.sound[i].encode(fSCoder);
                continue;
            }
            fSCoder.writeWord(0, 2);
        }
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        int n = fSCoder.getPointer();
        this.identifier = fSCoder.readWord(2, false);
        for (int i = 0; i < 4; ++i) {
            if (fSCoder.scanWord(2, false) > 0) {
                this.sound[i] = new FSSound(fSCoder);
            } else {
                fSCoder.readWord(2, false);
            }
            if (fSCoder.getPointer() - n >>> 3 == this.length) break;
        }
        fSCoder.endObject(this.name());
    }
}

