/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.Transform;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class FSDefineImage
extends FSDefineObject {
    private int width = 0;
    private int height = 0;
    private int pixelSize = 8;
    private int tableSize = 0;
    private byte[] compressedData = null;

    public FSDefineImage(FSCoder fSCoder) {
        super(20, 0);
        this.extendLength = true;
        this.decode(fSCoder);
    }

    public FSDefineImage(int n, int n2, int n3, int n4, byte[] byArray) {
        super(20, n);
        this.extendLength = true;
        this.setWidth(n2);
        this.setHeight(n3);
        this.setPixelSize(8);
        this.setTableSize(n4);
        this.setCompressedData(byArray);
    }

    public FSDefineImage(int n, int n2, int n3, byte[] byArray, int n4) {
        super(20, n);
        this.extendLength = true;
        this.setWidth(n2);
        this.setHeight(n3);
        this.setPixelSize(n4);
        this.setTableSize(0);
        this.setCompressedData(byArray);
    }

    public FSDefineImage(FSDefineImage fSDefineImage) {
        super(fSDefineImage);
        this.width = fSDefineImage.width;
        this.height = fSDefineImage.height;
        this.pixelSize = fSDefineImage.pixelSize;
        this.tableSize = fSDefineImage.tableSize;
        this.compressedData = Transform.clone(fSDefineImage.compressedData);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixelSize() {
        return this.pixelSize;
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public byte[] getCompressedData() {
        return this.compressedData;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setPixelSize(int n) {
        this.pixelSize = n;
    }

    public void setTableSize(int n) {
        this.tableSize = n;
    }

    public void setCompressedData(byte[] byArray) {
        this.compressedData = byArray;
    }

    public Object clone() {
        FSDefineImage fSDefineImage = (FSDefineImage)super.clone();
        fSDefineImage.compressedData = Transform.clone(this.compressedData);
        return fSDefineImage;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineImage fSDefineImage = (FSDefineImage)object;
            bl = this.pixelSize == fSDefineImage.pixelSize;
            bl = bl && this.width == fSDefineImage.width;
            bl = bl && this.height == fSDefineImage.height;
            bl = bl && this.tableSize == fSDefineImage.tableSize;
            try {
                bl = bl && Transform.equals(this.unzip(this.compressedData), this.unzip(fSDefineImage.compressedData));
            }
            catch (DataFormatException dataFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    private byte[] unzip(byte[] byArray) throws DataFormatException {
        byte[] byArray2 = new byte[this.width * this.height * 8];
        int n = 0;
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        n = inflater.inflate(byArray2);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "pixelSize", this.pixelSize);
            Transform.append(stringBuffer, "width", this.width);
            Transform.append(stringBuffer, "height", this.height);
            Transform.append(stringBuffer, "tableSize", this.tableSize);
            Transform.append(stringBuffer, "compressedData", "<data>");
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 5;
        this.length += this.pixelSize == 8 ? 1 : 0;
        this.length += this.compressedData.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        fSCoder.beginObject(this.name());
        super.encode(fSCoder);
        switch (this.pixelSize) {
            case 8: {
                fSCoder.writeWord(3, 1);
                break;
            }
            case 16: {
                fSCoder.writeWord(4, 1);
                break;
            }
            case 24: {
                fSCoder.writeWord(5, 1);
            }
        }
        fSCoder.writeWord(this.width, 2);
        fSCoder.writeWord(this.height, 2);
        if (this.pixelSize == 8) {
            fSCoder.writeWord(this.tableSize - 1, 1);
        }
        fSCoder.writeBytes(this.compressedData);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        switch (fSCoder.readWord(1, false)) {
            case 3: {
                this.pixelSize = 8;
                break;
            }
            case 4: {
                this.pixelSize = 16;
                break;
            }
            case 5: {
                this.pixelSize = 24;
            }
        }
        this.width = fSCoder.readWord(2, false);
        this.height = fSCoder.readWord(2, false);
        if (this.pixelSize == 8) {
            this.tableSize = fSCoder.readWord(1, false) + 1;
            this.compressedData = new byte[this.length - 8];
            fSCoder.readBytes(this.compressedData);
        } else {
            this.compressedData = new byte[this.length - 7];
            fSCoder.readBytes(this.compressedData);
        }
        fSCoder.endObject(this.name());
    }
}

