/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.Transform;

public class FSDefineJPEGImage
extends FSDefineObject {
    private byte[] image = null;
    private int width;
    private int height;

    public FSDefineJPEGImage(FSCoder fSCoder) {
        super(6, 0);
        this.decode(fSCoder);
    }

    public FSDefineJPEGImage(int n, byte[] byArray) {
        super(6, n);
        this.setImage(byArray);
    }

    public FSDefineJPEGImage(FSDefineJPEGImage fSDefineJPEGImage) {
        super(fSDefineJPEGImage);
        this.width = fSDefineJPEGImage.width;
        this.height = fSDefineJPEGImage.height;
        this.image = Transform.clone(fSDefineJPEGImage.image);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] byArray) {
        this.image = byArray;
        this.decodeInfo();
    }

    public Object clone() {
        FSDefineJPEGImage fSDefineJPEGImage = (FSDefineJPEGImage)super.clone();
        fSDefineJPEGImage.image = Transform.clone(this.image);
        fSDefineJPEGImage.width = this.width;
        fSDefineJPEGImage.height = this.height;
        return fSDefineJPEGImage;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineJPEGImage fSDefineJPEGImage = (FSDefineJPEGImage)object;
            bl = Transform.equals(this.image, fSDefineJPEGImage.image);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "image", "<data>");
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += this.image.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeBytes(this.image);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        byte[] byArray = new byte[this.length - 2];
        fSCoder.readBytes(byArray);
        this.setImage(byArray);
        fSCoder.endObject(this.name());
    }

    private boolean decodeInfo() {
        FSCoder fSCoder = new FSCoder(1, this.image);
        if (fSCoder.readWord(2, false) != 65496) {
            return false;
        }
        while (true) {
            int n = fSCoder.readWord(2, false);
            int n2 = fSCoder.readWord(2, false);
            if ((n & 0xFF00) != 65280) {
                return false;
            }
            if (n >= 65472 && n <= 65487 && n != 65476 && n != 65480) {
                fSCoder.readWord(1, false);
                this.height = fSCoder.readWord(2, false);
                this.width = fSCoder.readWord(2, false);
                return true;
            }
            fSCoder.adjustPointer(n2 - 2 << 3);
        }
    }
}

