/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.Transform;

public class FSDefineJPEGImage3
extends FSDefineObject {
    private int width;
    private int height;
    private byte[] image = null;
    private byte[] encodingTable = null;
    private byte[] alpha = null;

    public FSDefineJPEGImage3(FSCoder fSCoder) {
        super(35, 0);
        this.decode(fSCoder);
    }

    public FSDefineJPEGImage3(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(35, n);
        this.setImage(byArray);
        this.setEncodingTable(byArray2);
        this.setCompressedAlpha(byArray3);
    }

    public FSDefineJPEGImage3(FSDefineJPEGImage3 fSDefineJPEGImage3) {
        super(fSDefineJPEGImage3);
        this.image = Transform.clone(fSDefineJPEGImage3.image);
        this.width = fSDefineJPEGImage3.width;
        this.height = fSDefineJPEGImage3.height;
        this.encodingTable = Transform.clone(fSDefineJPEGImage3.encodingTable);
        this.alpha = Transform.clone(fSDefineJPEGImage3.alpha);
    }

    public byte[] getEncodingTable() {
        return this.encodingTable;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getImage() {
        return this.image;
    }

    public byte[] getCompressedAlpha() {
        return this.alpha;
    }

    public void setEncodingTable(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{-1, -39, -1, -40};
        }
        this.encodingTable = byArray;
    }

    public void setImage(byte[] byArray) {
        this.image = byArray;
        this.decodeInfo();
    }

    public void setCompressedAlpha(byte[] byArray) {
        this.alpha = byArray;
    }

    public Object clone() {
        FSDefineJPEGImage3 fSDefineJPEGImage3 = (FSDefineJPEGImage3)super.clone();
        fSDefineJPEGImage3.image = Transform.clone(this.image);
        fSDefineJPEGImage3.encodingTable = Transform.clone(this.encodingTable);
        fSDefineJPEGImage3.alpha = Transform.clone(this.alpha);
        return fSDefineJPEGImage3;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineJPEGImage3 fSDefineJPEGImage3 = (FSDefineJPEGImage3)object;
            bl = Transform.equals(this.image, fSDefineJPEGImage3.image);
            bl = bl && Transform.equals(this.encodingTable, fSDefineJPEGImage3.encodingTable);
            bl = bl && Transform.equals(this.alpha, fSDefineJPEGImage3.alpha);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "encodingTable", "<data>");
            Transform.append(stringBuffer, "image", "<data>");
            Transform.append(stringBuffer, "alpha", "<data>");
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 4;
        this.length += this.encodingTable.length;
        this.length += this.image.length;
        this.length += this.alpha == null ? 0 : this.alpha.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeWord(this.encodingTable.length + this.image.length, 4);
        fSCoder.writeBytes(this.encodingTable);
        fSCoder.writeBytes(this.image);
        if (this.alpha != null) {
            fSCoder.writeBytes(this.alpha);
        }
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        int n = fSCoder.readWord(4, false);
        this.setEncodingTable(this.readJPEGStream(fSCoder));
        byte[] byArray = new byte[n - this.encodingTable.length];
        fSCoder.readBytes(byArray);
        this.setImage(byArray);
        byte[] byArray2 = new byte[this.length - n - 6];
        fSCoder.readBytes(byArray2);
        this.setCompressedAlpha(byArray2);
        fSCoder.endObject(this.name());
    }

    private byte[] readJPEGStream(FSCoder fSCoder) {
        int n;
        byte[] byArray = null;
        int n2 = fSCoder.getPointer();
        int n3 = n2 + (this.length - 2 << 3);
        int n4 = fSCoder.readBits(16, false);
        int n5 = n = n4 == 65496 ? 65497 : 65496;
        do {
            if ((n4 = fSCoder.scanBits(16, false)) == n) {
                n3 = fSCoder.getPointer() + 16;
                break;
            }
            fSCoder.adjustPointer(8);
        } while (fSCoder.getPointer() < n3);
        int n6 = n3 - n2 >>> 3;
        fSCoder.setPointer(n2);
        byArray = new byte[n6];
        fSCoder.readBytes(byArray);
        return byArray;
    }

    private boolean decodeInfo() {
        FSCoder fSCoder = new FSCoder(1, this.image);
        if (fSCoder.readWord(2, false) != 65496) {
            return false;
        }
        while (true) {
            int n = fSCoder.readWord(2, false);
            int n2 = fSCoder.readWord(2, false);
            if ((n & 0xFF00) != 65280) {
                return false;
            }
            if (n >= 65472 && n <= 65487 && n != 65476 && n != 65480) {
                fSCoder.readWord(1, false);
                this.height = fSCoder.readWord(2, false);
                this.width = fSCoder.readWord(2, false);
                return true;
            }
            fSCoder.adjustPointer(n2 - 2 << 3);
        }
    }
}

