/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.Transform;

public class FSDefineSound
extends FSDefineObject {
    private int format = 0;
    private int playbackRate = 5512;
    private int playbackChannels = 1;
    private int playbackSampleSize = 1;
    private int sampleCount = 0;
    private byte[] soundData = null;

    public FSDefineSound(FSCoder fSCoder) {
        super(14, 0);
        this.decode(fSCoder);
    }

    public FSDefineSound(int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        super(14, n);
        this.setFormat(n2);
        this.setPlaybackRate(n3);
        this.setPlaybackChannels(n4);
        this.setPlaybackSampleSize(n5);
        this.setSampleCount(n6);
        this.setSoundData(byArray);
    }

    public FSDefineSound(FSDefineSound fSDefineSound) {
        super(fSDefineSound);
        this.format = fSDefineSound.format;
        this.playbackRate = fSDefineSound.playbackRate;
        this.playbackChannels = fSDefineSound.playbackChannels;
        this.playbackSampleSize = fSDefineSound.playbackSampleSize;
        this.sampleCount = fSDefineSound.sampleCount;
        this.soundData = Transform.clone(fSDefineSound.soundData);
    }

    public int getFormat() {
        return this.format;
    }

    public int getPlaybackRate() {
        return this.playbackRate;
    }

    public int getPlaybackChannels() {
        return this.playbackChannels;
    }

    public int getPlaybackSampleSize() {
        return this.playbackSampleSize;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public byte[] getSoundData() {
        return this.soundData;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public void setPlaybackRate(int n) {
        this.playbackRate = n;
    }

    public void setPlaybackChannels(int n) {
        this.playbackChannels = n;
    }

    public void setPlaybackSampleSize(int n) {
        this.playbackSampleSize = n;
    }

    public void setSampleCount(int n) {
        this.sampleCount = n;
    }

    public void setSoundData(byte[] byArray) {
        this.soundData = byArray;
    }

    public Object clone() {
        FSDefineSound fSDefineSound = (FSDefineSound)super.clone();
        fSDefineSound.soundData = Transform.clone(this.soundData);
        return fSDefineSound;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineSound fSDefineSound = (FSDefineSound)object;
            bl = this.format == fSDefineSound.format;
            bl = bl && this.playbackRate == fSDefineSound.playbackRate;
            bl = bl && this.playbackChannels == fSDefineSound.playbackChannels;
            bl = bl && this.playbackSampleSize == fSDefineSound.playbackSampleSize;
            bl = bl && this.sampleCount == fSDefineSound.sampleCount;
            bl = bl && Transform.equals(this.soundData, fSDefineSound.soundData);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "identifier", this.identifier);
            Transform.append(stringBuffer, "format", this.format);
            Transform.append(stringBuffer, "playbackRate", this.playbackRate);
            Transform.append(stringBuffer, "playbackChannels", this.playbackChannels);
            Transform.append(stringBuffer, "playbackSampleSize", this.playbackSampleSize);
            Transform.append(stringBuffer, "sampleCount", this.sampleCount);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 5;
        this.length += this.soundData.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeBits(this.format, 4);
        switch (this.playbackRate) {
            case 5512: {
                fSCoder.writeBits(0, 2);
                break;
            }
            case 11025: {
                fSCoder.writeBits(1, 2);
                break;
            }
            case 22050: {
                fSCoder.writeBits(2, 2);
                break;
            }
            case 44100: {
                fSCoder.writeBits(3, 2);
            }
        }
        fSCoder.writeBits(this.playbackSampleSize - 1, 1);
        fSCoder.writeBits(this.playbackChannels - 1, 1);
        fSCoder.writeWord(this.sampleCount, 4);
        fSCoder.writeBytes(this.soundData);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        this.format = fSCoder.readBits(4, false);
        switch (fSCoder.readBits(2, false)) {
            case 0: {
                this.playbackRate = 5512;
                break;
            }
            case 1: {
                this.playbackRate = 11025;
                break;
            }
            case 2: {
                this.playbackRate = 22050;
                break;
            }
            case 3: {
                this.playbackRate = 44100;
            }
        }
        this.playbackSampleSize = fSCoder.readBits(1, false) + 1;
        this.playbackChannels = fSCoder.readBits(1, false) + 1;
        this.sampleCount = fSCoder.readWord(4, false);
        this.soundData = new byte[this.length - 7];
        fSCoder.readBytes(this.soundData);
        fSCoder.endObject(this.name());
    }
}

