/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.Transform;

public class FSDefineVideo
extends FSDefineObject {
    public static final int H263 = 2;
    public static final int ScreenVideo = 3;
    public static final int UseVideo = 0;
    public static final int Off = 1;
    public static final int On = 2;
    private int frameCount = 0;
    private int width = 0;
    private int height = 0;
    private int deblocking = 0;
    private boolean smoothing = false;
    private int codec = 0;

    public FSDefineVideo(FSCoder fSCoder) {
        super(60, 0);
        this.decode(fSCoder);
    }

    public FSDefineVideo(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        super(60, n);
        this.setFrameCount(n2);
        this.setWidth(n3);
        this.setHeight(n4);
        this.setDeblocking(n5);
        this.setSmoothing(bl);
        this.setCodec(n6);
    }

    public FSDefineVideo(FSDefineVideo fSDefineVideo) {
        super(fSDefineVideo);
        this.frameCount = fSDefineVideo.frameCount;
        this.width = fSDefineVideo.width;
        this.height = fSDefineVideo.height;
        this.deblocking = fSDefineVideo.deblocking;
        this.smoothing = fSDefineVideo.smoothing;
        this.codec = fSDefineVideo.codec;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(int n) {
        this.frameCount = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getDeblocking() {
        return this.deblocking;
    }

    public void setDeblocking(int n) {
        this.deblocking = n;
    }

    public boolean getSmoothing() {
        return this.smoothing;
    }

    public void setSmoothing(boolean bl) {
        this.smoothing = bl;
    }

    public int getCodec() {
        return this.codec;
    }

    public void setCodec(int n) {
        this.codec = n;
    }

    public Object clone() {
        FSDefineVideo fSDefineVideo = (FSDefineVideo)super.clone();
        return fSDefineVideo;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineVideo fSDefineVideo = (FSDefineVideo)object;
            bl = this.frameCount == fSDefineVideo.frameCount;
            bl = bl && this.width == fSDefineVideo.width;
            bl = bl && this.height == fSDefineVideo.height;
            bl = bl && this.deblocking == fSDefineVideo.deblocking;
            bl = bl && this.smoothing == fSDefineVideo.smoothing;
            bl = bl && this.codec == fSDefineVideo.codec;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "identifier", this.identifier);
            Transform.append(stringBuffer, "frameCount", this.frameCount);
            Transform.append(stringBuffer, "width", this.width);
            Transform.append(stringBuffer, "height", this.height);
            Transform.append(stringBuffer, "deblocking", this.deblocking);
            Transform.append(stringBuffer, "smoothing", this.smoothing);
            Transform.append(stringBuffer, "codec", this.codec);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 8;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeWord(this.frameCount, 2);
        fSCoder.writeWord(this.width, 2);
        fSCoder.writeWord(this.height, 2);
        fSCoder.writeBits(0, 5);
        fSCoder.writeBits(this.deblocking, 2);
        fSCoder.writeBits(this.smoothing ? 1 : 0, 1);
        fSCoder.writeWord(this.codec, 1);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        this.frameCount = fSCoder.readWord(2, false);
        this.width = fSCoder.readWord(2, false);
        this.height = fSCoder.readWord(2, false);
        fSCoder.readBits(5, false);
        this.deblocking = fSCoder.readBits(2, false);
        this.smoothing = fSCoder.readBits(1, false) == 1;
        this.codec = fSCoder.readWord(1, false);
        fSCoder.endObject(this.name());
    }
}

