/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSActionObject;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSDoAction;
import com.flagstone.transform.FSFrameLabel;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.FSShowFrame;
import java.util.ArrayList;
import java.util.Iterator;

public final class FSFrame {
    private String label = null;
    private ArrayList definitions = null;
    private ArrayList commands = null;
    private ArrayList actions = null;

    public static ArrayList framesFromMovie(FSMovie fSMovie) {
        ArrayList<FSFrame> arrayList = new ArrayList<FSFrame>();
        FSFrame fSFrame = new FSFrame();
        Iterator iterator = fSMovie.getObjects().iterator();
        while (iterator.hasNext()) {
            FSMovieObject fSMovieObject = (FSMovieObject)iterator.next();
            if (fSMovieObject instanceof FSDoAction) {
                fSFrame.actions = ((FSDoAction)fSMovieObject).getActions();
                continue;
            }
            if (fSMovieObject instanceof FSFrameLabel) {
                fSFrame.label = ((FSFrameLabel)fSMovieObject).getLabel();
                continue;
            }
            if (fSMovieObject instanceof FSDefineObject) {
                fSFrame.addDefinition((FSDefineObject)fSMovieObject);
                continue;
            }
            if (fSMovieObject instanceof FSShowFrame) {
                arrayList.add(fSFrame);
                fSFrame = new FSFrame();
                continue;
            }
            fSFrame.addCommand(fSMovieObject);
        }
        return arrayList;
    }

    public FSFrame() {
        this.definitions = new ArrayList();
        this.commands = new ArrayList();
        this.actions = new ArrayList();
    }

    public FSFrame(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        this.setLabel(string);
        this.setDefinitions(arrayList);
        this.setCommands(arrayList2);
        this.setActions(arrayList3);
    }

    public void addAction(FSActionObject fSActionObject) {
        if (this.actions == null) {
            this.actions = new ArrayList();
        }
        this.actions.add(fSActionObject);
    }

    public void addDefinition(FSDefineObject fSDefineObject) {
        if (this.definitions == null) {
            this.definitions = new ArrayList();
        }
        this.definitions.add(fSDefineObject);
    }

    public void addCommand(FSMovieObject fSMovieObject) {
        this.commands.add(fSMovieObject);
    }

    public String getLabel() {
        return this.label;
    }

    public ArrayList getDefinitions() {
        return this.definitions;
    }

    public ArrayList getCommands() {
        return this.commands;
    }

    public ArrayList getActions() {
        return this.actions;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setDefinitions(ArrayList arrayList) {
        this.definitions = arrayList;
    }

    public void setCommands(ArrayList arrayList) {
        this.commands = arrayList;
    }

    public void setActions(ArrayList arrayList) {
        this.actions = arrayList;
    }

    public void addToMovie(FSMovie fSMovie) {
        Iterator iterator;
        if (this.definitions != null || this.definitions.size() > 0) {
            iterator = this.definitions.iterator();
            while (iterator.hasNext()) {
                fSMovie.add((FSMovieObject)iterator.next());
            }
        }
        if (this.label != null && this.label.length() > 0) {
            fSMovie.add(new FSFrameLabel(this.label));
        }
        if (this.actions != null && this.actions.size() > 0) {
            fSMovie.add(new FSDoAction(this.actions));
        }
        iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            fSMovie.add((FSMovieObject)iterator.next());
        }
        fSMovie.add(new FSShowFrame());
    }
}

