/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSFillStyle;
import com.flagstone.transform.FSGradient;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSGradientFill
extends FSFillStyle {
    private FSCoordTransform transform = null;
    private ArrayList gradients = null;

    public FSGradientFill(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSGradientFill(int n, FSCoordTransform fSCoordTransform, ArrayList arrayList) {
        super(n);
        this.setTransform(fSCoordTransform);
        this.setGradients(arrayList);
    }

    public FSGradientFill(FSGradientFill fSGradientFill) {
        super(fSGradientFill);
        this.transform = new FSCoordTransform(fSGradientFill.transform);
        this.gradients = new ArrayList(fSGradientFill.gradients.size());
        Iterator iterator = fSGradientFill.gradients.iterator();
        while (iterator.hasNext()) {
            this.gradients.add(((FSGradient)iterator.next()).clone());
        }
    }

    public void add(FSGradient fSGradient) {
        this.gradients.add(fSGradient);
    }

    public FSCoordTransform getTransform() {
        return this.transform;
    }

    public ArrayList getGradients() {
        return this.gradients;
    }

    public void setTransform(FSCoordTransform fSCoordTransform) {
        this.transform = fSCoordTransform;
    }

    public void setGradients(ArrayList arrayList) {
        this.gradients = arrayList;
    }

    public Object clone() {
        FSGradientFill fSGradientFill = (FSGradientFill)super.clone();
        fSGradientFill.transform = this.transform != null ? (FSCoordTransform)this.transform.clone() : null;
        fSGradientFill.gradients = new ArrayList();
        Iterator iterator = this.gradients.iterator();
        while (iterator.hasNext()) {
            fSGradientFill.gradients.add(((FSGradient)iterator.next()).clone());
        }
        return fSGradientFill;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSGradientFill fSGradientFill = (FSGradientFill)object;
            if (this.transform != null) {
                bl = this.transform.equals(fSGradientFill.transform);
            } else {
                boolean bl2 = bl = this.transform == fSGradientFill.transform;
            }
            bl = this.gradients != null ? bl && this.gradients.equals(fSGradientFill.gradients) : bl && this.gradients == fSGradientFill.gradients;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "transform", this.transform, n);
            Transform.append(stringBuffer, "gradients", this.gradients, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = super.length(fSCoder);
        n += this.transform.length(fSCoder);
        ++n;
        Iterator iterator = this.gradients.iterator();
        while (iterator.hasNext()) {
            n += ((FSTransformObject)iterator.next()).length(fSCoder);
        }
        return n;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        this.transform.encode(fSCoder);
        fSCoder.writeWord(this.gradients.size(), 1);
        Iterator iterator = this.gradients.iterator();
        while (iterator.hasNext()) {
            ((FSTransformObject)iterator.next()).encode(fSCoder);
        }
    }

    public void decode(FSCoder fSCoder) {
        int n = 0;
        super.decode(fSCoder);
        this.transform = new FSCoordTransform(fSCoder);
        n = fSCoder.readWord(1, false) & 0xF;
        if (n > 8) {
            n -= 8;
        }
        this.gradients = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.gradients.add(new FSGradient(fSCoder));
        }
    }
}

