/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class FSHeader {
    private String signature = null;
    private int version = 0;
    private int minX = 0;
    private int minY = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int length = 0;
    private float frameRate = 0.0f;
    private int frameCount = 0;

    public FSHeader(String string) throws IOException, DataFormatException {
        this.decodeFromFile(string);
    }

    public FSHeader(File file) throws IOException, DataFormatException {
        this.decodeFromFile(file);
    }

    public FSHeader(byte[] byArray) throws IOException, DataFormatException {
        this.decodeFromData(byArray);
    }

    public String getSignature() {
        return this.signature;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLength() {
        return this.length;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public int getNumberOfFrames() {
        return this.frameCount;
    }

    public void decodeFromFile(String string) throws IOException, DataFormatException {
        this.decodeFromFile(new File(string));
    }

    public void decodeFromFile(File file) throws IOException, DataFormatException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.decodeFromData(byArray);
    }

    public void decodeFromData(byte[] byArray) throws DataFormatException {
        FSCoder fSCoder = null;
        this.isFlash(byArray);
        fSCoder = byArray[0] == 67 ? new FSCoder(0, this.unzip(byArray)) : new FSCoder(0, byArray);
        this.signature = fSCoder.readString(3, "UTF8");
        this.version = fSCoder.readWord(1, false);
        this.length = fSCoder.readWord(4, false);
        fSCoder.alignToByte();
        int n = fSCoder.readBits(5, false);
        this.minX = fSCoder.readBits(n, true);
        this.maxX = fSCoder.readBits(n, true);
        this.minY = fSCoder.readBits(n, true);
        this.maxY = fSCoder.readBits(n, true);
        fSCoder.alignToByte();
        this.frameRate = fSCoder.readFixedWord(1, 1);
        this.frameCount = fSCoder.readWord(2, false);
    }

    private void isFlash(byte[] byArray) throws DataFormatException {
        boolean bl;
        if (byArray == null || byArray.length < 8) {
            throw new DataFormatException("Flash data is null or empty.");
        }
        boolean bl2 = bl = (byArray[0] == 67 || byArray[0] == 70) && byArray[1] == 87 && byArray[2] == 83;
        if (!bl) {
            throw new DataFormatException("Data does not start with a valid Flash signature.");
        }
    }

    private byte[] unzip(byte[] byArray) throws DataFormatException {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n += (byArray[i + 4] & 0xFF) << i * 8;
        }
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < 8; ++i) {
            byArray2[i] = byArray[i];
        }
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, 8, byArray.length - 8);
        inflater.inflate(byArray2, 8, n - 8);
        return byArray2;
    }
}

