/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.Transform;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class FSImageBlock
implements Cloneable {
    private int width;
    private int height;
    private byte[] block;

    public FSImageBlock(int n, int n2, byte[] byArray) {
        this.width = n;
        this.height = n2;
        this.block = byArray;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getData() {
        return this.block;
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0 || this.block == null || this.block.length == 0;
    }

    public Object clone() {
        return new FSImageBlock(this.width, this.height, this.block);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object instanceof FSImageBlock) {
            FSImageBlock fSImageBlock = (FSImageBlock)object;
            try {
                bl = this.width == fSImageBlock.width;
                bl = bl && this.height == fSImageBlock.height;
                byte[] byArray = this.unzip(this.block);
                byte[] byArray2 = this.unzip(fSImageBlock.block);
                bl = bl && Transform.equals(byArray, byArray2);
            }
            catch (DataFormatException dataFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    private byte[] unzip(byte[] byArray) throws DataFormatException {
        byte[] byArray2 = new byte[this.width * this.height * 3];
        int n = 0;
        Inflater inflater = new Inflater();
        inflater.setInput(byArray);
        n = inflater.inflate(byArray2);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }
}

