/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.Transform;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class FSImport
extends FSMovieObject {
    private String url = null;
    private Hashtable objects = new Hashtable();

    FSImport() {
        super(57);
    }

    public FSImport(FSCoder fSCoder) {
        super(57);
        this.decode(fSCoder);
    }

    public FSImport(String string, int n, String string2) {
        super(57);
        this.setUrl(string);
        this.add(n, string2);
    }

    public FSImport(FSImport fSImport) {
        super(fSImport);
        this.url = new String(fSImport.url);
        this.objects = new Hashtable(fSImport.objects.size());
        Iterator iterator = fSImport.objects.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.objects.put(k, new String((String)this.objects.get(k)));
        }
    }

    public void add(int n, String string) {
        this.objects.put(new Integer(n), string);
    }

    public String getUrl() {
        return this.url;
    }

    public Hashtable getObjects() {
        return this.objects;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setObjects(Hashtable hashtable) {
        this.objects = hashtable;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            bl = this.url != null ? this.url.equals(((FSImport)object).getUrl()) : ((FSImport)object).getUrl() == null;
            bl = bl && this.objects.equals(((FSImport)object).getObjects());
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "url", this.url);
            Transform.append(stringBuffer, "objects", this.objects, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += FSCoder.strlen(this.url, true);
        this.length += 2;
        Enumeration enumeration = this.objects.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)this.objects.get(enumeration.nextElement());
            this.length += 2;
            this.length += FSCoder.strlen(string, true);
        }
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeString(this.url);
        fSCoder.writeWord(0, 1);
        fSCoder.writeWord(this.objects.size(), 2);
        Enumeration enumeration = this.objects.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            String string = (String)this.objects.get(n);
            fSCoder.writeWord(n, 2);
            fSCoder.writeString(string);
            fSCoder.writeWord(0, 1);
        }
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        this.url = fSCoder.readString();
        int n = fSCoder.readWord(2, false);
        for (int i = 0; i < n; ++i) {
            int n2 = fSCoder.readWord(2, false);
            String string = fSCoder.readString();
            this.add(n2, string);
        }
        fSCoder.endObject(this.name());
    }
}

