/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSColorTransform;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.FSPlaceObject2;
import com.flagstone.transform.FSRemoveObject2;
import com.flagstone.transform.FSShowFrame;
import java.util.ArrayList;

public final class FSLayer {
    private int layer;
    private int identifier;
    private FSPlaceObject2 place;
    private ArrayList displayList;

    public static ArrayList merge(ArrayList arrayList) {
        ArrayList arrayList2;
        ArrayList<FSMovieObject> arrayList3 = new ArrayList<FSMovieObject>();
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        do {
            arrayList2 = null;
            for (int i = 0; i < nArray.length; ++i) {
                arrayList2 = ((FSLayer)arrayList.get(i)).getObjects();
                while (nArray[i] < arrayList2.size()) {
                    int n = i;
                    int n2 = nArray[n];
                    nArray[n] = n2 + 1;
                    FSMovieObject fSMovieObject = (FSMovieObject)arrayList2.get(n2);
                    if (fSMovieObject.getType() == 1) break;
                    arrayList3.add(fSMovieObject);
                }
                if (nArray[i] != arrayList2.size()) continue;
                arrayList2 = null;
            }
            arrayList3.add(FSShowFrame.getInstance());
        } while (arrayList2 != null);
        return arrayList3;
    }

    public FSLayer(int n) {
        this.layer = n;
        this.identifier = 0;
        this.displayList = new ArrayList();
    }

    public int getLayer() {
        return this.layer;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public ArrayList getObjects() {
        return this.displayList;
    }

    public void add(FSDefineObject fSDefineObject) {
        this.displayList.add(fSDefineObject);
    }

    public void select(int n) {
        this.identifier = n;
        this.place = new FSPlaceObject2(n, this.layer, 0, 0);
        this.displayList.add(this.place);
    }

    public void select(FSDefineObject fSDefineObject) {
        this.add(fSDefineObject);
        this.select(fSDefineObject.getIdentifier());
    }

    public void move(int n, int n2) {
        if (this.place == null) {
            this.place = new FSPlaceObject2(this.layer, n, n2);
            this.displayList.add(this.place);
        } else {
            this.place.setTransform(new FSCoordTransform(n, n2));
        }
    }

    public void color(int n, int n2, int n3) {
        this.color(n, n2, n3, 255);
    }

    public void color(int n, int n2, int n3, int n4) {
        if (this.place == null) {
            this.place = new FSPlaceObject2(this.layer, new FSColorTransform(n, n2, n3, n4));
            this.displayList.add(this.place);
        } else {
            this.place.setColorTransform(new FSColorTransform(n, n2, n3, n4));
        }
    }

    public void clip(int n) {
        if (this.place == null) {
            this.place = new FSPlaceObject2(this.layer, (FSCoordTransform)null);
            this.place.setClippingDepth(n);
            this.displayList.add(this.place);
        } else {
            this.place.setClippingDepth(n);
        }
    }

    public void morph(float f) {
        if (this.place == null) {
            this.place = new FSPlaceObject2(this.layer, f, null);
            this.displayList.add(this.place);
        } else {
            this.place.setRatio(f);
        }
    }

    public void name(String string) {
        if (this.place == null) {
            this.place = new FSPlaceObject2(this.layer, (FSCoordTransform)null);
            this.place.setName(string);
            this.displayList.add(this.place);
        } else {
            this.place.setName(string);
        }
    }

    public void remove() {
        if (this.place != null) {
            this.place = null;
        }
        this.displayList.add(new FSRemoveObject2(this.layer));
    }

    public void replace(int n) {
        this.identifier = n;
        if (this.place == null) {
            this.place = new FSPlaceObject2(n, this.layer);
            this.displayList.add(this.place);
        } else {
            this.place.setIdentifier(n);
            this.place.setPlaceType(3);
        }
    }

    public void change(FSColorTransform fSColorTransform) {
        if (this.place == null) {
            this.place = new FSPlaceObject2(this.layer, fSColorTransform);
            this.displayList.add(this.place);
        } else {
            this.place.setColorTransform(fSColorTransform);
        }
    }

    public void change(FSCoordTransform fSCoordTransform) {
        if (this.place == null) {
            this.place = new FSPlaceObject2(this.layer, fSCoordTransform);
            this.displayList.add(this.place);
        } else {
            this.place.setTransform(fSCoordTransform);
        }
    }

    public void show() {
        this.show(1);
    }

    public void show(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Must show at least one frame");
        }
        if (this.place != null) {
            this.place = null;
        }
        for (int i = 0; i < n; ++i) {
            this.displayList.add(FSShowFrame.getInstance());
        }
    }
}

