/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSColor;
import com.flagstone.transform.FSLineStyle;
import com.flagstone.transform.Transform;

public class FSMorphSolidLine
extends FSLineStyle {
    private int startWidth = 0;
    private int endWidth = 0;
    private FSColor startColor = null;
    private FSColor endColor = null;

    public FSMorphSolidLine(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSMorphSolidLine(int n, int n2, FSColor fSColor, FSColor fSColor2) {
        this.setStartWidth(n);
        this.setEndWidth(n2);
        this.setStartColor(fSColor);
        this.setEndColor(fSColor2);
    }

    public FSMorphSolidLine(FSMorphSolidLine fSMorphSolidLine) {
        this.startWidth = fSMorphSolidLine.startWidth;
        this.endWidth = fSMorphSolidLine.endWidth;
        this.startColor = new FSColor(fSMorphSolidLine.startColor);
        this.endColor = new FSColor(fSMorphSolidLine.endColor);
    }

    public int getStartWidth() {
        return this.startWidth;
    }

    public int getEndWidth() {
        return this.endWidth;
    }

    public FSColor getStartColor() {
        return this.startColor;
    }

    public FSColor getEndColor() {
        return this.endColor;
    }

    public void setStartWidth(int n) {
        this.startWidth = n;
    }

    public void setEndWidth(int n) {
        this.endWidth = n;
    }

    public void setStartColor(FSColor fSColor) {
        this.startColor = fSColor;
    }

    public void setEndColor(FSColor fSColor) {
        this.endColor = fSColor;
    }

    public Object clone() {
        FSMorphSolidLine fSMorphSolidLine = (FSMorphSolidLine)super.clone();
        fSMorphSolidLine.startColor = this.startColor != null ? (FSColor)this.startColor.clone() : null;
        fSMorphSolidLine.endColor = this.endColor != null ? (FSColor)this.endColor.clone() : null;
        return fSMorphSolidLine;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSMorphSolidLine fSMorphSolidLine = (FSMorphSolidLine)object;
            bl = this.startWidth == fSMorphSolidLine.startWidth;
            boolean bl2 = bl = bl && this.endWidth == fSMorphSolidLine.endWidth;
            if (this.startColor != null) {
                bl = bl && this.startColor.equals(fSMorphSolidLine.startColor);
            } else {
                boolean bl3 = bl = bl && this.startColor == fSMorphSolidLine.startColor;
            }
            bl = this.endColor != null ? bl && this.endColor.equals(fSMorphSolidLine.endColor) : bl && this.endColor == fSMorphSolidLine.endColor;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "startWidth", this.startWidth);
            Transform.append(stringBuffer, "endWidth", this.endWidth);
            Transform.append(stringBuffer, "startColor", this.startColor, n);
            Transform.append(stringBuffer, "endColor", this.endColor, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = 4;
        n += this.startColor.length(fSCoder);
        return n += this.endColor.length(fSCoder);
    }

    public void encode(FSCoder fSCoder) {
        fSCoder.writeWord(this.startWidth, 2);
        fSCoder.writeWord(this.endWidth, 2);
        this.startColor.encode(fSCoder);
        this.endColor.encode(fSCoder);
    }

    public void decode(FSCoder fSCoder) {
        this.startWidth = fSCoder.readWord(2, false);
        this.endWidth = fSCoder.readWord(2, false);
        this.startColor = new FSColor(fSCoder);
        this.endColor = new FSColor(fSCoder);
    }
}

