/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSActionObject;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSNewFunction
extends FSActionObject {
    private String name = null;
    private ArrayList arguments = null;
    private ArrayList actions = null;
    private int actionsLength = 0;

    FSNewFunction() {
        super(155);
    }

    public FSNewFunction(FSCoder fSCoder) {
        super(155);
        this.decode(fSCoder);
    }

    public FSNewFunction(String string, ArrayList arrayList, ArrayList arrayList2) {
        super(155);
        this.setName(string);
        this.setArguments(arrayList);
        this.setActions(arrayList2);
    }

    public FSNewFunction(ArrayList arrayList, ArrayList arrayList2) {
        super(155);
        this.setArguments(arrayList);
        this.setActions(arrayList2);
    }

    public FSNewFunction(FSNewFunction fSNewFunction) {
        super(fSNewFunction);
        Iterator iterator;
        if (fSNewFunction.name != null) {
            this.name = new String(fSNewFunction.name);
        }
        if (fSNewFunction.arguments != null) {
            this.arguments = new ArrayList(fSNewFunction.arguments.size());
            iterator = fSNewFunction.arguments.iterator();
            while (iterator.hasNext()) {
                this.arguments.add(new String(iterator.next().toString()));
            }
        }
        if (fSNewFunction.actions != null) {
            this.actions = new ArrayList(fSNewFunction.actions.size());
            iterator = fSNewFunction.actions.iterator();
            while (iterator.hasNext()) {
                this.actions.add(((FSActionObject)iterator.next()).clone());
            }
        }
    }

    public void add(String string) {
        this.arguments.add(string);
    }

    public void add(FSActionObject fSActionObject) {
        this.actions.add(fSActionObject);
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getArguments() {
        return this.arguments;
    }

    public ArrayList getActions() {
        return this.actions;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setArguments(ArrayList arrayList) {
        this.arguments = arrayList;
    }

    public void setActions(ArrayList arrayList) {
        this.actions = arrayList;
    }

    public Object clone() {
        FSNewFunction fSNewFunction = (FSNewFunction)super.clone();
        fSNewFunction.arguments = new ArrayList();
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            fSNewFunction.arguments.add(new String((String)iterator.next()));
        }
        fSNewFunction.actions = new ArrayList();
        iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            fSNewFunction.actions.add(((FSActionObject)iterator.next()).clone());
        }
        return fSNewFunction;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSNewFunction fSNewFunction = (FSNewFunction)object;
            if (this.name != null) {
                bl = this.name.equals(fSNewFunction.name);
            } else {
                boolean bl2 = bl = this.name == fSNewFunction.name;
            }
            if (this.arguments != null) {
                bl = bl && this.arguments.equals(fSNewFunction.arguments);
            } else {
                boolean bl3 = bl = bl && this.arguments == fSNewFunction.arguments;
            }
            bl = this.actions != null ? bl && this.actions.equals(fSNewFunction.actions) : bl && this.actions == fSNewFunction.actions;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "name", this.name);
            Transform.append(stringBuffer, "arguments", this.arguments, n);
            Transform.append(stringBuffer, "actions", this.actions, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n;
        super.length(fSCoder);
        this.length += this.name != null ? FSCoder.strlen(this.name, true) : 1;
        this.length += 2;
        if (this.arguments.size() > 0) {
            for (n = 0; n < this.arguments.size(); ++n) {
                this.length += FSCoder.strlen((String)this.arguments.get(n), true);
            }
        }
        this.length += 2;
        this.actionsLength = 0;
        for (n = 0; n < this.actions.size(); ++n) {
            FSActionObject fSActionObject = (FSActionObject)this.actions.get(n);
            this.actionsLength += fSActionObject.length(fSCoder);
            this.actionsLength += fSActionObject.getType() > 128 ? 3 : 1;
        }
        this.length += this.actionsLength;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        fSCoder.beginObject(this.name());
        fSCoder.writeWord(this.type, 1);
        fSCoder.writeWord(this.length - this.actionsLength, 2);
        if (this.name != null) {
            fSCoder.writeString(this.name);
        }
        fSCoder.writeWord(0, 1);
        fSCoder.writeWord(this.arguments.size(), 2);
        if (this.arguments.size() > 0) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                fSCoder.writeString((String)this.arguments.get(i));
                fSCoder.writeWord(0, 1);
            }
        }
        fSCoder.writeWord(this.actionsLength, 2);
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            FSActionObject fSActionObject = (FSActionObject)iterator.next();
            int n = fSCoder.getPointer();
            int n2 = fSCoder.getPointer() + (fSActionObject.getType() > 128 ? 24 : 8);
            int n3 = n2 + (fSActionObject.getLength() << 3);
            fSActionObject.encode(fSCoder);
            fSCoder.setPointer(n3);
            int n4 = fSCoder.getPointer() - n3 >> 3;
            if (n4 == 0) continue;
            fSCoder.context[14] = 1;
            fSCoder.context[15] = fSActionObject.getType();
            fSCoder.context[16] = n >>> 3;
            fSCoder.context[17] = n3 - n >>> 3;
            fSCoder.context[13] = n4;
        }
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        int n = 0;
        int n2 = 0;
        this.arguments = new ArrayList();
        this.actions = new ArrayList();
        super.decode(fSCoder);
        this.name = fSCoder.readString();
        n = fSCoder.readWord(2, false);
        if (n > 0) {
            for (int i = n; i > 0; --i) {
                this.arguments.add(fSCoder.readString());
            }
        }
        this.actionsLength = fSCoder.readWord(2, false);
        this.length += this.actionsLength;
        while (n2 < this.actionsLength) {
            FSActionObject fSActionObject = FSMovie.decodeAction(fSCoder);
            n2 += fSActionObject.getLength() + (fSActionObject.getType() >= 128 ? 3 : 1);
            this.actions.add(fSActionObject);
        }
        fSCoder.endObject(this.name());
    }
}

