/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSActionObject;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSRegisterVariable;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSNewFunction2
extends FSActionObject {
    public static final int CreateSuper = 4;
    public static final int CreateArguments = 16;
    public static final int CreateThis = 64;
    public static final int LoadThis = 128;
    public static final int LoadArguments = 32;
    public static final int LoadSuper = 8;
    public static final int LoadRoot = 2;
    public static final int LoadParent = 1;
    public static final int LoadGlobal = 32768;
    private String name = null;
    private int registerCount = 0;
    private int optimizations = 0;
    private ArrayList arguments = null;
    private ArrayList actions = null;
    private int _actionsLength = 0;

    public FSNewFunction2(FSCoder fSCoder) {
        super(142);
        this.decode(fSCoder);
    }

    public FSNewFunction2(String string, ArrayList arrayList, ArrayList arrayList2) {
        super(142);
        this.setName(string);
        this.setArguments(arrayList);
        this.setActions(arrayList2);
    }

    public FSNewFunction2(ArrayList arrayList, ArrayList arrayList2) {
        super(142);
        this.setArguments(arrayList);
        this.setActions(arrayList2);
    }

    public FSNewFunction2(FSNewFunction2 fSNewFunction2) {
        super(fSNewFunction2);
        Iterator iterator;
        if (fSNewFunction2.name != null) {
            this.name = new String(fSNewFunction2.name);
        }
        this.registerCount = fSNewFunction2.registerCount;
        this.optimizations = fSNewFunction2.optimizations;
        if (fSNewFunction2.arguments != null) {
            this.arguments = new ArrayList(fSNewFunction2.arguments.size());
            iterator = fSNewFunction2.arguments.iterator();
            while (iterator.hasNext()) {
                this.arguments.add(new String(iterator.next().toString()));
            }
        }
        if (fSNewFunction2.actions != null) {
            this.actions = new ArrayList(fSNewFunction2.actions.size());
            iterator = fSNewFunction2.actions.iterator();
            while (iterator.hasNext()) {
                this.actions.add(((FSActionObject)iterator.next()).clone());
            }
        }
    }

    public void add(FSRegisterVariable fSRegisterVariable) {
        this.arguments.add(fSRegisterVariable);
    }

    public void add(FSActionObject fSActionObject) {
        this.actions.add(fSActionObject);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getRegisterCount() {
        return this.registerCount;
    }

    public void setRegisterCount(int n) {
        this.registerCount = n;
    }

    public int getOptimizations() {
        return this.optimizations;
    }

    public void setOptimizations(int n) {
        this.optimizations = n;
    }

    public ArrayList getArguments() {
        return this.arguments;
    }

    public void setArguments(ArrayList arrayList) {
        this.arguments = arrayList;
    }

    public ArrayList getActions() {
        return this.actions;
    }

    public void setActions(ArrayList arrayList) {
        this.actions = arrayList;
    }

    public Object clone() {
        FSNewFunction2 fSNewFunction2 = (FSNewFunction2)super.clone();
        fSNewFunction2.arguments = new ArrayList();
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            fSNewFunction2.arguments.add((FSRegisterVariable)((FSRegisterVariable)iterator.next()).clone());
        }
        fSNewFunction2.actions = new ArrayList();
        iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            fSNewFunction2.actions.add(((FSActionObject)iterator.next()).clone());
        }
        return fSNewFunction2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSNewFunction2 fSNewFunction2 = (FSNewFunction2)object;
            bl = this.name != null ? this.name.equals(fSNewFunction2.name) : this.name == fSNewFunction2.name;
            bl = bl && this.registerCount == fSNewFunction2.registerCount;
            boolean bl2 = bl = bl && this.optimizations == fSNewFunction2.optimizations;
            if (this.arguments != null) {
                bl = bl && this.arguments.equals(fSNewFunction2.arguments);
            } else {
                boolean bl3 = bl = bl && this.arguments == fSNewFunction2.arguments;
            }
            bl = this.actions != null ? bl && this.actions.equals(fSNewFunction2.actions) : bl && this.actions == fSNewFunction2.actions;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "name", this.name);
            Transform.append(stringBuffer, "registerCount", this.registerCount);
            Transform.append(stringBuffer, "optimizations", this.optimizations);
            Transform.append(stringBuffer, "arguments", this.arguments, n);
            Transform.append(stringBuffer, "actions", this.actions, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += this.name != null ? FSCoder.strlen(this.name, true) : 1;
        this.length += 5;
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.length += ((FSRegisterVariable)this.arguments.get(i)).length(fSCoder);
        }
        this.length += 2;
        this._actionsLength = 0;
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            FSActionObject fSActionObject = (FSActionObject)iterator.next();
            this._actionsLength += fSActionObject.length(fSCoder);
            this._actionsLength += fSActionObject.getType() > 128 ? 3 : 1;
        }
        this.length += this._actionsLength;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        fSCoder.beginObject(this.name());
        fSCoder.writeWord(this.type, 1);
        fSCoder.writeWord(this.length - this._actionsLength, 2);
        if (this.name != null) {
            fSCoder.writeString(this.name);
        }
        fSCoder.writeWord(0, 1);
        fSCoder.writeWord(this.arguments.size(), 2);
        fSCoder.writeWord(this.registerCount, 1);
        fSCoder.writeBits(this.optimizations, 16);
        Iterator iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            ((FSRegisterVariable)iterator.next()).encode(fSCoder);
        }
        fSCoder.writeWord(this._actionsLength, 2);
        iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            FSActionObject fSActionObject = (FSActionObject)iterator.next();
            int n = fSCoder.getPointer();
            int n2 = fSCoder.getPointer() + (fSActionObject.getType() > 128 ? 24 : 8);
            int n3 = n2 + (fSActionObject.getLength() << 3);
            fSActionObject.encode(fSCoder);
            fSCoder.setPointer(n3);
            int n4 = fSCoder.getPointer() - n3 >> 3;
            if (n4 == 0) continue;
            fSCoder.context[14] = 1;
            fSCoder.context[15] = fSActionObject.getType();
            fSCoder.context[16] = n >>> 3;
            fSCoder.context[17] = n3 - n >>> 3;
            fSCoder.context[13] = n4;
        }
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        int n = 0;
        int n2 = 0;
        this.arguments = new ArrayList();
        this.actions = new ArrayList();
        super.decode(fSCoder);
        this.name = fSCoder.readString();
        n = fSCoder.readWord(2, false);
        this.registerCount = fSCoder.readWord(1, false);
        this.optimizations = fSCoder.readBits(16, false);
        for (int i = 0; i < n; ++i) {
            this.arguments.add(new FSRegisterVariable(fSCoder));
        }
        this._actionsLength = fSCoder.readWord(2, false);
        this.length += this._actionsLength;
        while (n2 < this._actionsLength) {
            FSActionObject fSActionObject = FSMovie.decodeAction(fSCoder);
            n2 += fSActionObject.getLength() + (fSActionObject.getType() >= 128 ? 3 : 1);
            this.actions.add(fSActionObject);
        }
        fSCoder.endObject(this.name());
    }
}

