/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSImageBlock;
import java.util.ArrayList;
import java.util.Iterator;

public final class FSScreenVideoPacket
implements Cloneable {
    private boolean keyFrame;
    private int codec;
    private int blockWidth;
    private int blockHeight;
    private int imageWidth;
    private int imageHeight;
    private ArrayList imageBlocks;

    public FSScreenVideoPacket(byte[] byArray) {
        this.decode(byArray);
    }

    public FSScreenVideoPacket(boolean bl, int n, int n2, int n3, int n4, int n5, ArrayList arrayList) {
        this.setKeyFrame(bl);
        this.setCodec(n);
        this.setImageWidth(n2);
        this.setImageHeight(n3);
        this.setBlockWidth(n4);
        this.setBlockHeight(n5);
        this.setImageBlocks(arrayList);
    }

    public void add(FSImageBlock fSImageBlock) {
        this.imageBlocks.add(fSImageBlock);
    }

    public boolean getKeyFrame() {
        return this.keyFrame;
    }

    public void setKeyFrame(boolean bl) {
        this.keyFrame = bl;
    }

    public int getCodec() {
        return this.codec;
    }

    public void setCodec(int n) {
        this.codec = n;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int n) {
        this.imageWidth = n;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int n) {
        this.imageHeight = n;
    }

    public int getBlockWidth() {
        return this.blockWidth;
    }

    public void setBlockWidth(int n) {
        this.blockWidth = n;
    }

    public int getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(int n) {
        this.blockHeight = n;
    }

    public ArrayList getImageBlocks() {
        return this.imageBlocks;
    }

    public void setImageBlocks(ArrayList arrayList) {
        this.imageBlocks = new ArrayList(arrayList);
    }

    public Object clone() {
        FSScreenVideoPacket fSScreenVideoPacket = null;
        try {
            fSScreenVideoPacket = (FSScreenVideoPacket)super.clone();
            fSScreenVideoPacket.imageBlocks = new ArrayList();
            Iterator iterator = this.imageBlocks.iterator();
            while (iterator.hasNext()) {
                fSScreenVideoPacket.imageBlocks.add(((FSImageBlock)iterator.next()).clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return fSScreenVideoPacket;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSScreenVideoPacket fSScreenVideoPacket = (FSScreenVideoPacket)object;
            bl = this.keyFrame == fSScreenVideoPacket.keyFrame;
            bl = bl && this.codec == fSScreenVideoPacket.codec;
            bl = bl && this.imageWidth == fSScreenVideoPacket.imageWidth;
            bl = bl && this.imageHeight == fSScreenVideoPacket.imageHeight;
            bl = bl && this.blockHeight == fSScreenVideoPacket.blockHeight;
            bl = bl && this.blockWidth == fSScreenVideoPacket.blockWidth;
            bl = bl && this.imageBlocks.equals(fSScreenVideoPacket.imageBlocks);
        }
        return bl;
    }

    private int length() {
        int n = 5;
        Iterator iterator = this.imageBlocks.iterator();
        while (iterator.hasNext()) {
            FSImageBlock fSImageBlock = (FSImageBlock)iterator.next();
            n += 2;
            if (fSImageBlock.isEmpty()) continue;
            n += fSImageBlock.getData().length;
        }
        return n;
    }

    public byte[] encode() {
        byte[] byArray = new byte[this.length()];
        FSCoder fSCoder = new FSCoder(0, byArray);
        fSCoder.writeBits(this.keyFrame ? 1 : 2, 4);
        fSCoder.writeBits(this.codec, 4);
        fSCoder.writeBits(this.blockWidth / 16 - 1, 4);
        fSCoder.writeBits(this.imageWidth, 12);
        fSCoder.writeBits(this.blockHeight / 16 - 1, 4);
        fSCoder.writeBits(this.imageHeight, 12);
        Iterator iterator = this.imageBlocks.iterator();
        while (iterator.hasNext()) {
            FSImageBlock fSImageBlock = (FSImageBlock)iterator.next();
            if (fSImageBlock.isEmpty()) {
                fSCoder.writeWord(0, 2);
                continue;
            }
            byte[] byArray2 = fSImageBlock.getData();
            fSCoder.writeBits(byArray2.length, 16);
            fSCoder.writeBytes(byArray2);
        }
        return fSCoder.getData();
    }

    public void decode(byte[] byArray) {
        FSCoder fSCoder = new FSCoder(0, byArray);
        this.keyFrame = fSCoder.readBits(4, false) == 1;
        this.codec = fSCoder.readBits(4, false);
        this.blockWidth = (fSCoder.readBits(4, false) + 1) * 16;
        this.imageWidth = fSCoder.readBits(12, false);
        this.blockHeight = (fSCoder.readBits(4, false) + 1) * 16;
        this.imageHeight = fSCoder.readBits(12, false);
        int n = this.imageWidth / this.blockWidth + (this.imageWidth % this.blockWidth > 0 ? 1 : 0);
        int n2 = this.imageHeight / this.blockHeight + (this.imageHeight % this.blockHeight > 0 ? 1 : 0);
        int n3 = this.imageHeight;
        int n4 = this.imageWidth;
        this.imageBlocks = new ArrayList(n2 * n);
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n) {
                FSImageBlock fSImageBlock;
                int n7 = fSCoder.readBits(16, false);
                if (n7 != 0) {
                    byte[] byArray2 = new byte[n7];
                    fSCoder.readBytes(byArray2);
                    int n8 = n3 < this.blockHeight ? n3 : this.blockHeight;
                    int n9 = n4 < this.blockWidth ? n4 : this.blockWidth;
                    fSImageBlock = new FSImageBlock(n8, n9, byArray2);
                } else {
                    fSImageBlock = new FSImageBlock(0, 0, null);
                }
                this.imageBlocks.add(fSImageBlock);
                ++n6;
                n4 -= this.blockWidth;
            }
            ++n5;
            n3 -= this.blockHeight;
        }
    }
}

