/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSColor;
import com.flagstone.transform.FSLineStyle;
import com.flagstone.transform.Transform;

public class FSSolidLine
extends FSLineStyle {
    private int width = 0;
    private FSColor color = null;

    public FSSolidLine(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSSolidLine(int n, FSColor fSColor) {
        this.setWidth(n);
        this.setColor(fSColor);
    }

    public FSSolidLine(FSSolidLine fSSolidLine) {
        this.width = fSSolidLine.width;
        this.color = new FSColor(fSSolidLine.color);
    }

    public int getWidth() {
        return this.width;
    }

    public FSColor getColor() {
        return this.color;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setColor(FSColor fSColor) {
        this.color = fSColor;
    }

    public Object clone() {
        FSSolidLine fSSolidLine = (FSSolidLine)super.clone();
        fSSolidLine.color = this.color != null ? (FSColor)this.color.clone() : null;
        return fSSolidLine;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSSolidLine fSSolidLine = (FSSolidLine)object;
            boolean bl2 = bl = this.width == fSSolidLine.width;
            bl = this.color != null ? bl && this.color.equals(fSSolidLine.color) : bl && this.color == fSSolidLine.color;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "width", this.width);
            Transform.append(stringBuffer, "color", this.color, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = 2;
        return n += this.color.length(fSCoder);
    }

    public void encode(FSCoder fSCoder) {
        fSCoder.writeWord(this.width, 2);
        this.color.encode(fSCoder);
    }

    public void decode(FSCoder fSCoder) {
        this.width = fSCoder.readWord(2, false);
        this.color = new FSColor(fSCoder);
    }
}

