/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSEnvelope;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSSound
extends FSTransformObject {
    public static final int NATIVE_PCM = 0;
    public static final int ADPCM = 1;
    public static final int MP3 = 2;
    public static final int PCM = 3;
    public static final int NELLYMOSER = 6;
    public static final int Start = 0;
    public static final int Continue = 1;
    public static final int Stop = 2;
    private int identifier = 0;
    private int mode = 0;
    private int inPoint = 0;
    private int outPoint = 0;
    private int loopCount = 0;
    private ArrayList envelopes = null;

    public FSSound(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSSound(int n, int n2) {
        this.setIdentifier(n);
        this.setMode(n2);
    }

    public FSSound(int n, int n2, int n3) {
        this.setIdentifier(n);
        this.setMode(n2);
        this.setLoopCount(n3);
    }

    public FSSound(int n, int n2, int n3, int n4) {
        this.setIdentifier(n);
        this.setMode(n2);
        this.setInPoint(n3);
        this.setOutPoint(n4);
    }

    public FSSound(int n, int n2, int n3, int n4, int n5) {
        this.setIdentifier(n);
        this.setMode(n2);
        this.setInPoint(n3);
        this.setOutPoint(n4);
        this.setLoopCount(n5);
    }

    public FSSound(int n, int n2, int n3, int n4, int n5, ArrayList arrayList) {
        this.setIdentifier(n);
        this.setMode(n2);
        this.setInPoint(n3);
        this.setOutPoint(n4);
        this.setLoopCount(n5);
        this.setEnvelopes(arrayList);
    }

    public FSSound(FSSound fSSound) {
        this.identifier = fSSound.identifier;
        this.mode = fSSound.mode;
        this.inPoint = fSSound.inPoint;
        this.outPoint = fSSound.outPoint;
        this.loopCount = fSSound.loopCount;
        this.envelopes = new ArrayList();
        Iterator iterator = fSSound.envelopes.iterator();
        while (iterator.hasNext()) {
            this.envelopes.add(((FSEnvelope)iterator.next()).clone());
        }
    }

    public void add(FSEnvelope fSEnvelope) {
        this.envelopes.add(fSEnvelope);
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public int getMode() {
        return this.mode;
    }

    public int getInPoint() {
        return this.inPoint;
    }

    public int getOutPoint() {
        return this.outPoint;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public ArrayList getEnvelopes() {
        return this.envelopes;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setInPoint(int n) {
        this.inPoint = n;
    }

    public void setOutPoint(int n) {
        this.outPoint = n;
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
    }

    public void setEnvelopes(ArrayList arrayList) {
        this.envelopes = arrayList;
    }

    public Object clone() {
        FSSound fSSound = (FSSound)super.clone();
        fSSound.envelopes = new ArrayList();
        Iterator iterator = this.envelopes.iterator();
        while (iterator.hasNext()) {
            fSSound.envelopes.add(((FSEnvelope)iterator.next()).clone());
        }
        return fSSound;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSSound fSSound = (FSSound)object;
            bl = this.identifier == fSSound.identifier;
            bl = bl && this.mode == fSSound.mode;
            bl = bl && this.inPoint == fSSound.inPoint;
            bl = bl && this.outPoint == fSSound.outPoint;
            boolean bl2 = bl = bl && this.loopCount == fSSound.loopCount;
            bl = this.envelopes != null ? bl && this.envelopes.equals(fSSound.envelopes) : bl && this.envelopes == fSSound.envelopes;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "identifier", this.identifier);
            Transform.append(stringBuffer, "mode", this.mode);
            Transform.append(stringBuffer, "inPoint", this.inPoint);
            Transform.append(stringBuffer, "outPoint", this.outPoint);
            Transform.append(stringBuffer, "loopCount", this.loopCount);
            Transform.append(stringBuffer, "envelopes", this.envelopes, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        boolean bl = this.containsInPoint();
        boolean bl2 = this.containsOutPoint();
        boolean bl3 = this.containsLoopCount();
        boolean bl4 = this.containsEnvelopes();
        int n = 3;
        n += bl ? 4 : 0;
        n += bl2 ? 4 : 0;
        n += bl3 ? 2 : 0;
        n += bl4 ? 1 : 0;
        return n += bl4 ? this.envelopes.size() * 8 : 0;
    }

    public void encode(FSCoder fSCoder) {
        boolean bl = this.containsInPoint();
        boolean bl2 = this.containsOutPoint();
        boolean bl3 = this.containsLoopCount();
        boolean bl4 = this.containsEnvelopes();
        fSCoder.writeWord(this.identifier, 2);
        fSCoder.writeBits(this.mode, 4);
        fSCoder.writeBits(bl4 ? 1 : 0, 1);
        fSCoder.writeBits(bl3 ? 1 : 0, 1);
        fSCoder.writeBits(bl2 ? 1 : 0, 1);
        fSCoder.writeBits(bl ? 1 : 0, 1);
        if (bl) {
            fSCoder.writeWord(this.inPoint, 4);
        }
        if (bl2) {
            fSCoder.writeWord(this.outPoint, 4);
        }
        if (bl3) {
            fSCoder.writeWord(this.loopCount, 2);
        }
        if (bl4) {
            fSCoder.writeWord(this.envelopes.size(), 1);
            for (int i = 0; i < this.envelopes.size(); ++i) {
                ((FSTransformObject)this.envelopes.get(i)).encode(fSCoder);
            }
        }
    }

    public void decode(FSCoder fSCoder) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.envelopes = new ArrayList();
        int n = 0;
        this.identifier = fSCoder.readWord(2, false);
        this.mode = fSCoder.readBits(4, false);
        bl4 = fSCoder.readBits(1, false) != 0;
        bl3 = fSCoder.readBits(1, false) != 0;
        bl2 = fSCoder.readBits(1, false) != 0;
        boolean bl5 = bl = fSCoder.readBits(1, false) != 0;
        if (bl) {
            this.inPoint = fSCoder.readWord(4, false);
        }
        if (bl2) {
            this.outPoint = fSCoder.readWord(4, false);
        }
        if (bl3) {
            this.loopCount = fSCoder.readWord(2, false);
        }
        if (bl4) {
            n = fSCoder.readWord(1, false);
            for (int i = 0; i < n; ++i) {
                this.envelopes.add(new FSEnvelope(fSCoder));
            }
        }
    }

    private boolean containsInPoint() {
        return this.inPoint != 0;
    }

    private boolean containsOutPoint() {
        return this.outPoint != 0;
    }

    private boolean containsLoopCount() {
        return this.loopCount != 0;
    }

    private boolean containsEnvelopes() {
        return this.envelopes != null && this.envelopes.size() > 0;
    }
}

