/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.Transform;

public class FSSoundStreamBlock
extends FSMovieObject {
    private byte[] soundData = null;

    public FSSoundStreamBlock(FSCoder fSCoder) {
        super(19);
        this.decode(fSCoder);
    }

    public FSSoundStreamBlock(byte[] byArray) {
        super(19);
        this.setSoundData(byArray);
    }

    public FSSoundStreamBlock(FSSoundStreamBlock fSSoundStreamBlock) {
        super(fSSoundStreamBlock);
        this.soundData = Transform.clone(fSSoundStreamBlock.soundData);
    }

    public byte[] getSoundData() {
        return this.soundData;
    }

    public void setSoundData(byte[] byArray) {
        this.soundData = byArray;
    }

    public Object clone() {
        FSSoundStreamBlock fSSoundStreamBlock = (FSSoundStreamBlock)super.clone();
        fSSoundStreamBlock.soundData = Transform.clone(this.soundData);
        return fSSoundStreamBlock;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSSoundStreamBlock fSSoundStreamBlock = (FSSoundStreamBlock)object;
            bl = Transform.equals(this.soundData, fSSoundStreamBlock.soundData);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "soundData", "<data>");
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += this.soundData.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeBytes(this.soundData);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        this.soundData = new byte[this.length];
        fSCoder.readBytes(this.soundData);
        fSCoder.endObject(this.name());
    }
}

