/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.Transform;

public class FSSoundStreamHead
extends FSMovieObject {
    private int format = 1;
    private int playbackRate = 5512;
    private int playbackChannels = 1;
    private int playbackSampleSize = 16;
    private int streamRate = 5512;
    private int streamChannels = 1;
    private int streamSampleSize = 16;
    private int streamSampleCount = 0;
    private int latency = 0;

    public FSSoundStreamHead(FSCoder fSCoder) {
        super(18);
        this.decode(fSCoder);
    }

    public FSSoundStreamHead(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(18);
        this.setPlaybackRate(n);
        this.setPlaybackChannels(n2);
        this.setPlaybackSampleSize(n3);
        this.setStreamRate(n4);
        this.setStreamChannels(n5);
        this.setStreamSampleSize(n6);
        this.setStreamSampleCount(n7);
        this.setLatency(n8);
    }

    public FSSoundStreamHead(FSSoundStreamHead fSSoundStreamHead) {
        super(fSSoundStreamHead);
        this.format = fSSoundStreamHead.format;
        this.playbackRate = fSSoundStreamHead.playbackRate;
        this.playbackChannels = fSSoundStreamHead.playbackChannels;
        this.playbackSampleSize = fSSoundStreamHead.playbackSampleSize;
        this.streamRate = fSSoundStreamHead.streamRate;
        this.streamChannels = fSSoundStreamHead.streamChannels;
        this.streamSampleSize = fSSoundStreamHead.streamSampleSize;
        this.streamSampleCount = fSSoundStreamHead.streamSampleCount;
        this.latency = fSSoundStreamHead.latency;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public int getPlaybackRate() {
        return this.playbackRate;
    }

    public int getPlaybackChannels() {
        return this.playbackChannels;
    }

    public int getPlaybackSampleSize() {
        return this.playbackSampleSize;
    }

    public float getStreamRate() {
        return this.streamRate;
    }

    public int getStreamChannels() {
        return this.streamChannels;
    }

    public int getStreamSampleSize() {
        return this.streamSampleSize;
    }

    public int getStreamSampleCount() {
        return this.streamSampleCount;
    }

    public void setPlaybackRate(int n) {
        this.playbackRate = n;
    }

    public void setPlaybackChannels(int n) {
        this.playbackChannels = n;
    }

    public void setPlaybackSampleSize(int n) {
        this.playbackSampleSize = n;
    }

    public void setStreamRate(int n) {
        this.streamRate = n;
    }

    public void setStreamChannels(int n) {
        this.streamChannels = n;
    }

    public void setStreamSampleSize(int n) {
        this.streamSampleSize = n;
    }

    public void setStreamSampleCount(int n) {
        this.streamSampleCount = n;
    }

    public int getLatency() {
        return this.latency;
    }

    public void setLatency(int n) {
        this.latency = n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSSoundStreamHead fSSoundStreamHead = (FSSoundStreamHead)object;
            bl = this.format == fSSoundStreamHead.format;
            bl = bl && this.playbackRate == fSSoundStreamHead.playbackRate;
            bl = bl && this.playbackChannels == fSSoundStreamHead.playbackChannels;
            bl = bl && this.playbackSampleSize == fSSoundStreamHead.playbackSampleSize;
            bl = bl && this.streamRate == fSSoundStreamHead.streamRate;
            bl = bl && this.streamChannels == fSSoundStreamHead.streamChannels;
            bl = bl && this.streamSampleSize == fSSoundStreamHead.streamSampleSize;
            bl = bl && this.streamSampleCount == fSSoundStreamHead.streamSampleCount;
            bl = bl && this.latency == fSSoundStreamHead.latency;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "format", this.format);
            Transform.append(stringBuffer, "playbackRate", this.playbackRate);
            Transform.append(stringBuffer, "playbackChannels", this.playbackChannels);
            Transform.append(stringBuffer, "playbackSampleSize", this.playbackSampleSize);
            Transform.append(stringBuffer, "streamRate", this.streamRate);
            Transform.append(stringBuffer, "streamChannels", this.streamChannels);
            Transform.append(stringBuffer, "streamSampleSize", this.streamSampleSize);
            Transform.append(stringBuffer, "streamSampleCount", this.streamSampleCount);
            Transform.append(stringBuffer, "latency", this.latency);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 4;
        if (this.format == 2 && this.latency > 0) {
            this.length += 2;
        }
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeBits(0, 4);
        switch (this.playbackRate) {
            case 5512: {
                fSCoder.writeBits(0, 2);
                break;
            }
            case 11025: {
                fSCoder.writeBits(1, 2);
                break;
            }
            case 22050: {
                fSCoder.writeBits(2, 2);
                break;
            }
            case 44100: {
                fSCoder.writeBits(3, 2);
            }
        }
        fSCoder.writeBits(this.playbackSampleSize - 1, 1);
        fSCoder.writeBits(this.playbackChannels - 1, 1);
        fSCoder.writeBits(this.format, 4);
        switch (this.streamRate) {
            case 5512: {
                fSCoder.writeBits(0, 2);
                break;
            }
            case 11025: {
                fSCoder.writeBits(1, 2);
                break;
            }
            case 22050: {
                fSCoder.writeBits(2, 2);
                break;
            }
            case 44100: {
                fSCoder.writeBits(3, 2);
            }
        }
        fSCoder.writeBits(this.streamSampleSize - 1, 1);
        fSCoder.writeBits(this.streamChannels - 1, 1);
        fSCoder.writeWord(this.streamSampleCount, 2);
        if (this.format == 2 && this.latency > 0) {
            fSCoder.writeWord(this.latency, 2);
        }
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        fSCoder.readBits(4, false);
        switch (fSCoder.readBits(2, false)) {
            case 0: {
                this.playbackRate = 5512;
                break;
            }
            case 1: {
                this.playbackRate = 11025;
                break;
            }
            case 2: {
                this.playbackRate = 22050;
                break;
            }
            case 3: {
                this.playbackRate = 44100;
            }
        }
        this.playbackSampleSize = fSCoder.readBits(1, false) + 1;
        this.playbackChannels = fSCoder.readBits(1, false) + 1;
        this.format = fSCoder.readBits(4, false);
        switch (fSCoder.readBits(2, false)) {
            case 0: {
                this.streamRate = 5512;
                break;
            }
            case 1: {
                this.streamRate = 11025;
                break;
            }
            case 2: {
                this.streamRate = 22050;
                break;
            }
            case 3: {
                this.streamRate = 44100;
            }
        }
        this.streamSampleSize = fSCoder.readBits(1, false) + 1;
        this.streamChannels = fSCoder.readBits(1, false) + 1;
        this.streamSampleCount = fSCoder.readWord(2, false);
        if (this.length == 6 && this.format == 2) {
            this.latency = fSCoder.readWord(2, true);
        }
        fSCoder.endObject(this.name());
    }
}

