/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCharacter;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSColor;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSText
extends FSTransformObject {
    public static final int Unicode = 0;
    public static final int SJIS = 2;
    public static final int ANSI = 1;
    public static final int Latin = 1;
    public static final int Japanese = 2;
    public static final int Korean = 3;
    public static final int SimplifiedChinese = 4;
    public static final int TraditionalChinese = 5;
    private int identifier = 0;
    private FSColor color = null;
    private int offsetX = Integer.MIN_VALUE;
    private int offsetY = Integer.MIN_VALUE;
    private int height = 0;
    private ArrayList characters = new ArrayList();

    public FSText(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSText(int n, int n2, ArrayList arrayList) {
        this.setOffsetX(n);
        this.setOffsetY(n2);
        this.setCharacters(arrayList);
    }

    public FSText(int n, FSColor fSColor, int n2, int n3, int n4, ArrayList arrayList) {
        this.setIdentifier(n);
        this.setColor(fSColor);
        this.setOffsetX(n2);
        this.setOffsetY(n3);
        this.setHeight(n4);
        this.setCharacters(arrayList);
    }

    public FSText(FSText fSText) {
        this.identifier = fSText.identifier;
        this.color = new FSColor(fSText.color);
        this.offsetX = fSText.offsetX;
        this.offsetY = fSText.offsetY;
        this.height = fSText.height;
        this.characters = new ArrayList(fSText.characters.size());
        Iterator iterator = fSText.characters.iterator();
        while (iterator.hasNext()) {
            this.characters.add(((FSCharacter)iterator.next()).clone());
        }
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public FSColor getColor() {
        return this.color;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getHeight() {
        return this.height;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }

    public void setColor(FSColor fSColor) {
        this.color = fSColor;
    }

    public void setOffsetX(int n) {
        this.offsetX = n;
    }

    public void setOffsetY(int n) {
        this.offsetY = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void add(FSCharacter fSCharacter) {
        this.characters.add(fSCharacter);
    }

    public ArrayList getCharacters() {
        return this.characters;
    }

    public void setCharacters(ArrayList arrayList) {
        this.characters = arrayList;
    }

    int glyphBits() {
        int n = 0;
        Iterator iterator = this.characters.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, FSCoder.size(((FSCharacter)iterator.next()).getGlyphIndex(), false));
        }
        return n;
    }

    int advanceBits() {
        int n = 0;
        Iterator iterator = this.characters.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, FSCoder.size(((FSCharacter)iterator.next()).getAdvance(), true));
        }
        return n;
    }

    public Object clone() {
        FSText fSText = (FSText)super.clone();
        fSText.color = this.color != null ? (FSColor)this.color.clone() : null;
        fSText.characters = new ArrayList();
        Iterator iterator = this.characters.iterator();
        while (iterator.hasNext()) {
            fSText.characters.add(((FSCharacter)iterator.next()).clone());
        }
        return fSText;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSText fSText = (FSText)object;
            boolean bl2 = bl = this.identifier == fSText.identifier;
            bl = this.color != null ? bl && this.color.equals(fSText.color) : bl && this.color == fSText.color;
            bl = bl && this.offsetX == fSText.offsetX;
            bl = bl && this.offsetY == fSText.offsetY;
            boolean bl3 = bl = bl && this.height == fSText.height;
            bl = this.characters != null ? this.characters.equals(fSText.characters) : this.characters == fSText.characters;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "identifier", this.identifier);
            Transform.append(stringBuffer, "color", this.color, n);
            Transform.append(stringBuffer, "offsetX", this.offsetX);
            Transform.append(stringBuffer, "offsetY", this.offsetY);
            Transform.append(stringBuffer, "height", this.height);
            Transform.append(stringBuffer, "characters", this.characters, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        boolean bl = this.containsFont();
        boolean bl2 = this.containsColor();
        boolean bl3 = this.containsOffsetX();
        boolean bl4 = this.containsOffsetY();
        int n = 1;
        if (this.containsStyle()) {
            n += bl ? 2 : 0;
            n += bl2 ? this.color.length(fSCoder) : 0;
            n += bl4 ? 2 : 0;
            n += bl3 ? 2 : 0;
            n += bl ? 2 : 0;
        }
        ++n;
        if (this.characters.size() > 0) {
            int n2 = 0;
            int n3 = fSCoder.context[9];
            int n4 = fSCoder.context[8];
            n += (n2 += (n2 = (n3 + n4) * this.characters.size()) % 8 > 0 ? 8 - n2 % 8 : 0) >> 3;
        }
        return n;
    }

    public void encode(FSCoder fSCoder) {
        boolean bl = this.containsFont();
        boolean bl2 = this.containsColor();
        boolean bl3 = this.containsOffsetY();
        boolean bl4 = this.containsOffsetX();
        fSCoder.writeBits(1, 1);
        fSCoder.writeBits(0, 3);
        fSCoder.writeBits(bl ? 1 : 0, 1);
        fSCoder.writeBits(bl2 ? 1 : 0, 1);
        fSCoder.writeBits(bl3 ? 1 : 0, 1);
        fSCoder.writeBits(bl4 ? 1 : 0, 1);
        if (bl) {
            fSCoder.writeWord(this.identifier, 2);
        }
        if (bl2) {
            this.color.encode(fSCoder);
        }
        if (bl4) {
            fSCoder.writeWord(this.offsetX, 2);
        }
        if (bl3) {
            fSCoder.writeWord(this.offsetY, 2);
        }
        if (bl) {
            fSCoder.writeWord(this.height, 2);
        }
        fSCoder.writeWord(this.characters.size(), 1);
        Iterator iterator = this.characters.iterator();
        while (iterator.hasNext()) {
            ((FSTransformObject)iterator.next()).encode(fSCoder);
        }
        fSCoder.alignToByte();
    }

    public void decode(FSCoder fSCoder) {
        boolean bl;
        fSCoder.readBits(1, false);
        fSCoder.readBits(3, false);
        boolean bl2 = fSCoder.readBits(1, false) != 0;
        boolean bl3 = fSCoder.readBits(1, false) != 0;
        boolean bl4 = fSCoder.readBits(1, false) != 0;
        boolean bl5 = bl = fSCoder.readBits(1, false) != 0;
        if (bl2) {
            this.identifier = fSCoder.readWord(2, false);
        }
        if (bl3) {
            this.color = new FSColor(fSCoder);
        }
        if (bl) {
            this.offsetX = fSCoder.readWord(2, true);
        }
        if (bl4) {
            this.offsetY = fSCoder.readWord(2, true);
        }
        if (bl2) {
            this.height = fSCoder.readWord(2, false);
        }
        int n = fSCoder.readWord(1, false);
        this.characters = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.characters.add(new FSCharacter(fSCoder));
        }
        fSCoder.alignToByte();
    }

    private boolean containsFont() {
        return this.identifier != 0 && this.height != 0;
    }

    private boolean containsColor() {
        return this.color != null;
    }

    private boolean containsOffsetX() {
        return this.offsetX != Integer.MIN_VALUE;
    }

    private boolean containsOffsetY() {
        return this.offsetY != Integer.MIN_VALUE;
    }

    boolean containsStyle() {
        return this.containsFont() || this.containsColor() || this.containsOffsetX() || this.containsOffsetY();
    }
}

