/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSAudioData;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSVideoData;
import com.flagstone.transform.FSVideoMetaData;
import com.flagstone.transform.FSVideoObject;
import com.flagstone.transform.Transform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.DataFormatException;

public final class FSVideo
implements Cloneable {
    public static final int H263 = 2;
    public static final int ScreenVideo = 3;
    public static final int KeyFrame = 1;
    public static final int Frame = 2;
    public static final int Optional = 3;
    static final int Action = 0;
    static final int Version = 1;
    static final int Type = 2;
    static final int Delta = 3;
    static final int Identifier = 4;
    static final int Codec = 5;
    private String signature = "FLV";
    private int version = 1;
    private ArrayList objects = new ArrayList();

    static FSVideoObject decodeObject(FSCoder fSCoder) {
        int n;
        FSVideoObject fSVideoObject = null;
        int n2 = fSCoder.getPointer();
        int n3 = fSCoder.readWord(1, false);
        int n4 = fSCoder.readWord(3, false) & 0xFFFFFF;
        int n5 = n2 + (11 + n4 << 3);
        fSCoder.setPointer(n2);
        switch (n3) {
            case 8: {
                fSVideoObject = new FSAudioData(fSCoder);
                break;
            }
            case 9: {
                fSVideoObject = new FSVideoData(fSCoder);
                break;
            }
            case 18: {
                fSVideoObject = new FSVideoMetaData(fSCoder);
                break;
            }
        }
        fSCoder.context[3] = n = n5 - fSCoder.getPointer();
        fSCoder.setPointer(n5);
        return fSVideoObject;
    }

    public FSVideo() {
    }

    public FSVideo(String string) throws FileNotFoundException, IOException, DataFormatException {
        this.decodeFromFile(string);
    }

    public FSVideo(byte[] byArray) throws IOException, DataFormatException {
        this.decodeFromData(byArray);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public ArrayList getObjects() {
        return this.objects;
    }

    public void setObjects(ArrayList arrayList) {
        this.objects = arrayList;
    }

    public void add(FSVideoObject fSVideoObject) {
        this.objects.add(fSVideoObject);
    }

    public void add(ArrayList arrayList) {
        this.objects.addAll(arrayList);
    }

    public void decodeFromFile(String string) throws FileNotFoundException, DataFormatException, IOException {
        FileInputStream fileInputStream = null;
        File file = new File(string);
        fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.decodeFromData(byArray);
    }

    public void decodeFromData(byte[] byArray) throws DataFormatException, IOException {
        FSCoder fSCoder = new FSCoder(1, byArray);
        Object var3_3 = null;
        boolean bl = false;
        boolean bl2 = false;
        this.isFlashVideo(byArray);
        this.signature = fSCoder.readString(3, "UTF8");
        this.version = fSCoder.readWord(1, false);
        fSCoder.readBits(5, false);
        bl = fSCoder.readBits(1, false) != 0;
        fSCoder.readBits(1, false);
        bl2 = fSCoder.readBits(1, false) != 0;
        int n = fSCoder.readWord(4, false);
        n = fSCoder.readWord(4, false);
        do {
            this.objects.add(FSVideo.decodeObject(fSCoder));
            if (fSCoder.context[3] != 0) {
                throw new IOException();
            }
            n = fSCoder.readWord(4, false);
        } while (!fSCoder.eof());
    }

    public void encodeToFile(String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byte[] byArray = this.encode();
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public byte[] encode() throws IOException {
        FSCoder fSCoder = new FSCoder(1, 0);
        fSCoder.context[1] = this.version;
        int n = this.length(fSCoder);
        fSCoder.setData(1, new byte[n]);
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            int n2 = ((FSVideoObject)iterator.next()).getType();
            if (n2 == 8) {
                bl = true;
                continue;
            }
            if (n2 != 9) continue;
            bl2 = true;
        }
        fSCoder.writeString(this.signature, "UTF8");
        fSCoder.writeWord(this.version, 1);
        fSCoder.writeBits(0, 5);
        fSCoder.writeBits(bl ? 1 : 0, 1);
        fSCoder.writeBits(0, 1);
        fSCoder.writeBits(bl2 ? 1 : 0, 1);
        fSCoder.writeWord(9, 4);
        fSCoder.writeWord(0, 4);
        iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            FSVideoObject fSVideoObject = (FSVideoObject)iterator.next();
            int n3 = fSVideoObject.getLength();
            int n4 = fSCoder.getPointer();
            int n5 = n4 + (n3 << 3);
            fSVideoObject.encode(fSCoder);
            fSCoder.setPointer(n5);
            if (n5 - fSCoder.getPointer() >> 3 != 0) {
                throw new IOException();
            }
            fSCoder.writeWord(n3 + 11, 4);
        }
        return fSCoder.getData();
    }

    public Object clone() {
        FSVideo fSVideo = null;
        try {
            fSVideo = (FSVideo)super.clone();
            fSVideo.objects = new ArrayList();
            Iterator iterator = this.objects.iterator();
            while (iterator.hasNext()) {
                fSVideo.objects.add(((FSVideoObject)iterator.next()).clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return fSVideo;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSVideo fSVideo = (FSVideo)object;
            bl = this.version == fSVideo.version;
            bl = bl && this.objects.equals(((FSVideo)object).getObjects());
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append("FSVideo");
        stringBuffer.append(" : { ");
        Transform.append(stringBuffer, "signature", this.signature);
        Transform.append(stringBuffer, "version", this.version);
        Transform.append(stringBuffer, "objects", this.objects, n);
        stringBuffer.append("}");
    }

    private int length(FSCoder fSCoder) {
        int n = 13;
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            n += 4 + ((FSVideoObject)iterator.next()).length(fSCoder);
        }
        return n;
    }

    private void isFlashVideo(byte[] byArray) throws DataFormatException {
        boolean bl;
        if (byArray == null || byArray.length < 8) {
            throw new DataFormatException();
        }
        boolean bl2 = bl = byArray[0] == 70 && byArray[1] == 76 && byArray[2] == 86;
        if (!bl) {
            throw new DataFormatException();
        }
    }
}

