/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSVideoObject;
import com.flagstone.transform.Transform;

public final class FSVideoData
extends FSVideoObject {
    private int codec = 0;
    private int frameType = 0;
    private byte[] data = null;

    FSVideoData(FSCoder fSCoder) {
        super(9, 0);
        this.decode(fSCoder);
    }

    public FSVideoData(int n, int n2, int n3, byte[] byArray) {
        super(9, n);
        this.setCodec(this.codec);
        this.setFrameType(this.frameType);
        this.setData(byArray);
    }

    public int getCodec() {
        return this.codec;
    }

    public void setCodec(int n) {
        this.codec = n;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public void setFrameType(int n) {
        this.frameType = n;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public Object clone() {
        FSVideoData fSVideoData = (FSVideoData)super.clone();
        fSVideoData.data = Transform.clone(this.data);
        return fSVideoData;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSVideoData fSVideoData = (FSVideoData)object;
            bl = this.codec == fSVideoData.codec;
            boolean bl2 = bl = bl && this.frameType == fSVideoData.frameType;
            bl = this.data != null ? bl && Transform.equals(this.data, fSVideoData.data) : bl && fSVideoData.data == null;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "codec", this.codec);
            Transform.append(stringBuffer, "frameType", this.frameType);
            Transform.append(stringBuffer, "data", "<data>");
            stringBuffer.append("}");
        }
    }

    int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 1 + this.data.length;
        return this.length;
    }

    void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeBits(this.codec, 4);
        fSCoder.writeBits(this.frameType, 4);
        fSCoder.writeBytes(this.data);
    }

    void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        this.data = new byte[this.length - 1];
        this.codec = fSCoder.readBits(4, false);
        this.frameType = fSCoder.readBits(4, false);
        fSCoder.readBytes(this.data);
    }
}

