/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.Transform;

public class FSVideoFrame
extends FSMovieObject {
    private int identifier = 0;
    private int frameNumber = 0;
    private byte[] data = null;

    public FSVideoFrame(FSCoder fSCoder) {
        super(61);
        this.decode(fSCoder);
    }

    public FSVideoFrame(int n, int n2, byte[] byArray) {
        super(61);
        this.setIdentifier(n);
        this.setFrameNumber(n2);
        this.setData(byArray);
    }

    public FSVideoFrame(FSVideoFrame fSVideoFrame) {
        super(fSVideoFrame);
        this.identifier = fSVideoFrame.identifier;
        this.frameNumber = fSVideoFrame.frameNumber;
        this.data = Transform.clone(fSVideoFrame.data);
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public void setFrameNumber(int n) {
        this.frameNumber = n;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public Object clone() {
        FSVideoFrame fSVideoFrame = (FSVideoFrame)super.clone();
        return fSVideoFrame;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSVideoFrame fSVideoFrame = (FSVideoFrame)object;
            bl = this.identifier == fSVideoFrame.identifier;
            boolean bl2 = bl = bl && this.frameNumber == fSVideoFrame.frameNumber;
            bl = this.data != null ? bl && Transform.equals(this.data, fSVideoFrame.data) : bl && fSVideoFrame.data == null;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "identifier", this.identifier);
            Transform.append(stringBuffer, "frameNumber", this.frameNumber);
            Transform.append(stringBuffer, "data", "<data>");
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 4 + this.data.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeWord(this.identifier, 2);
        fSCoder.writeWord(this.frameNumber, 2);
        fSCoder.writeBytes(this.data);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        this.data = new byte[this.length - 4];
        this.identifier = fSCoder.readWord(2, false);
        this.frameNumber = fSCoder.readWord(2, false);
        fSCoder.readBytes(this.data);
        fSCoder.endObject(this.name());
    }
}

