/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util;

public class FSCodec {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    private int byteOrder = 0;
    private byte[] data = null;
    private int ptr = 0;
    private int end = 0;

    public FSCodec(int order, byte[] bytes) {
        this.byteOrder = order;
        this.data = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.data, 0, bytes.length);
        this.end = this.data.length << 3;
    }

    public FSCodec(int order, int size) {
        this.byteOrder = order;
        this.data = new byte[size];
        this.end = this.data.length << 3;
    }

    public byte[] getData() {
        int length = this.ptr + 7 >> 3;
        byte[] bytes = new byte[length];
        System.arraycopy(this.data, 0, bytes, 0, length);
        return bytes;
    }

    public void setData(byte[] bytes) {
        this.data = bytes;
        this.ptr = 0;
        this.end = this.data.length << 3;
    }

    public void setData(int order, byte[] bytes) {
        this.byteOrder = order;
        this.data = bytes;
        this.ptr = 0;
        this.end = this.data.length << 3;
    }

    public int getPosition() {
        return this.ptr;
    }

    public void setPosition(int offset) {
        this.ptr = offset < 0 ? 0 : (offset > this.end ? this.end : offset);
    }

    public void alignToByte() {
        this.ptr = this.ptr + 7 & 0xFFFFFFF8;
    }

    public boolean eof() {
        return this.ptr >= this.end;
    }

    /*
     * Unable to fully structure code
     */
    public boolean findBits(int value, int numberOfBits, int step) {
        found = false;
        start = this.ptr;
        val = 0;
        if (numberOfBits >= 1 && numberOfBits <= 32) ** GOTO lbl12
        throw new IllegalArgumentException("Number of bits must be in the range 1..32.");
lbl-1000:
        // 1 sources

        {
            val = this.readBits(numberOfBits, false);
            this.ptr -= numberOfBits;
            if (val == value) {
                found = true;
                break;
            }
            this.ptr += step;
lbl12:
            // 2 sources

            ** while (this.ptr < this.end)
        }
lbl13:
        // 2 sources

        if (!found) {
            this.ptr = start;
        }
        return found;
    }

    public boolean findWord(int value, int numberOfBytes, int step) {
        boolean found = false;
        int start = this.ptr;
        int val = 0;
        if (numberOfBytes < 1 || numberOfBytes > 4) {
            throw new IllegalArgumentException("Number of bytes must be in the range 1..4.");
        }
        if ((this.ptr & 7) > 0) {
            this.ptr = this.ptr + 7 & 0xFFFFFFF8;
        }
        while (this.ptr < this.end) {
            val = this.readWord(numberOfBytes, false);
            this.ptr -= numberOfBytes * 8;
            if (val == value) {
                found = true;
                break;
            }
            this.ptr += step;
        }
        if (!found) {
            this.ptr = start;
        }
        return found;
    }

    public int readBits(int numberOfBits, boolean signed) {
        int value = 0;
        if (numberOfBits < 1 || numberOfBits > 32) {
            throw new IllegalArgumentException("Number of bits must be in the range 1..32.");
        }
        int index = this.ptr >> 3;
        int base = this.data.length - index > 4 ? 0 : (4 - (this.data.length - index)) * 8;
        int i = 32;
        while (i > base) {
            value |= (this.data[index] & 0xFF) << i - 8;
            i -= 8;
            ++index;
        }
        value <<= this.ptr % 8;
        value = signed ? (value >>= 32 - numberOfBits) : (value >>>= 32 - numberOfBits);
        this.ptr += numberOfBits;
        if (this.ptr > this.data.length << 3) {
            this.ptr = this.data.length << 3;
        }
        return value;
    }

    public void writeBits(int value, int numberOfBits) {
        if (this.ptr + numberOfBits + 24 > this.end) {
            int length = (numberOfBits > this.data.length ? numberOfBits : this.data.length) + this.data.length;
            byte[] bytes = new byte[length];
            System.arraycopy(this.data, 0, bytes, 0, this.data.length);
            this.data = bytes;
        }
        if (numberOfBits < 1 || numberOfBits > 32) {
            throw new IllegalArgumentException("Number of bits must be in the range 1..32.");
        }
        int index = this.ptr >> 3;
        value <<= 32 - numberOfBits;
        value >>>= this.ptr % 8;
        value |= this.data[index] << 24;
        int i = 24;
        while (i >= 0) {
            this.data[index] = (byte)(value >>> i);
            i -= 8;
            ++index;
        }
        this.ptr += numberOfBits;
        if (this.ptr > this.data.length << 3) {
            this.ptr = this.data.length << 3;
        }
    }

    public int readWord(int numberOfBytes, boolean signed) {
        int value = 0;
        if (numberOfBytes < 1 || numberOfBytes > 4) {
            throw new IllegalArgumentException("Number of bytes must be in the range 1..4.");
        }
        int index = this.ptr >> 3;
        if (index + numberOfBytes > this.data.length) {
            numberOfBytes = this.data.length - index;
        }
        int numberOfBits = numberOfBytes * 8;
        if (this.byteOrder == 0) {
            int i = 0;
            while (i < numberOfBits) {
                value += (this.data[index] & 0xFF) << i;
                i += 8;
                this.ptr += 8;
                ++index;
            }
        } else {
            int i = 0;
            while (i < numberOfBits) {
                value <<= 8;
                value += this.data[index] & 0xFF;
                i += 8;
                this.ptr += 8;
                ++index;
            }
        }
        if (signed) {
            value <<= 32 - numberOfBits;
            value >>= 32 - numberOfBits;
        }
        return value;
    }

    public void writeWord(int value, int numberOfBytes) {
        int index;
        if (numberOfBytes < 1 || numberOfBytes > 4) {
            throw new IllegalArgumentException("Number of bytes must be in the range 1..4.");
        }
        int numberOfBits = numberOfBytes * 8;
        if (this.ptr + numberOfBits > this.end) {
            int length = (numberOfBits > this.data.length ? numberOfBits : this.data.length) + this.data.length;
            byte[] bytes = new byte[length];
            System.arraycopy(this.data, 0, bytes, 0, this.data.length);
            this.data = bytes;
            this.end = this.data.length << 3;
        }
        if (this.byteOrder == 0) {
            index = this.ptr >>> 3;
            int i = 0;
            while (i < numberOfBits) {
                this.data[index] = (byte)value;
                i += 8;
                this.ptr += 8;
                value >>>= 8;
                ++index;
            }
        } else {
            index = this.ptr + numberOfBits - 8 >>> 3;
            int i = 0;
            while (i < numberOfBits) {
                this.data[index] = (byte)value;
                i += 8;
                this.ptr += 8;
                value >>>= 8;
                --index;
            }
        }
    }

    public int readBytes(byte[] bytes) {
        int bytesRead = 0;
        if (bytes == null || bytes.length == 0) {
            return bytesRead;
        }
        int index = this.ptr >>> 3;
        int numberOfBytes = bytes.length;
        if (index + numberOfBytes > this.data.length) {
            numberOfBytes = this.data.length - index;
        }
        int i = 0;
        while (i < numberOfBytes) {
            bytes[i] = this.data[index];
            ++i;
            this.ptr += 8;
            ++index;
            ++bytesRead;
        }
        return bytesRead;
    }

    public int writeBytes(byte[] bytes) {
        int bytesWritten = 0;
        if (this.ptr + (bytes.length << 3) > this.end) {
            int length = (bytes.length > this.data.length ? bytes.length : this.data.length) + this.data.length;
            byte[] buffer = new byte[length];
            System.arraycopy(this.data, 0, buffer, 0, this.data.length);
            this.data = bytes;
            this.end = this.data.length << 3;
        }
        if (bytes == null || bytes.length == 0) {
            return bytesWritten;
        }
        int index = this.ptr >>> 3;
        int numberOfBytes = bytes.length;
        int i = 0;
        while (i < numberOfBytes) {
            this.data[index] = bytes[i];
            ++i;
            this.ptr += 8;
            ++index;
            ++bytesWritten;
        }
        return bytesWritten;
    }

    byte[] getBuffer() {
        return this.data;
    }

    int getPointer() {
        return this.ptr;
    }

    void setPointer(int location) {
        if (location < 0) {
            location = 0;
        } else if (location > this.end) {
            location = this.end;
        }
        this.ptr = location;
    }

    void adjustPointer(int offset) {
        this.ptr += offset;
        if (this.ptr < 0) {
            this.ptr = 0;
        } else if (this.ptr >= this.end) {
            this.ptr = this.end;
        }
    }

    int readBits(int numberOfBits) {
        int value = 0;
        if (numberOfBits == 0) {
            return value;
        }
        int index = this.ptr >> 3;
        int base = this.data.length - index > 4 ? 0 : (4 - (this.data.length - index)) * 8;
        int i = 32;
        while (i > base) {
            value |= (this.data[index] & 0xFF) << i - 8;
            i -= 8;
            ++index;
        }
        value <<= this.ptr % 8;
        value >>>= 32 - numberOfBits;
        this.ptr += numberOfBits;
        if (this.ptr > this.data.length << 3) {
            this.ptr = this.data.length << 3;
        }
        return value;
    }

    int readByte() {
        int value = this.data[this.ptr >> 3] & 0xFF;
        this.ptr += 8;
        return value;
    }

    int readShort(boolean signed) {
        int value = 0;
        int index = this.ptr >> 3;
        if (this.byteOrder == 0) {
            value = this.data[index++] & 0xFF;
            value += (this.data[index] & 0xFF) << 8;
        } else {
            value = (this.data[index++] & 0xFF) << 8;
            value += this.data[index] & 0xFF;
        }
        if (signed) {
            value <<= 16;
            value >>= 16;
        }
        this.ptr += 16;
        return value;
    }

    int readInt() {
        int value = 0;
        int index = this.ptr >> 3;
        if (this.byteOrder == 0) {
            value = this.data[index++] & 0xFF;
            value += (this.data[index++] & 0xFF) << 8;
            value += (this.data[index++] & 0xFF) << 16;
            value += (this.data[index] & 0xFF) << 24;
        } else {
            value = (this.data[index++] & 0xFF) << 24;
            value += (this.data[index++] & 0xFF) << 16;
            value += (this.data[index++] & 0xFF) << 8;
            value += this.data[index] & 0xFF;
        }
        this.ptr += 32;
        return value;
    }

    float readFixedBits(int numberOfBits, int fractionSize) {
        float value = 0.0f;
        float divisor = 1 << fractionSize;
        value = (float)this.readBits(numberOfBits, true) / divisor;
        return value;
    }
}

