/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util;

import com.flagstone.transform.FSBitmapFill;
import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSDefineImage;
import com.flagstone.transform.FSDefineImage2;
import com.flagstone.transform.FSDefineJPEGImage2;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSDefineShape3;
import com.flagstone.transform.FSImageBlock;
import com.flagstone.transform.FSLine;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSShapeStyle;
import com.flagstone.transform.FSSolidLine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class FSImageConstructor {
    public static final int JPEG = 0;
    public static final int IDX8 = 1;
    public static final int IDXA = 2;
    public static final int RGB5 = 3;
    public static final int RGB8 = 4;
    public static final int RGBA = 5;
    private static final int[] monochrome;
    private static final int[] greyscale2;
    private static final int[] greyscale4;
    private static final int[] bmpSignature;
    private final int BI_RGB = 0;
    private final int BI_RLE8 = 1;
    private final int BI_RLE4 = 2;
    private final int BI_BITFIELDS = 3;
    private static final int[] pngSignature;
    private static final int IHDR = 1229472850;
    private static final int PLTE = 1347179589;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private static final int tRNS = 1951551059;
    private static final int GREYSCALE = 0;
    private static final int TRUE_COLOUR = 2;
    private static final int INDEXED_COLOUR = 3;
    private static final int ALPHA_GREYSCALE = 4;
    private static final int ALPHA_TRUECOLOUR = 6;
    private static final int NO_FILTER = 0;
    private static final int SUB_FILTER = 1;
    private static final int UP_FILTER = 2;
    private static final int AVG_FILTER = 3;
    private static final int PAETH_FILTER = 4;
    private static final int[] startRow;
    private static final int[] startColumn;
    private static final int[] rowIncrement;
    private static final int[] columnIncrement;
    private static final int BIT_DEPTH = 0;
    private static final int COLOUR_COMPONENTS = 1;
    private static final int COMPRESSION_METHOD = 2;
    private static final int RED_MASK = 4;
    private static final int GREEN_MASK = 5;
    private static final int BLUE_MASK = 6;
    private static final int COLOUR_TYPE = 4;
    private static final int FILTER_METHOD = 5;
    private static final int INTERLACE_METHOD = 6;
    private static final int TRANSPARENT_GREY = 7;
    private static final int TRANSPARENT_RED = 8;
    private static final int TRANSPARENT_GREEN = 9;
    private static final int TRANSPARENT_BLUE = 10;
    private int format = 0;
    private int width = 0;
    private int height = 0;
    private byte[][] colourTable = null;
    private byte[][] indexedImage = null;
    private byte[][][] colorImage = null;
    private byte[] jpegImage = null;
    private int[] attributes = new int[16];
    private byte[] chunkData = new byte[0];

    static {
        int[] nArray = new int[2];
        nArray[1] = 255;
        monochrome = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 85;
        nArray2[2] = 170;
        nArray2[3] = 255;
        greyscale2 = nArray2;
        int[] nArray3 = new int[16];
        nArray3[1] = 17;
        nArray3[2] = 34;
        nArray3[3] = 51;
        nArray3[4] = 68;
        nArray3[5] = 85;
        nArray3[6] = 102;
        nArray3[7] = 119;
        nArray3[8] = 136;
        nArray3[9] = 153;
        nArray3[10] = 170;
        nArray3[11] = 187;
        nArray3[12] = 204;
        nArray3[13] = 221;
        nArray3[14] = 238;
        nArray3[15] = 255;
        greyscale4 = nArray3;
        bmpSignature = new int[]{66, 77};
        pngSignature = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
        int[] nArray4 = new int[7];
        nArray4[2] = 4;
        nArray4[4] = 2;
        nArray4[6] = 1;
        startRow = nArray4;
        int[] nArray5 = new int[7];
        nArray5[1] = 4;
        nArray5[3] = 2;
        nArray5[5] = 1;
        startColumn = nArray5;
        rowIncrement = new int[]{8, 8, 8, 4, 4, 2, 2};
        columnIncrement = new int[]{8, 8, 4, 4, 2, 2, 1};
    }

    public FSImageConstructor() {
    }

    public FSImageConstructor(String filename) throws IOException, DataFormatException {
        this.setImage(this.dataFromFile(filename));
    }

    public FSImageConstructor(byte[] bytes) throws DataFormatException {
        this.setImage(bytes);
    }

    public void setImageFromFile(String filename) throws IOException, DataFormatException {
        this.setImage(this.dataFromFile(filename));
    }

    public void setImage(byte[] bytes) throws DataFormatException {
        int signature = (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
        this.format = 0;
        this.width = 0;
        this.height = 0;
        this.attributes[0] = 0;
        this.attributes[1] = 0;
        this.attributes[4] = 0;
        this.attributes[2] = 0;
        this.attributes[5] = 0;
        this.attributes[6] = 0;
        this.chunkData = new byte[0];
        this.attributes[7] = -1;
        this.attributes[8] = -1;
        this.attributes[9] = -1;
        this.attributes[10] = -1;
        this.attributes[4] = 0;
        this.attributes[5] = 0;
        this.attributes[6] = 0;
        this.colourTable = null;
        this.indexedImage = null;
        this.colorImage = null;
        this.jpegImage = null;
        switch (signature) {
            case 65496: {
                this.decodeJPEG(bytes);
                break;
            }
            case 16973: {
                this.decodeBMP(bytes);
                break;
            }
            case 35152: {
                this.decodePNG(bytes);
                break;
            }
            default: {
                throw new DataFormatException("Unsupported image format");
            }
        }
    }

    public int getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[][] getColorTable() {
        byte[][] table = null;
        if (this.colourTable != null) {
            table = new byte[this.colourTable.length][4];
            int i = 0;
            while (i < this.colourTable.length) {
                int j = 0;
                while (j < 4) {
                    table[i][j] = this.colourTable[i][j];
                    ++j;
                }
                ++i;
            }
        }
        return table;
    }

    public byte[][] getIndexedImage() {
        byte[][] image = null;
        if (this.indexedImage != null) {
            image = new byte[this.height][this.width];
            int i = 0;
            while (i < this.height) {
                int j = 0;
                while (j < this.width) {
                    image[i][j] = this.indexedImage[i][j];
                    ++j;
                }
                ++i;
            }
        }
        return image;
    }

    public byte[][][] getColorImage() {
        byte[][][] image = null;
        if (this.colorImage != null) {
            image = new byte[this.height][this.width][4];
            int h = 0;
            while (h < this.height) {
                int w = 0;
                while (w < this.width) {
                    image[h][w][0] = this.colorImage[h][w][0];
                    image[h][w][1] = this.colorImage[h][w][1];
                    image[h][w][2] = this.colorImage[h][w][2];
                    image[h][w][3] = this.colorImage[h][w][3];
                    ++w;
                }
                ++h;
            }
        }
        return image;
    }

    public byte[] getJPEGImage() {
        byte[] image = null;
        if (this.jpegImage != null) {
            image = new byte[this.jpegImage.length];
            System.arraycopy(this.jpegImage, 0, image, 0, this.jpegImage.length);
        }
        return image;
    }

    public ArrayList getImageAsBlocks(int blockWidth, int blockHeight) {
        int row = 0;
        int col = 0;
        int index = 0;
        byte[] formattedImage = new byte[this.width * this.height * 3];
        switch (this.format) {
            case 1: 
            case 2: {
                row = this.height - 1;
                while (row >= 0) {
                    col = 0;
                    while (col < this.width) {
                        formattedImage[index++] = this.colourTable[this.indexedImage[row][col]][2];
                        formattedImage[index++] = this.colourTable[this.indexedImage[row][col]][1];
                        formattedImage[index++] = this.colourTable[this.indexedImage[row][col]][0];
                        ++col;
                    }
                    --row;
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                row = this.height - 1;
                while (row >= 0) {
                    col = 0;
                    while (col < this.width) {
                        formattedImage[index++] = this.colorImage[row][col][2];
                        formattedImage[index++] = this.colorImage[row][col][1];
                        formattedImage[index++] = this.colorImage[row][col][0];
                        ++col;
                    }
                    --row;
                }
                break;
            }
        }
        int columns = (this.width + blockWidth - 1) / blockWidth;
        int rows = (this.height + blockHeight - 1) / blockHeight;
        ArrayList<FSImageBlock> blocks = new ArrayList<FSImageBlock>(rows * columns);
        byte[] blockData = new byte[blockHeight * blockWidth * 3];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                int xOffset = j * blockWidth;
                int yOffset = i * blockHeight;
                int xSpan = this.width - xOffset > blockWidth ? blockWidth : this.width - xOffset;
                int ySpan = this.height - yOffset > blockHeight ? blockHeight : this.height - yOffset;
                int offset = 0;
                int k = 0;
                while (k < ySpan) {
                    int l = 0;
                    while (l < xSpan) {
                        int idx = (yOffset + k) * (this.width * 3) + (xOffset + l) * 3;
                        blockData[offset] = formattedImage[idx];
                        blockData[offset + 1] = formattedImage[idx + 1];
                        blockData[offset + 2] = formattedImage[idx + 2];
                        ++l;
                        offset += 3;
                    }
                    ++k;
                }
                blocks.add(new FSImageBlock(xSpan, ySpan, FSImageConstructor.zip(blockData, offset)));
                ++j;
            }
            ++i;
        }
        return blocks;
    }

    private static byte[] zip(byte[] image, int length) {
        Deflater deflater = new Deflater();
        deflater.setInput(image, 0, length);
        deflater.finish();
        byte[] compressedData = new byte[image.length];
        int bytesCompressed = deflater.deflate(compressedData);
        byte[] newData = new byte[bytesCompressed];
        int i = 0;
        while (i < bytesCompressed) {
            newData[i] = compressedData[i];
            ++i;
        }
        return newData;
    }

    public void setIndexedImage(int encoding, int imageWidth, int imageHeight, byte[][] table, byte[][] image) {
        if (encoding != 1 && encoding != 2) {
            throw new IllegalArgumentException("Indexed images must have a format of IDX8 or IDXA");
        }
        this.format = encoding;
        this.width = imageWidth;
        this.height = imageHeight;
        this.colourTable = new byte[table.length][4];
        int i = 0;
        while (i < table.length) {
            int j = 0;
            while (j < 4) {
                this.colourTable[i][j] = table[i][j];
                ++j;
            }
            ++i;
        }
        this.indexedImage = new byte[this.height][this.width];
        int h = 0;
        while (h < this.height) {
            int w = 0;
            while (w < this.width) {
                this.indexedImage[h][w] = image[h][w];
                ++w;
            }
            ++h;
        }
    }

    public void setColorImage(int encoding, int imageWidth, int imageHeight, byte[][][] image) {
        if (encoding != 3 && encoding != 4 && encoding != 5) {
            throw new IllegalArgumentException("True colour images must has a format of RGB5, RGB8 or RGBA");
        }
        this.format = encoding;
        this.width = imageWidth;
        this.height = imageHeight;
        this.colorImage = new byte[this.height][this.width][4];
        int h = 0;
        while (h < this.height) {
            int w = 0;
            while (w < this.width) {
                this.colorImage[h][w][0] = image[h][w][0];
                this.colorImage[h][w][1] = image[h][w][1];
                this.colorImage[h][w][2] = image[h][w][2];
                this.colorImage[h][w][3] = image[h][w][3];
                ++w;
            }
            ++h;
        }
    }

    public void setJPEGImage(int imageWidth, int imageHeight, byte[] image) {
        this.format = 0;
        this.width = imageWidth;
        this.height = imageHeight;
        this.jpegImage = new byte[image.length];
        System.arraycopy(image, 0, this.jpegImage, 0, image.length);
    }

    public FSDefineObject defineImage(int identifier) {
        FSDefineObject object = null;
        switch (this.format) {
            case 0: {
                object = new FSDefineJPEGImage2(identifier, this.jpegImage);
                break;
            }
            case 1: {
                object = new FSDefineImage(identifier, this.width, this.height, this.colourTable.length, this.zip(this.getImage(), this.colourTable, false));
                break;
            }
            case 2: {
                object = new FSDefineImage2(identifier, this.width, this.height, this.colourTable.length, this.zip(this.getImage(), this.colourTable, true));
                break;
            }
            case 3: {
                object = new FSDefineImage(identifier, this.width, this.height, this.zip(this.getImage()), 16);
                break;
            }
            case 4: {
                object = new FSDefineImage(identifier, this.width, this.height, this.zip(this.getImage()), 24);
                break;
            }
            case 5: {
                object = new FSDefineImage2(identifier, this.width, this.height, this.zip(this.getImage()));
            }
        }
        return object;
    }

    private byte[] getImage() {
        int row = 0;
        int col = 0;
        int index = 0;
        int scanLength = 0;
        byte[] formattedImage = null;
        switch (this.format) {
            case 1: 
            case 2: {
                scanLength = this.width + 3 & 0xFFFFFFFC;
                formattedImage = new byte[scanLength * this.height];
                row = 0;
                while (row < this.height) {
                    col = 0;
                    while (col < this.width) {
                        formattedImage[index++] = this.indexedImage[row][col];
                        ++col;
                    }
                    while (col < scanLength) {
                        formattedImage[index++] = 0;
                        ++col;
                    }
                    ++row;
                }
                break;
            }
            case 3: {
                scanLength = this.width + (this.width & 1);
                formattedImage = new byte[scanLength * this.height * 2];
                row = 0;
                while (row < this.height) {
                    col = 0;
                    while (col < this.width) {
                        int red = (this.colorImage[row][col][0] & 0xF8) << 7;
                        int green = (this.colorImage[row][col][1] & 0xF8) << 2;
                        int blue = (this.colorImage[row][col][2] & 0xF8) >> 3;
                        int colour = (red | green | blue) & Short.MAX_VALUE;
                        formattedImage[index++] = (byte)(colour >> 8);
                        formattedImage[index++] = (byte)colour;
                        ++col;
                    }
                    while (col < scanLength) {
                        formattedImage[index++] = 0;
                        formattedImage[index++] = 0;
                        ++col;
                    }
                    ++row;
                }
                break;
            }
            case 4: {
                formattedImage = new byte[this.width * this.height * 4];
                row = 0;
                while (row < this.height) {
                    col = 0;
                    while (col < this.width) {
                        formattedImage[index++] = -1;
                        formattedImage[index++] = this.colorImage[row][col][0];
                        formattedImage[index++] = this.colorImage[row][col][1];
                        formattedImage[index++] = this.colorImage[row][col][2];
                        ++col;
                    }
                    ++row;
                }
                break;
            }
            case 5: {
                formattedImage = new byte[this.width * this.height * 4];
                row = 0;
                while (row < this.height) {
                    col = 0;
                    while (col < this.width) {
                        int alpha = this.colorImage[row][col][3] & 0xFF;
                        int red = (this.colorImage[row][col][0] & 0xFF) * alpha / 255;
                        int green = (this.colorImage[row][col][1] & 0xFF) * alpha / 255;
                        int blue = (this.colorImage[row][col][2] & 0xFF) * alpha / 255;
                        formattedImage[index++] = (byte)alpha;
                        formattedImage[index++] = (byte)red;
                        formattedImage[index++] = (byte)green;
                        formattedImage[index++] = (byte)blue;
                        ++col;
                    }
                    ++row;
                }
                break;
            }
        }
        return formattedImage;
    }

    public FSDefineShape3 defineEnclosingShape(int shapeIdentifier, int imageIdentifier, int xOrigin, int yOrigin, FSSolidLine borderStyle) {
        int lineWidth = 0;
        if (borderStyle != null) {
            lineWidth = borderStyle.getWidth() / 2;
        }
        FSBounds bounds = new FSBounds(-xOrigin * 20 - lineWidth, -yOrigin * 20 - lineWidth, (this.width - xOrigin) * 20 + lineWidth, (this.height - yOrigin) * 20 + lineWidth);
        FSShape shape = new FSShape();
        shape.add(new FSShapeStyle(borderStyle != null ? 1 : 0, 1, 0, -xOrigin * 20, -yOrigin * 20));
        shape.add(new FSLine(this.width * 20, 0));
        shape.add(new FSLine(0, this.height * 20));
        shape.add(new FSLine(-this.width * 20, 0));
        shape.add(new FSLine(0, -this.height * 20));
        FSDefineShape3 definition = new FSDefineShape3(shapeIdentifier, bounds, new ArrayList(), new ArrayList(), shape);
        FSCoordTransform transform = new FSCoordTransform(-xOrigin * 20, -yOrigin * 20, 20.0, 20.0);
        if (borderStyle != null) {
            definition.add(borderStyle);
        }
        definition.add(new FSBitmapFill(65, imageIdentifier, transform));
        return definition;
    }

    private boolean jpegInfo() {
        FSCoder coder = new FSCoder(1, this.jpegImage);
        if (coder.readWord(2, false) != 65496) {
            return false;
        }
        while (true) {
            int marker = coder.readWord(2, false);
            int size = coder.readWord(2, false);
            if ((marker & 0xFF00) != 65280) {
                return false;
            }
            if (marker >= 65472 && marker <= 65487 && marker != 65476 && marker != 65480) {
                coder.readWord(1, false);
                this.height = coder.readWord(2, false);
                this.width = coder.readWord(2, false);
                return true;
            }
            coder.adjustPointer(size - 2 << 3);
        }
    }

    private void decodeJPEG(byte[] bytes) throws DataFormatException {
        this.format = 0;
        this.jpegImage = bytes;
        if (!this.jpegInfo()) {
            throw new DataFormatException();
        }
    }

    private void decodeBMP(byte[] bytes) throws DataFormatException {
        FSCoder coder = new FSCoder(0, bytes);
        int i = 0;
        while (i < 2) {
            if (coder.readWord(1, false) != bmpSignature[i]) {
                throw new DataFormatException("Not a valid BMP file");
            }
            ++i;
        }
        coder.readWord(4, false);
        coder.readWord(4, false);
        int offset = coder.readWord(4, false);
        int headerSize = coder.readWord(4, false);
        int bitsPerPixel = 0;
        int coloursUsed = 0;
        switch (headerSize) {
            case 12: {
                this.width = coder.readWord(2, false);
                this.height = coder.readWord(2, false);
                coder.readWord(2, false);
                bitsPerPixel = coder.readWord(2, false);
                break;
            }
            case 40: {
                this.width = coder.readWord(4, false);
                this.height = coder.readWord(4, false);
                coder.readWord(2, false);
                bitsPerPixel = coder.readWord(2, false);
                this.attributes[2] = coder.readWord(4, false);
                coder.readWord(4, false);
                coder.readWord(4, false);
                coder.readWord(4, false);
                coloursUsed = coder.readWord(4, false);
                coder.readWord(4, false);
                break;
            }
        }
        if (this.attributes[2] == 3) {
            this.attributes[4] = coder.readWord(4, false);
            this.attributes[5] = coder.readWord(4, false);
            this.attributes[6] = coder.readWord(4, false);
        }
        switch (bitsPerPixel) {
            case 1: {
                this.format = 1;
                this.attributes[0] = 1;
                this.attributes[1] = 1;
                break;
            }
            case 2: {
                this.format = 1;
                this.attributes[0] = 2;
                this.attributes[1] = 1;
                break;
            }
            case 4: {
                this.format = 1;
                this.attributes[0] = 4;
                this.attributes[1] = 1;
                break;
            }
            case 8: {
                this.format = 1;
                this.attributes[0] = 8;
                this.attributes[1] = 1;
                break;
            }
            case 16: {
                this.format = 3;
                this.attributes[0] = 5;
                this.attributes[1] = 3;
                break;
            }
            case 24: {
                this.format = 4;
                this.attributes[0] = 8;
                this.attributes[1] = 3;
                break;
            }
            case 32: {
                this.format = 5;
                this.attributes[0] = 8;
                this.attributes[1] = 4;
            }
        }
        if (this.format == 1) {
            coloursUsed = 1 << bitsPerPixel;
            this.colourTable = new byte[coloursUsed][4];
            this.indexedImage = new byte[this.height][this.width];
            if (headerSize == 12) {
                int i2 = 0;
                while (i2 < coloursUsed) {
                    this.colourTable[i2][3] = -1;
                    this.colourTable[i2][2] = (byte)coder.readWord(1, false);
                    this.colourTable[i2][1] = (byte)coder.readWord(1, false);
                    this.colourTable[i2][0] = (byte)coder.readWord(1, false);
                    ++i2;
                }
            } else {
                int i3 = 0;
                while (i3 < coloursUsed) {
                    this.colourTable[i3][0] = (byte)coder.readWord(1, false);
                    this.colourTable[i3][1] = (byte)coder.readWord(1, false);
                    this.colourTable[i3][2] = (byte)coder.readWord(1, false);
                    this.colourTable[i3][3] = (byte)(coder.readWord(1, false) | 0xFF);
                    ++i3;
                }
            }
            coder.setPointer(offset << 3);
            switch (this.attributes[2]) {
                case 0: {
                    this.decodeIDX8(coder);
                    break;
                }
                case 1: {
                    this.decodeRLE8(coder);
                    break;
                }
                case 2: {
                    this.decodeRLE4(coder);
                }
            }
        } else {
            this.colorImage = new byte[this.height][this.width][4];
            coder.setPointer(offset << 3);
            switch (this.format) {
                case 3: {
                    this.decodeRGB5(coder);
                    break;
                }
                case 4: {
                    this.decodeRGB8(coder);
                    break;
                }
                case 5: {
                    this.decodeRGBA(coder);
                }
            }
        }
    }

    private void decodeIDX8(FSCoder coder) {
        int h = 0;
        int w = 0;
        int bitsRead = 0;
        h = this.height - 1;
        while (h > 0) {
            w = 0;
            bitsRead = 0;
            while (w < this.width) {
                this.indexedImage[h][w] = (byte)coder.readBits(this.attributes[0], false);
                bitsRead += this.attributes[0];
                ++w;
            }
            if (bitsRead % 32 > 0) {
                coder.adjustPointer(32 - bitsRead % 32);
            }
            --h;
        }
    }

    private void decodeRLE4(FSCoder coder) {
        int row = this.height - 1;
        int col = 0;
        boolean containsMorePixels = true;
        block5: while (containsMorePixels) {
            int count = coder.readWord(1, false);
            if (count == 0) {
                int code = coder.readWord(1, false);
                switch (code) {
                    case 0: {
                        col = 0;
                        --row;
                        break;
                    }
                    case 1: {
                        containsMorePixels = false;
                        break;
                    }
                    case 2: {
                        col += coder.readWord(2, false);
                        row -= coder.readWord(2, false);
                    }
                    default: {
                        int i = 0;
                        while (i < code) {
                            this.indexedImage[row][col++] = (byte)coder.readBits(4, false);
                            this.indexedImage[row][col++] = (byte)coder.readBits(4, false);
                            i += 2;
                        }
                        if ((code & 2) != 2) continue block5;
                        coder.readWord(1, false);
                        break;
                    }
                }
                continue;
            }
            byte indexA = (byte)coder.readBits(4, false);
            byte indexB = (byte)coder.readBits(4, false);
            int i = 0;
            while (i < count && col < this.width) {
                this.indexedImage[row][col++] = i % 2 > 0 ? indexB : indexA;
                ++i;
            }
        }
    }

    private void decodeRLE8(FSCoder coder) {
        int row = this.height - 1;
        int col = 0;
        boolean containsMorePixels = true;
        block5: while (containsMorePixels) {
            int i;
            int count = coder.readWord(1, false);
            if (count == 0) {
                int code = coder.readWord(1, false);
                switch (code) {
                    case 0: {
                        col = 0;
                        --row;
                        break;
                    }
                    case 1: {
                        containsMorePixels = false;
                        break;
                    }
                    case 2: {
                        col += coder.readWord(2, false);
                        row -= coder.readWord(2, false);
                    }
                    default: {
                        i = 0;
                        while (i < code) {
                            this.indexedImage[row][col++] = (byte)coder.readWord(1, false);
                            ++i;
                        }
                        if ((code & 1) != 1) continue block5;
                        coder.readWord(1, false);
                        break;
                    }
                }
                continue;
            }
            byte index = (byte)coder.readWord(1, false);
            i = 0;
            while (i < count) {
                this.indexedImage[row][col++] = index;
                ++i;
            }
        }
    }

    private void decodeRGB5(FSCoder coder) {
        int h = 0;
        int w = 0;
        int bitsRead = 0;
        if (this.attributes[2] == 0) {
            h = this.height - 1;
            while (h > 0) {
                w = 0;
                bitsRead = 0;
                while (w < this.width) {
                    int colour = coder.readWord(2, false) & 0xFFFF;
                    this.colorImage[h][w][0] = (byte)((colour & 0x7C00) >> 7);
                    this.colorImage[h][w][1] = (byte)((colour & 0x3E0) >> 2);
                    this.colorImage[h][w][2] = (byte)((colour & 0x1F) << 3);
                    this.colorImage[h][w][3] = -1;
                    bitsRead += 16;
                    ++w;
                }
                if (bitsRead % 32 > 0) {
                    coder.adjustPointer(32 - bitsRead % 32);
                }
                --h;
            }
        } else {
            h = this.height - 1;
            while (h > 0) {
                w = 0;
                bitsRead = 0;
                while (w < this.width) {
                    int colour = coder.readWord(2, false) & 0xFFFF;
                    if (this.attributes[4] == 31744 && this.attributes[5] == 992 && this.attributes[6] == 31) {
                        this.colorImage[h][w][0] = (byte)((colour & 0x7C00) >> 7);
                        this.colorImage[h][w][1] = (byte)((colour & 0x3E0) >> 2);
                        this.colorImage[h][w][2] = (byte)((colour & 0x1F) << 3);
                        this.colorImage[h][w][3] = -1;
                    } else if (this.attributes[4] == 63488 && this.attributes[5] == 2016 && this.attributes[6] == 31) {
                        this.colorImage[h][w][0] = (byte)((colour & 0xF800) >> 8);
                        this.colorImage[h][w][1] = (byte)((colour & 0x7E0) >> 3);
                        this.colorImage[h][w][2] = (byte)((colour & 0x1F) << 3);
                        this.colorImage[h][w][3] = -1;
                    }
                    bitsRead += 16;
                    ++w;
                }
                if (bitsRead % 32 > 0) {
                    coder.adjustPointer(32 - bitsRead % 32);
                }
                --h;
            }
        }
    }

    private void decodeRGB8(FSCoder coder) {
        int h = 0;
        int w = 0;
        int bitsRead = 0;
        h = this.height - 1;
        while (h > 0) {
            w = 0;
            bitsRead = 0;
            while (w < this.width) {
                this.colorImage[h][w][0] = (byte)coder.readBits(this.attributes[0], false);
                this.colorImage[h][w][1] = (byte)coder.readBits(this.attributes[0], false);
                this.colorImage[h][w][2] = (byte)coder.readBits(this.attributes[0], false);
                this.colorImage[h][w][3] = -1;
                bitsRead += 24;
                ++w;
            }
            if (bitsRead % 32 > 0) {
                coder.adjustPointer(32 - bitsRead % 32);
            }
            --h;
        }
    }

    private void decodeRGBA(FSCoder coder) {
        int h = 0;
        int w = 0;
        h = this.height - 1;
        while (h > 0) {
            w = 0;
            while (w < this.width) {
                this.colorImage[h][w][2] = (byte)coder.readWord(1, false);
                this.colorImage[h][w][1] = (byte)coder.readWord(1, false);
                this.colorImage[h][w][0] = (byte)coder.readWord(1, false);
                this.colorImage[h][w][3] = (byte)coder.readWord(1, false);
                this.colorImage[h][w][3] = -1;
                ++w;
            }
            --h;
        }
    }

    private void decodePNG(byte[] bytes) throws DataFormatException {
        FSCoder coder = new FSCoder(1, bytes);
        int length = 0;
        int chunkType = 0;
        boolean moreChunks = true;
        int i = 0;
        while (i < 8) {
            if (coder.readWord(1, false) != pngSignature[i]) {
                throw new DataFormatException("Not a valid PNG file");
            }
            ++i;
        }
        while (moreChunks) {
            length = coder.readWord(4, false);
            chunkType = coder.readWord(4, false);
            int current = coder.getPointer();
            int next = current + (length + 4 << 3);
            switch (chunkType) {
                case 1229472850: {
                    this.decodeIHDR(coder, length);
                    break;
                }
                case 1347179589: {
                    this.decodePLTE(coder, length);
                    break;
                }
                case 1951551059: {
                    this.decodeTRNS(coder, length);
                    break;
                }
                case 1229209940: {
                    this.decodeIDAT(coder, length);
                    break;
                }
                case 1229278788: {
                    moreChunks = false;
                    coder.adjustPointer(32);
                    break;
                }
                default: {
                    coder.adjustPointer(length + 4 << 3);
                }
            }
            length += 4;
            coder.setPointer(next);
            if (!coder.eof()) continue;
            moreChunks = false;
        }
        this.decodeImage();
    }

    private void decodeIHDR(FSCoder coder, int length) {
        this.width = coder.readWord(4, false);
        this.height = coder.readWord(4, false);
        this.attributes[0] = coder.readWord(1, false);
        this.attributes[4] = coder.readWord(1, false);
        this.attributes[2] = coder.readWord(1, false);
        this.attributes[5] = coder.readWord(1, false);
        this.attributes[6] = coder.readWord(1, false);
        coder.readWord(4, false);
        switch (this.attributes[4]) {
            case 0: {
                this.format = this.attributes[7] != -1 ? 5 : 4;
                this.attributes[1] = 1;
                break;
            }
            case 2: {
                this.format = this.attributes[8] != -1 ? 5 : 4;
                this.attributes[1] = 3;
                break;
            }
            case 3: {
                this.format = 1;
                this.attributes[1] = 1;
                break;
            }
            case 4: {
                this.format = 5;
                this.attributes[1] = 2;
                break;
            }
            case 6: {
                this.format = 5;
                this.attributes[1] = 4;
            }
        }
    }

    private void decodePLTE(FSCoder coder, int length) {
        if (this.attributes[4] == 3) {
            int paletteSize = length / 3;
            this.colourTable = new byte[paletteSize][4];
            int i = 0;
            while (i < paletteSize) {
                this.colourTable[i][3] = -1;
                this.colourTable[i][2] = (byte)coder.readWord(1, false);
                this.colourTable[i][1] = (byte)coder.readWord(1, false);
                this.colourTable[i][0] = (byte)coder.readWord(1, false);
                ++i;
            }
        } else {
            coder.adjustPointer(length << 3);
        }
        coder.readWord(4, false);
    }

    private void decodeTRNS(FSCoder coder, int length) {
        switch (this.attributes[4]) {
            case 0: {
                this.attributes[7] = coder.readWord(2, false);
                break;
            }
            case 2: {
                this.attributes[8] = coder.readWord(2, false);
                this.attributes[9] = coder.readWord(2, false);
                this.attributes[10] = coder.readWord(2, false);
                break;
            }
            case 3: {
                this.format = 2;
                int i = 0;
                while (i < length) {
                    this.colourTable[i][3] = (byte)coder.readWord(1, false);
                    if (this.colourTable[i][3] == 0) {
                        this.colourTable[i][0] = 0;
                        this.colourTable[i][1] = 0;
                        this.colourTable[i][2] = 0;
                    }
                    ++i;
                }
                break;
            }
        }
        coder.readWord(4, false);
    }

    private void decodeIDAT(FSCoder coder, int length) {
        int currentLength = this.chunkData.length;
        int newLength = currentLength + length;
        byte[] data = new byte[newLength];
        System.arraycopy(this.chunkData, 0, data, 0, currentLength);
        int i = currentLength;
        while (i < newLength) {
            data[i] = (byte)coder.readWord(1, false);
            ++i;
        }
        this.chunkData = data;
        coder.readWord(4, false);
    }

    private void decodeImage() throws DataFormatException {
        if (this.format == 4 && this.attributes[0] <= 5) {
            this.format = 3;
        }
        if (this.format == 3 || this.format == 4 || this.format == 5) {
            this.colorImage = new byte[this.height][this.width][4];
        }
        if (this.format == 1 || this.format == 2) {
            this.indexedImage = new byte[this.height][this.width];
        }
        byte[] encodedImage = this.unzip(this.chunkData);
        int bitsPerPixel = this.attributes[0] * this.attributes[1];
        int bitsPerRow = this.width * bitsPerPixel;
        int rowWidth = bitsPerRow % 8 > 0 ? bitsPerRow / 8 + 1 : bitsPerRow / 8;
        int bytesPerPixel = bitsPerPixel < 8 ? 1 : bitsPerPixel / 8;
        byte[] current = new byte[rowWidth];
        byte[] previous = new byte[rowWidth];
        int i = 0;
        while (i < rowWidth) {
            previous[i] = 0;
            ++i;
        }
        int rowStart = 0;
        int rowInc = 0;
        int colStart = 0;
        int colInc = 0;
        int imageIndex = 0;
        int pixelCount = 0;
        int row = 0;
        int col = 0;
        byte filter = 0;
        int scanBits = 0;
        int scanLength = 0;
        int numberOfPasses = this.attributes[6] == 1 ? 7 : 1;
        int xc = 0;
        int xp = 0;
        int pass = 0;
        while (pass < numberOfPasses) {
            rowStart = this.attributes[6] == 1 ? startRow[pass] : 0;
            rowInc = this.attributes[6] == 1 ? rowIncrement[pass] : 1;
            colStart = this.attributes[6] == 1 ? startColumn[pass] : 0;
            colInc = this.attributes[6] == 1 ? columnIncrement[pass] : 1;
            row = rowStart;
            while (row < this.height && imageIndex < encodedImage.length) {
                col = colStart;
                pixelCount = 0;
                scanBits = 0;
                while (col < this.width) {
                    ++pixelCount;
                    col += colInc;
                    scanBits += bitsPerPixel;
                }
                scanLength = scanBits % 8 > 0 ? scanBits / 8 + 1 : scanBits / 8;
                filter = encodedImage[imageIndex++];
                int i2 = 0;
                while (i2 < scanLength) {
                    current[i2] = imageIndex < encodedImage.length ? encodedImage[imageIndex] : previous[i2];
                    ++i2;
                    ++imageIndex;
                }
                switch (filter) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        xc = bytesPerPixel;
                        xp = 0;
                        while (xc < scanLength) {
                            current[xc] = (byte)(current[xc] + current[xp]);
                            ++xc;
                            ++xp;
                        }
                        break;
                    }
                    case 2: {
                        xc = 0;
                        while (xc < scanLength) {
                            current[xc] = (byte)(current[xc] + previous[xc]);
                            ++xc;
                        }
                        break;
                    }
                    case 3: {
                        xc = 0;
                        while (xc < bytesPerPixel) {
                            current[xc] = (byte)(current[xc] + (0 + (0xFF & previous[xc])) / 2);
                            ++xc;
                        }
                        xc = bytesPerPixel;
                        xp = 0;
                        while (xc < scanLength) {
                            current[xc] = (byte)(current[xc] + ((0xFF & current[xp]) + (0xFF & previous[xc])) / 2);
                            ++xc;
                            ++xp;
                        }
                        break;
                    }
                    case 4: {
                        xc = 0;
                        while (xc < bytesPerPixel) {
                            current[xc] = (byte)(current[xc] + this.Paeth((byte)0, previous[xc], (byte)0));
                            ++xc;
                        }
                        xc = bytesPerPixel;
                        xp = 0;
                        while (xc < scanLength) {
                            current[xc] = (byte)(current[xc] + this.Paeth(current[xp], previous[xc], previous[xp]));
                            ++xc;
                            ++xp;
                        }
                        break;
                    }
                }
                System.arraycopy(current, 0, previous, 0, scanLength);
                FSCoder coder = new FSCoder(1, current);
                col = colStart;
                while (col < this.width) {
                    switch (this.attributes[4]) {
                        case 0: {
                            this.decodeGreyscale(coder, row, col);
                            break;
                        }
                        case 2: {
                            this.decodeTrueColour(coder, row, col);
                            break;
                        }
                        case 3: {
                            this.decodeIndexedColour(coder, row, col);
                            break;
                        }
                        case 4: {
                            this.decodeAlphaGreyscale(coder, row, col);
                            break;
                        }
                        case 6: {
                            this.decodeAlphaTrueColour(coder, row, col);
                        }
                    }
                    col += colInc;
                }
                row += rowInc;
            }
            ++pass;
        }
    }

    private int Paeth(byte L, byte u, byte nw) {
        int pc;
        int pb;
        int a = 0xFF & L;
        int b = 0xFF & u;
        int c = 0xFF & nw;
        int p = a + b - c;
        int pa = p - a;
        if (pa < 0) {
            pa = -pa;
        }
        if ((pb = p - b) < 0) {
            pb = -pb;
        }
        if ((pc = p - c) < 0) {
            pc = -pc;
        }
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    private void decodeGreyscale(FSCoder coder, int row, int col) {
        int pixel = 0;
        byte colour = 0;
        switch (this.attributes[0]) {
            case 1: {
                pixel = coder.readBits(1, false);
                colour = (byte)monochrome[pixel];
                break;
            }
            case 2: {
                pixel = coder.readBits(2, false);
                colour = (byte)greyscale2[pixel];
                break;
            }
            case 4: {
                pixel = coder.readBits(4, false);
                colour = (byte)greyscale4[pixel];
                break;
            }
            case 8: {
                pixel = coder.readWord(1, false);
                colour = (byte)pixel;
                break;
            }
            case 16: {
                pixel = coder.readWord(2, false);
                colour = (byte)(pixel >> 8);
            }
        }
        this.colorImage[row][col][0] = colour;
        this.colorImage[row][col][1] = colour;
        this.colorImage[row][col][2] = colour;
        this.colorImage[row][col][3] = (byte)this.attributes[7];
    }

    private void decodeTrueColour(FSCoder coder, int row, int col) {
        int pixel = 0;
        byte colour = 0;
        int i = 0;
        while (i < this.attributes[1]) {
            switch (this.attributes[0]) {
                case 8: {
                    pixel = coder.readWord(1, false);
                    colour = (byte)pixel;
                    break;
                }
                case 16: {
                    pixel = coder.readWord(2, false);
                    colour = (byte)(pixel >> 8);
                }
            }
            this.colorImage[row][col][i] = colour;
            ++i;
        }
        this.colorImage[row][col][3] = (byte)this.attributes[8];
    }

    private void decodeIndexedColour(FSCoder coder, int row, int col) {
        int index = 0;
        switch (this.attributes[0]) {
            case 1: {
                index = coder.readBits(1, false);
                break;
            }
            case 2: {
                index = coder.readBits(2, false);
                break;
            }
            case 4: {
                index = coder.readBits(4, false);
                break;
            }
            case 8: {
                index = coder.readWord(1, false);
                break;
            }
            case 16: {
                index = coder.readWord(2, false);
            }
        }
        this.indexedImage[row][col] = (byte)index;
    }

    private void decodeAlphaGreyscale(FSCoder coder, int row, int col) {
        int pixel = 0;
        byte colour = 0;
        int alpha = 0;
        switch (this.attributes[0]) {
            case 1: {
                pixel = coder.readBits(1, false);
                colour = (byte)monochrome[pixel];
                alpha = coder.readBits(1, false);
                break;
            }
            case 2: {
                pixel = coder.readBits(2, false);
                colour = (byte)greyscale2[pixel];
                alpha = coder.readBits(2, false);
                break;
            }
            case 4: {
                pixel = coder.readBits(4, false);
                colour = (byte)greyscale4[pixel];
                alpha = coder.readBits(4, false);
                break;
            }
            case 8: {
                pixel = coder.readWord(1, false);
                colour = (byte)pixel;
                alpha = coder.readWord(1, false);
                break;
            }
            case 16: {
                pixel = coder.readWord(2, false);
                colour = (byte)(pixel >> 8);
                alpha = coder.readWord(2, false) >> 8;
            }
        }
        this.colorImage[row][col][0] = colour;
        this.colorImage[row][col][1] = colour;
        this.colorImage[row][col][2] = colour;
        this.colorImage[row][col][3] = (byte)alpha;
    }

    private void decodeAlphaTrueColour(FSCoder coder, int row, int col) {
        int pixel = 0;
        byte colour = 0;
        int i = 0;
        while (i < this.attributes[1]) {
            switch (this.attributes[0]) {
                case 8: {
                    pixel = coder.readWord(1, false);
                    colour = (byte)pixel;
                    break;
                }
                case 16: {
                    pixel = coder.readWord(2, false);
                    colour = (byte)(pixel >> 8);
                }
            }
            this.colorImage[row][col][i] = colour;
            ++i;
        }
    }

    private byte[] dataFromFile(String filename) throws FileNotFoundException, IOException {
        File aFile = new File(filename);
        FileInputStream imageContents = null;
        byte[] bytes = new byte[(int)aFile.length()];
        imageContents = new FileInputStream(aFile);
        imageContents.read(bytes);
        imageContents.close();
        return bytes;
    }

    private byte[] unzip(byte[] bytes) throws DataFormatException {
        byte[] data = new byte[this.width * this.height * 8];
        int count = 0;
        Inflater inflater = new Inflater();
        inflater.setInput(bytes);
        count = inflater.inflate(data);
        byte[] uncompressedData = new byte[count];
        System.arraycopy(data, 0, uncompressedData, 0, count);
        return uncompressedData;
    }

    private byte[] zip(byte[] image, byte[][] table, boolean hasAlpha) {
        int bytesPerColor = hasAlpha ? 4 : 3;
        byte[] combinedData = new byte[table.length * bytesPerColor + image.length];
        int index = 0;
        int i = 0;
        while (i < table.length) {
            combinedData[index++] = table[i][2];
            combinedData[index++] = table[i][1];
            combinedData[index++] = table[i][0];
            if (hasAlpha) {
                combinedData[index++] = table[i][3];
            }
            ++i;
        }
        i = 0;
        while (i < image.length) {
            combinedData[index++] = image[i];
            ++i;
        }
        return this.zip(combinedData);
    }

    private byte[] zip(byte[] image) {
        Deflater deflater = new Deflater();
        deflater.setInput(image);
        deflater.finish();
        byte[] compressedData = new byte[image.length * 2];
        int bytesCompressed = deflater.deflate(compressedData);
        byte[] newData = new byte[bytesCompressed];
        int i = 0;
        while (i < bytesCompressed) {
            newData[i] = compressedData[i];
            ++i;
        }
        return newData;
    }
}

