/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineSound;
import com.flagstone.transform.FSSoundStreamBlock;
import com.flagstone.transform.FSSoundStreamHead2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.DataFormatException;

public class FSSoundConstructor {
    private static final int[] riffSignature = new int[]{82, 73, 70, 70};
    private static final int[] wavSignature = new int[]{87, 65, 86, 69};
    private static final int FMT = 544501094;
    private static final int DATA = 1635017060;
    private static final int MPEG1 = 3;
    private static final int[] frameSizeMP3 = new int[]{576, 576, 576, 1152};
    private static final int[] channelCount = new int[]{2, 2, 2, 1};
    private static final int[][] bitRates = new int[][]{{-1, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {-1, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1}};
    private static final int[][] samplingRates = new int[][]{{11025, -1, -1, -1}, {-1, -1, -1, -1}, {22050, -1, -1, -1}, {44100, -1, -1, -1}};
    private int format = 3;
    private int numberOfChannels = 0;
    private int samplesPerChannel = 0;
    private int sampleRate = 0;
    private int sampleSize = 0;
    private byte[] sound = null;
    private int[][] frameTable = null;
    private int samplesPerFrame = 0;

    public FSSoundConstructor() {
    }

    public FSSoundConstructor(String fileName) throws IOException, DataFormatException {
        this.setSound(fileName);
    }

    public int getFormat() {
        return this.format;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public int getSamplesPerChannel() {
        return this.samplesPerChannel;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public byte[] getSound() {
        byte[] bytes = new byte[this.sound.length];
        System.arraycopy(this.sound, 0, bytes, 0, this.sound.length);
        return bytes;
    }

    public void setSound(String filename) throws IOException, DataFormatException {
        if (filename.toLowerCase().endsWith(".mp3")) {
            this.decodeMP3(this.dataFromFile(filename));
        } else if (filename.toLowerCase().endsWith(".wav")) {
            this.decodeWAV(filename);
        }
    }

    public void setSound(int format, int channelCount, int sampleCount, int sampleRate, int sampleSize, byte[] bytes) {
        this.format = format;
        this.numberOfChannels = channelCount;
        this.samplesPerChannel = sampleCount;
        this.sampleRate = sampleRate;
        this.sampleSize = sampleSize;
        this.sound = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.sound, 0, bytes.length);
        if (format == 2) {
            this.initFrameTable(bytes);
        }
    }

    public FSDefineSound defineSound(int anIdentifier) {
        byte[] bytes = null;
        switch (this.format) {
            case 1: 
            case 3: {
                bytes = new byte[this.sound.length];
                System.arraycopy(this.sound, 0, bytes, 0, this.sound.length);
                break;
            }
            case 2: {
                bytes = new byte[2 + this.sound.length];
                bytes[0] = 0;
                bytes[1] = 0;
                System.arraycopy(this.sound, 0, bytes, 2, this.sound.length);
            }
        }
        return new FSDefineSound(anIdentifier, this.format, this.sampleRate, this.numberOfChannels, this.sampleSize, this.samplesPerChannel, bytes);
    }

    public FSSoundStreamHead2 streamHeader(int samplesPerBlock) {
        return new FSSoundStreamHead2(this.format, this.sampleRate, this.numberOfChannels, this.sampleSize, this.sampleRate, this.numberOfChannels, this.sampleSize, samplesPerBlock, 0);
    }

    public FSSoundStreamBlock streamBlock(int blockNumber, int samplesPerBlock) {
        int firstSample = 0;
        int firstSampleOffset = 0;
        int bytesPerBlock = 0;
        int bytesRemaining = 0;
        int numberOfBytes = 0;
        int framesToSend = 0;
        int framesSent = 0;
        int frameCount = 0;
        int sampleCount = 0;
        int seek = 0;
        byte[] bytes = null;
        switch (this.format) {
            case 3: {
                firstSample = blockNumber * samplesPerBlock;
                firstSampleOffset = firstSample * this.sampleSize * this.numberOfChannels;
                bytesPerBlock = samplesPerBlock * this.sampleSize * this.numberOfChannels;
                bytesRemaining = this.sound.length - firstSampleOffset;
                numberOfBytes = bytesRemaining < bytesPerBlock ? bytesRemaining : bytesPerBlock;
                bytes = new byte[numberOfBytes];
                System.arraycopy(this.sound, firstSampleOffset, bytes, 0, numberOfBytes);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                framesToSend = (blockNumber + 1) * samplesPerBlock / this.samplesPerFrame;
                framesSent = blockNumber * samplesPerBlock / this.samplesPerFrame;
                frameCount = framesToSend - framesSent;
                sampleCount = frameCount * this.samplesPerFrame;
                seek = blockNumber * samplesPerBlock - framesSent * this.samplesPerFrame;
                numberOfBytes = 4;
                int i = 0;
                int j = framesSent;
                while (i < frameCount) {
                    numberOfBytes += this.frameTable[j][1];
                    ++i;
                    ++j;
                }
                bytes = new byte[numberOfBytes];
                bytes[0] = (byte)sampleCount;
                bytes[1] = (byte)(sampleCount >> 8);
                bytes[2] = (byte)seek;
                bytes[3] = (byte)(seek >> 8);
                int offset = 4;
                int i2 = 0;
                int j2 = framesSent;
                while (i2 < frameCount) {
                    System.arraycopy(this.sound, this.frameTable[j2][0], bytes, offset, this.frameTable[j2][1]);
                    offset += this.frameTable[j2][1];
                    ++i2;
                    ++j2;
                }
                break;
            }
        }
        if (bytes != null) {
            return new FSSoundStreamBlock(bytes);
        }
        return null;
    }

    private void decodeWAV(String filename) throws FileNotFoundException, IOException, DataFormatException {
        FSCoder coder = new FSCoder(0, this.dataFromFile(filename));
        int length = 0;
        int chunkType = 0;
        boolean moreChunks = true;
        int i = 0;
        while (i < 4) {
            if (coder.readWord(1, false) != riffSignature[i]) {
                throw new DataFormatException("Not a valid RIFF file");
            }
            ++i;
        }
        coder.readWord(4, false);
        i = 0;
        while (i < 4) {
            if (coder.readWord(1, false) != wavSignature[i]) {
                throw new DataFormatException("Not a valid WAV file");
            }
            ++i;
        }
        while (moreChunks) {
            chunkType = coder.readWord(4, false);
            length = coder.readWord(4, false);
            int blockStart = coder.getPointer();
            switch (chunkType) {
                case 544501094: {
                    this.decodeFMT(coder);
                    break;
                }
                case 1635017060: {
                    this.decodeDATA(coder, length);
                    break;
                }
                default: {
                    coder.adjustPointer(length << 3);
                }
            }
            int nextBlock = blockStart + (length << 3);
            coder.setPointer(nextBlock);
            boolean bl = moreChunks = !coder.eof();
        }
    }

    private void decodeFMT(FSCoder coder) throws DataFormatException {
        this.format = 3;
        if (coder.readWord(2, false) != 1) {
            throw new DataFormatException("Compressed WAV files are not currently supported.");
        }
        this.numberOfChannels = coder.readWord(2, false);
        this.sampleRate = coder.readWord(4, false);
        coder.readWord(4, false);
        coder.readWord(2, false);
        this.sampleSize = coder.readWord(2, false) / 8;
    }

    private void decodeDATA(FSCoder coder, int length) {
        this.samplesPerChannel = length / (this.sampleSize * this.numberOfChannels);
        this.sound = new byte[length];
        coder.readBytes(this.sound);
    }

    private void decodeMP3(byte[] bytes) throws DataFormatException {
        FSCoder coder = new FSCoder(1, bytes);
        int numberOfFrames = 0;
        int frameStart = 0;
        this.format = 2;
        this.sampleSize = 2;
        while (!coder.eof()) {
            if (coder.scanWord(3, false) == 0x494433) {
                coder.adjustPointer(24);
                coder.adjustPointer(8);
                coder.adjustPointer(8);
                coder.adjustPointer(1);
                coder.adjustPointer(1);
                coder.adjustPointer(1);
                int hasFooter = coder.readBits(1, false);
                coder.adjustPointer(4);
                int totalLength = hasFooter == 1 ? 10 : 0;
                totalLength += coder.readWord(1, false) << 23;
                totalLength += coder.readWord(1, false) << 15;
                totalLength += coder.readWord(1, false) << 7;
                coder.adjustPointer((totalLength += coder.readWord(1, false)) << 3);
                continue;
            }
            if (coder.scanWord(3, false) == 5521735) {
                coder.adjustPointer(1024);
                continue;
            }
            if (coder.scanBits(11, false) == 2047) {
                if (numberOfFrames == 0) {
                    frameStart = coder.getPointer();
                }
                coder.adjustPointer(this.MP3FrameSize(coder) << 3);
                ++numberOfFrames;
                continue;
            }
            coder.setPointer(bytes.length << 3);
        }
        int dataLength = bytes.length - (frameStart >> 3);
        this.sound = new byte[dataLength];
        System.arraycopy(bytes, frameStart >> 3, this.sound, 0, dataLength);
        this.frameTable = new int[numberOfFrames][2];
        int i = 0;
        while (i < numberOfFrames) {
            this.frameTable[i][0] = -1;
            this.frameTable[i][1] = 0;
            ++i;
        }
        coder.setPointer(frameStart);
        int frameNumber = 0;
        while (coder.findBits(2047, 11, 8)) {
            this.frameTable[frameNumber][0] = coder.getPointer() - frameStart + 16 >> 3;
            coder.adjustPointer(11);
            int version = coder.readBits(2, false);
            this.samplesPerFrame = frameSizeMP3[version];
            if (coder.readBits(2, false) != 1) {
                throw new DataFormatException("Flash only supports MPEG Layer 3");
            }
            coder.readBits(1, false);
            int bitRate = bitRates[version][coder.readBits(4, false)];
            if (bitRate == -1) {
                throw new DataFormatException("Unsupported Bit-rate");
            }
            this.sampleRate = samplingRates[version][coder.readBits(2, false)];
            if (this.sampleRate == -1) {
                throw new DataFormatException("Unsupported Sampling-rate");
            }
            int padding = coder.readBits(1, false);
            coder.readBits(1, false);
            this.numberOfChannels = channelCount[coder.readBits(2, false)];
            coder.adjustPointer(6);
            this.samplesPerChannel += this.samplesPerFrame;
            int frameSize = (version == 3 ? 144 : 72) * bitRate * 1000 / this.sampleRate + padding - 4;
            this.frameTable[frameNumber++][1] = 4 + frameSize;
            coder.adjustPointer(frameSize << 3);
        }
    }

    private byte[] dataFromFile(String filename) throws IOException {
        File aFile = new File(filename);
        FileInputStream imageContents = null;
        byte[] bytes = new byte[(int)aFile.length()];
        imageContents = new FileInputStream(aFile);
        imageContents.read(bytes);
        imageContents.close();
        return bytes;
    }

    private void initFrameTable(byte[] bytes) {
        FSCoder coder = new FSCoder(0, bytes);
        coder.findBits(2047, 11, 8);
        int frameStart = coder.getPointer();
        int numberOfFrames = 0;
        while (coder.findBits(2047, 11, 8)) {
            coder.adjustPointer(this.MP3FrameSize(coder) << 3);
            ++numberOfFrames;
        }
        this.frameTable = new int[numberOfFrames][2];
        coder.setPointer(frameStart);
        int frameNumber = 0;
        while (coder.findBits(2047, 11, 8)) {
            this.frameTable[frameNumber][0] = coder.getPointer() - frameStart + 16 >> 3;
            coder.adjustPointer(11);
            int version = coder.readBits(2, false);
            coder.adjustPointer(3);
            int bitRate = bitRates[version][coder.readBits(4, false)];
            int samplingRate = samplingRates[version][coder.readBits(2, false)];
            int padding = coder.readBits(1, false);
            this.frameTable[frameNumber++][1] = 4 + ((version == 3 ? 144 : 72) * bitRate * 1000 / samplingRate + padding) - 4;
            coder.adjustPointer((this.MP3FrameSize(coder) << 3) - 23);
        }
    }

    private int MP3FrameSize(FSCoder coder) {
        int frameSize = 4;
        coder.adjustPointer(11);
        int version = coder.readBits(2, false);
        coder.adjustPointer(3);
        int bitRate = bitRates[version][coder.readBits(4, false)];
        int samplingRate = samplingRates[version][coder.readBits(2, false)];
        int padding = coder.readBits(1, false);
        coder.adjustPointer(-23);
        return frameSize += (version == 3 ? 144 : 72) * bitRate * 1000 / samplingRate + padding - 4;
    }
}

