/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util;

import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCharacter;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSColor;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSCurve;
import com.flagstone.transform.FSDefineFont;
import com.flagstone.transform.FSDefineFont2;
import com.flagstone.transform.FSDefineShape3;
import com.flagstone.transform.FSDefineText;
import com.flagstone.transform.FSDefineText2;
import com.flagstone.transform.FSFontInfo;
import com.flagstone.transform.FSLine;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSShapeStyle;
import com.flagstone.transform.FSSolidFill;
import com.flagstone.transform.FSText;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.util.FSShapeConstructor;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.DataFormatException;

public class FSTextConstructor {
    private static final int OS_2 = 1330851634;
    private static final int HEAD = 1751474532;
    private static final int HHEA = 1751672161;
    private static final int MAXP = 1835104368;
    private static final int LOCA = 1819239265;
    private static final int CMAP = 1668112752;
    private static final int HMTX = 1752003704;
    private static final int NAME = 1851878757;
    private static final int GLYF = 1735162214;
    private static final int ITLF_SHORT = 0;
    private static final int ITLF_LONG = 1;
    private static final int FONT_WEIGHT_THIN = 100;
    private static final int FONT_WEIGHT_EXTRALIGHT = 200;
    private static final int FONT_WEIGHT_LIGHT = 300;
    private static final int FONT_WEIGHT_NORMAL = 400;
    private static final int FONT_WEIGHT_MEDIUM = 500;
    private static final int FONT_WEIGHT_SEMIBOLD = 600;
    private static final int FONT_WEIGHT_BOLD = 700;
    private static final int FONT_WEIGHT_EXTRABOLD = 800;
    private static final int FONT_WEIGHT_BLACK = 900;
    private static final int ON_CURVE = 1;
    private static final int X_SHORT = 2;
    private static final int Y_SHORT = 4;
    private static final int REPEAT_FLAG = 8;
    private static final int X_SAME = 16;
    private static final int Y_SAME = 32;
    private static final int X_POSITIVE = 16;
    private static final int Y_POSITIVE = 32;
    private static final int ARG_1_AND_2_ARE_WORDS = 1;
    private static final int ARGS_ARE_XY_VALUES = 2;
    private static final int WE_HAVE_A_SCALE = 8;
    private static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private static final int WE_HAVE_A_TWO_BY_TWO = 128;
    private static final int MORE_COMPONENTS = 16;
    private static final int NUMBER_OF_METRICS = 0;
    private static final int SCALE = 1;
    private static final int GLYPH_OFFSET_SIZE = 2;
    private int identifier = 0;
    private String name = "";
    private int encoding = 0;
    private float size = 0.0f;
    private boolean isBold = false;
    private boolean isItalic = false;
    private int baseline = 0;
    private float ascent = 0.0f;
    private float descent = 0.0f;
    private float leading = 0.0f;
    private short[] orderTable = new short[65536];
    private short[] characterTable = new short[65536];
    private FSGlyph[] glyphTable = null;
    private int numberOfGlyphs = 0;
    private int missingGlyph = 0;
    private ArrayList kernings = new ArrayList();
    private int[] attributes = new int[8];

    public FSTextConstructor(int anIdentifier, String filename) throws IOException, DataFormatException {
        this.identifier = anIdentifier;
        int i = 0;
        while (i < 65536) {
            this.orderTable[i] = -1;
            ++i;
        }
        if (filename.toLowerCase().endsWith(".swf")) {
            this.decodeSWFFont(filename);
        } else if (filename.toLowerCase().endsWith(".otf")) {
            this.decodeOpenTypeFont(filename);
        } else if (filename.toLowerCase().endsWith(".ttf")) {
            this.decodeOpenTypeFont(filename);
        } else {
            this.decodeAWTFont(filename);
        }
    }

    public FSTextConstructor(int anIdentifier, Font font) {
        this.identifier = anIdentifier;
        int i = 0;
        while (i < 65536) {
            this.orderTable[i] = -1;
            ++i;
        }
        this.decodeAWTFont(font);
    }

    public void reset(int anIdentifier) {
        this.identifier = anIdentifier;
        int i = 0;
        while (i < 65536) {
            this.orderTable[i] = -1;
            ++i;
        }
    }

    public int canDisplay(char[] chars) {
        int firstMissingChar = -1;
        int i = 0;
        while (i < chars.length) {
            if (!this.canDisplay(chars[i])) {
                firstMissingChar = i;
                break;
            }
            ++i;
        }
        return firstMissingChar;
    }

    public int canDisplay(String aString) {
        int firstMissingChar = -1;
        int i = 0;
        while (i < aString.length()) {
            if (!this.canDisplay(aString.charAt(i))) {
                firstMissingChar = i;
                break;
            }
            ++i;
        }
        return firstMissingChar;
    }

    public void willDisplay(char[] chars) {
        int i = 0;
        while (i < chars.length) {
            short glyphIndex = this.characterTable[chars[i]];
            int index = 0;
            while (index < 65536) {
                if (this.orderTable[index] == glyphIndex) break;
                if (this.orderTable[index] == -1) {
                    this.orderTable[index] = glyphIndex;
                    break;
                }
                ++index;
            }
            ++i;
        }
    }

    public FSDefineFont2 defineFont() {
        FSDefineFont2 font = null;
        int count = 0;
        count = 0;
        while (this.orderTable[count] != -1 && count < this.orderTable.length) {
            ++count;
        }
        ArrayList<FSShape> glyphsArray = new ArrayList<FSShape>(count);
        ArrayList<Integer> codesArray = new ArrayList<Integer>(count);
        ArrayList<Integer> advancesArray = new ArrayList<Integer>(count);
        ArrayList<FSBounds> boundsArray = new ArrayList<FSBounds>(count);
        int i = 0;
        while (i < count) {
            short glyphIndex = this.orderTable[i];
            int character = 0;
            while (this.characterTable[character] != glyphIndex) {
                ++character;
            }
            glyphsArray.add(this.glyphTable[glyphIndex].shape);
            codesArray.add(new Integer(character));
            advancesArray.add(new Integer(this.glyphTable[glyphIndex].advance));
            boundsArray.add(this.glyphTable[glyphIndex].bounds);
            ++i;
        }
        font = new FSDefineFont2(this.identifier, this.name);
        font.setEncoding(this.encoding);
        font.setItalic(this.isItalic);
        font.setBold(this.isBold);
        font.setAscent((int)this.ascent);
        font.setDescent((int)this.descent);
        font.setLeading((int)this.leading);
        font.setShapes(glyphsArray);
        font.setCodes(codesArray);
        font.setAdvances(advancesArray);
        font.setBounds(boundsArray);
        font.setKernings(this.kernings);
        return font;
    }

    public FSDefineText2 defineText(int anIdentifier, String text, int fontSize, FSColor aColor) {
        FSCoordTransform coordTransform = new FSCoordTransform(0, 0);
        float scaleFactor = (float)fontSize / 1024.0f;
        int[] glyphCodes = this.glyphIndicesForString(text);
        int[] glyphAdvances = this.advancesForGlyphIndices(glyphCodes, scaleFactor);
        FSText textRecord = new FSText(this.identifier, aColor, 0, this.scaleBaseline(scaleFactor), fontSize, this.charactersForGlyphs(glyphCodes, glyphAdvances));
        ArrayList<FSText> textRecords = new ArrayList<FSText>();
        textRecords.add(textRecord);
        return new FSDefineText2(anIdentifier, this.boundsForText(glyphCodes, glyphAdvances, fontSize), coordTransform, textRecords);
    }

    public FSDefineText2 defineTextBlock(int anIdentifier, ArrayList lines, int fontSize, FSColor aColor, int lineSpacing) {
        FSCoordTransform coordTransform = new FSCoordTransform(0, 0);
        float scaleFactor = (float)fontSize / 1024.0f;
        int xMin = 0;
        int yMin = 0;
        int xMax = 0;
        int yMax = 0;
        int xOffset = 0;
        int yOffset = this.scaleBaseline(scaleFactor);
        ArrayList<FSText> textRecords = new ArrayList<FSText>();
        int n = 0;
        Iterator i = lines.iterator();
        while (i.hasNext()) {
            String text = (String)i.next();
            int[] glyphCodes = this.glyphIndicesForString(text);
            int[] glyphAdvances = this.advancesForGlyphIndices(glyphCodes, scaleFactor);
            FSBounds bounds = this.boundsForText(glyphCodes, glyphAdvances, fontSize);
            if (n == 0) {
                yMin = bounds.getMinY();
                yMax = bounds.getMaxY();
            } else {
                yMax += lineSpacing;
            }
            if (n == lines.size() - 1) {
                yMax += bounds.getHeight();
            }
            xMin = xMin < bounds.getMinX() ? xMin : bounds.getMinX();
            xMax = xMax > bounds.getMaxX() ? xMax : bounds.getMaxX();
            FSText textRecord = new FSText(this.identifier, aColor, xOffset, yOffset, fontSize, this.charactersForGlyphs(glyphCodes, glyphAdvances));
            textRecords.add(textRecord);
            yOffset += lineSpacing;
            ++n;
        }
        return new FSDefineText2(anIdentifier, new FSBounds(xMin, yMin, xMax, yMax), coordTransform, textRecords);
    }

    public FSBounds boundsForText(String text, int fontSize) {
        float scaleFactor = (float)fontSize / 1024.0f;
        int[] glyphCodes = this.glyphIndicesForString(text);
        int[] glyphAdvances = this.advancesForGlyphIndices(glyphCodes, scaleFactor);
        return this.boundsForText(glyphCodes, glyphAdvances, fontSize);
    }

    public int advanceForChar(char c, int fontSize) {
        float scaleFactor = (float)fontSize / 1024.0f;
        short index = this.characterTable[c];
        int advance = (int)((float)this.glyphTable[index].advance * scaleFactor);
        return advance;
    }

    public FSDefineShape3 defineShape(int anIdentifier, String text, int fontSize, FSColor aColor) {
        FSShapeConstructor path = new FSShapeConstructor();
        path.add(new FSSolidFill(aColor));
        path.selectFillStyle(0);
        float scaleFactor = (float)fontSize / 1024.0f;
        int[] glyphCodes = this.glyphIndicesForString(text);
        int[] glyphAdvances = this.advancesForGlyphIndices(glyphCodes, scaleFactor);
        int xOffset = 0;
        int i = 0;
        while (i < text.length()) {
            ArrayList array = this.glyphTable[this.orderTable[glyphCodes[i]]].shape.getObjects();
            Iterator j = array.iterator();
            while (j.hasNext()) {
                FSTransformObject currentObject = (FSTransformObject)j.next();
                if (currentObject instanceof FSShapeStyle) {
                    FSShapeStyle style = (FSShapeStyle)currentObject;
                    int moveX = (int)((double)((float)style.getMoveX() * scaleFactor) + (style.getMoveX() < 0 ? -0.5 : 0.5));
                    int moveY = (int)((double)((float)style.getMoveY() * scaleFactor) + (style.getMoveY() < 0 ? -0.5 : 0.5));
                    path.closePath();
                    path.move(moveX + xOffset, moveY);
                    continue;
                }
                if (currentObject instanceof FSLine) {
                    FSLine line = (FSLine)currentObject;
                    int x = (int)((double)((float)line.getX() * scaleFactor) + (line.getX() < 0 ? -0.5 : 0.5));
                    int y = (int)((double)((float)line.getY() * scaleFactor) + (line.getY() < 0 ? -0.5 : 0.5));
                    path.rline(x, y);
                    continue;
                }
                if (!(currentObject instanceof FSCurve)) continue;
                FSCurve curve = (FSCurve)currentObject;
                int cx = (int)((double)((float)curve.getControlX() * scaleFactor) + (curve.getControlX() < 0 ? -0.5 : 0.5));
                int cy = (int)((double)((float)curve.getControlY() * scaleFactor) + (curve.getControlY() < 0 ? -0.5 : 0.5));
                int ax = (int)((double)((float)curve.getAnchorX() * scaleFactor) + (curve.getAnchorX() < 0 ? -0.5 : 0.5));
                int ay = (int)((double)((float)curve.getAnchorY() * scaleFactor) + (curve.getAnchorY() < 0 ? -0.5 : 0.5));
                path.rcurve(cx, cy, ax, ay);
            }
            path.closePath();
            xOffset += glyphAdvances[i];
            ++i;
        }
        return path.defineTransparentShape(anIdentifier);
    }

    private void decodeSWFFont(String filename) throws IOException, DataFormatException {
        FSMovie fontMovie = new FSMovie(filename);
        FSDefineFont font = null;
        FSFontInfo fontInfo = null;
        FSDefineText text = null;
        FSText textRecord = null;
        Iterator i = fontMovie.getObjects().iterator();
        while (i.hasNext()) {
            FSMovieObject currentObject = (FSMovieObject)i.next();
            if (currentObject instanceof FSDefineFont) {
                font = (FSDefineFont)currentObject;
                continue;
            }
            if (currentObject instanceof FSFontInfo) {
                fontInfo = (FSFontInfo)currentObject;
                continue;
            }
            if (!(currentObject instanceof FSDefineText)) continue;
            text = (FSDefineText)currentObject;
        }
        textRecord = (FSText)text.getObjects().get(0);
        this.name = fontInfo.getName();
        this.encoding = fontInfo.getEncoding();
        this.size = textRecord.getHeight();
        this.isBold = fontInfo.isBold();
        this.isItalic = fontInfo.isItalic();
        if (this.encoding == 1) {
            this.encoding = 0;
        }
        this.glyphTable = new FSGlyph[font.getShapes().size()];
        int glyphIndex = 0;
        Iterator j = font.getShapes().iterator();
        while (j.hasNext()) {
            this.glyphTable[glyphIndex] = new FSGlyph((FSShape)j.next(), new FSBounds(0, 0, 0, 0));
            ++glyphIndex;
        }
        glyphIndex = 0;
        Iterator k = fontInfo.getCodes().iterator();
        while (k.hasNext()) {
            this.characterTable[((Integer)k.next()).intValue()] = (short)glyphIndex;
            ++glyphIndex;
        }
        Iterator l = textRecord.getCharacters().iterator();
        while (l.hasNext()) {
            FSCharacter character = (FSCharacter)l.next();
            this.glyphTable[character.getGlyphIndex()].advance = (int)((double)character.getAdvance() * (1024.0 / (double)this.size));
        }
        this.orderTable[0] = 0;
    }

    private void decodeAWTFont(String fontName) {
        double scaleY;
        FontRenderContext fontContext = new FontRenderContext(new AffineTransform(), true, true);
        Font font = new Font(fontName, 0, 1);
        if (font == null) {
            throw new IllegalArgumentException("No such font: " + fontName);
        }
        this.name = fontName;
        this.encoding = 0;
        Rectangle2D transform = this.transformToEMSquare(font, fontContext);
        double scaleX = scaleY = 1024.0;
        double translateX = 1024.0 - transform.getX() * 1024.0;
        double translateY = 1024.0 - transform.getY() * 1024.0;
        this.size = (float)scaleY;
        font = font.deriveFont((float)scaleX);
        this.missingGlyph = font.getMissingGlyphCode();
        this.isBold = font.isBold();
        this.isItalic = font.isItalic();
        int numGlyphs = font.getNumGlyphs();
        int glyphIndex = 0;
        int characterCode = 0;
        this.glyphTable = new FSGlyph[numGlyphs];
        while (glyphIndex < numGlyphs && characterCode < 65535) {
            LineMetrics lineMetrics;
            int advance;
            Shape outline;
            GlyphVector glyphVector;
            char currentChar = (char)characterCode;
            if (font.canDisplay(currentChar)) {
                glyphVector = font.createGlyphVector(fontContext, new char[]{currentChar});
                outline = glyphVector.getGlyphOutline(0);
                advance = (int)glyphVector.getGlyphMetrics(0).getAdvance();
                this.characterTable[currentChar] = (short)glyphIndex;
                this.glyphTable[glyphIndex] = new FSGlyph(this.convertShape(outline), new FSBounds(0, 0, 0, 0));
                this.glyphTable[glyphIndex].advance = advance;
                if (!font.hasUniformLineMetrics()) {
                    lineMetrics = font.getLineMetrics(new char[]{currentChar}, 0, 1, fontContext);
                    this.ascent = 0.0f;
                    this.descent = 0.0f;
                    this.leading = 0.0f;
                }
            } else {
                glyphVector = font.createGlyphVector(fontContext, new char[]{(char)this.missingGlyph});
                outline = glyphVector.getGlyphOutline(0);
                advance = (int)glyphVector.getGlyphMetrics(0).getAdvance();
                this.characterTable[currentChar] = (short)glyphIndex;
                this.glyphTable[glyphIndex] = new FSGlyph(this.convertShape(outline), new FSBounds(0, 0, 0, 0));
                this.glyphTable[glyphIndex].advance = advance;
                if (!font.hasUniformLineMetrics()) {
                    lineMetrics = font.getLineMetrics(new char[]{currentChar}, 0, 1, fontContext);
                    this.ascent = 0.0f;
                    this.descent = 0.0f;
                    this.leading = 0.0f;
                }
            }
            ++glyphIndex;
            ++characterCode;
        }
        this.orderTable[0] = (short)this.missingGlyph;
    }

    private void decodeAWTFont(Font font) {
        double scaleY;
        FontRenderContext fontContext = new FontRenderContext(new AffineTransform(), true, true);
        font = font.deriveFont(1.0f);
        this.name = font.getName();
        this.encoding = 0;
        Rectangle2D transform = this.transformToEMSquare(font, fontContext);
        double scaleX = scaleY = 1024.0;
        double translateX = 1024.0 - transform.getX() * 1024.0;
        double translateY = 1024.0 - transform.getY() * 1024.0;
        this.size = (float)scaleY;
        AffineTransform at = AffineTransform.getTranslateInstance(translateX, translateY);
        font = font.deriveFont(at);
        font = font.deriveFont((float)scaleX);
        this.missingGlyph = font.getMissingGlyphCode();
        this.isBold = font.isBold();
        this.isItalic = font.isItalic();
        int numGlyphs = font.getNumGlyphs();
        int glyphIndex = 0;
        int characterCode = 0;
        this.glyphTable = new FSGlyph[numGlyphs];
        while (glyphIndex < numGlyphs && characterCode < 65535) {
            LineMetrics lineMetrics;
            int advance;
            Shape outline;
            GlyphVector glyphVector;
            char currentChar = (char)characterCode;
            if (font.canDisplay(currentChar)) {
                glyphVector = font.createGlyphVector(fontContext, new char[]{currentChar});
                outline = glyphVector.getGlyphOutline(0);
                advance = (int)glyphVector.getGlyphMetrics(0).getAdvance();
                this.characterTable[currentChar] = (short)glyphIndex;
                this.glyphTable[glyphIndex] = new FSGlyph(this.convertShape(outline), new FSBounds(0, 0, 0, 0));
                this.glyphTable[glyphIndex].advance = advance;
                if (!font.hasUniformLineMetrics()) {
                    lineMetrics = font.getLineMetrics(new char[]{currentChar}, 0, 1, fontContext);
                    this.ascent = 0.0f;
                    this.descent = 0.0f;
                    this.leading = 0.0f;
                }
            } else {
                glyphVector = font.createGlyphVector(fontContext, new char[]{(char)this.missingGlyph});
                outline = glyphVector.getGlyphOutline(0);
                advance = (int)glyphVector.getGlyphMetrics(0).getAdvance();
                this.characterTable[currentChar] = (short)glyphIndex;
                this.glyphTable[glyphIndex] = new FSGlyph(this.convertShape(outline), new FSBounds(0, 0, 0, 0));
                this.glyphTable[glyphIndex].advance = advance;
                if (!font.hasUniformLineMetrics()) {
                    lineMetrics = font.getLineMetrics(new char[]{currentChar}, 0, 1, fontContext);
                    this.ascent = 0.0f;
                    this.descent = 0.0f;
                    this.leading = 0.0f;
                }
            }
            ++glyphIndex;
            ++characterCode;
        }
        this.orderTable[0] = (short)this.missingGlyph;
    }

    private Rectangle2D transformToEMSquare(Font font, FontRenderContext fontContext) {
        int numGlyphs = font.getNumGlyphs();
        int characterCode = 0;
        int glyphIndex = 0;
        double x = 0.0;
        double y = 0.0;
        double w = 0.0;
        double h = 0.0;
        while (glyphIndex < numGlyphs && characterCode < 65535) {
            char currentChar = (char)characterCode;
            if (font.canDisplay(currentChar)) {
                GlyphVector glyphVector = font.createGlyphVector(fontContext, new char[]{currentChar});
                Rectangle2D bounds = glyphVector.getGlyphOutline(0).getBounds2D();
                x = Math.min(bounds.getX(), x);
                y = Math.min(bounds.getY(), y);
                w = Math.max(bounds.getWidth(), w);
                h = Math.max(bounds.getHeight(), h);
                ++glyphIndex;
            }
            ++characterCode;
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    private FSShape convertShape(Shape glyph) {
        PathIterator pathIter = glyph.getPathIterator(null);
        FSShapeConstructor path = new FSShapeConstructor();
        double[] coords = new double[6];
        boolean xOrigin = false;
        boolean yOrigin = false;
        boolean currentX = false;
        boolean currentY = false;
        while (!pathIter.isDone()) {
            int segmentType = pathIter.currentSegment(coords);
            int p1 = (int)coords[0];
            int p2 = (int)coords[1];
            int p3 = (int)coords[2];
            int p4 = (int)coords[3];
            int p5 = (int)coords[4];
            int p6 = (int)coords[5];
            switch (segmentType) {
                case 0: {
                    path.closePath();
                    path.move(p1, p2);
                    break;
                }
                case 1: {
                    path.line(p1, p2);
                    break;
                }
                case 2: {
                    path.curve(p1, p2, p3, p4);
                    break;
                }
                case 3: {
                    path.curve(p1, p2, p3, p4, p5, p6);
                    break;
                }
                case 4: {
                    path.closePath();
                }
            }
            pathIter.next();
        }
        if (path.objects.size() > 0) {
            FSShapeStyle style = (FSShapeStyle)path.objects.get(0);
            style.setLineStyle(0);
            style.setAltFillStyle(1);
        }
        return path.shape();
    }

    private FSBounds boundsForText(int[] glyphIndices, int[] advances, int fontSize) {
        float scaleEMSquare = (float)fontSize / 1024.0f;
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        boolean any = false;
        int advance = 0;
        int i = 0;
        while (i < glyphIndices.length) {
            ArrayList array = null;
            array = this.glyphTable[this.orderTable[glyphIndices[i]]] == null ? this.glyphTable[this.missingGlyph].shape.getObjects() : this.glyphTable[this.orderTable[glyphIndices[i]]].shape.getObjects();
            int x = advance;
            int y = 0;
            Iterator j = array.iterator();
            while (j.hasNext()) {
                FSTransformObject currentObject = (FSTransformObject)j.next();
                if (currentObject instanceof FSShapeStyle) {
                    FSShapeStyle style = (FSShapeStyle)currentObject;
                    x = advance + style.getMoveX();
                    y = style.getMoveY();
                } else if (currentObject instanceof FSLine) {
                    FSLine line = (FSLine)currentObject;
                    x += line.getX();
                    y += line.getY();
                } else if (currentObject instanceof FSCurve) {
                    FSCurve curve = (FSCurve)currentObject;
                    x += curve.getControlX() + curve.getAnchorX();
                    y += curve.getControlY() + curve.getAnchorY();
                }
                if (any) {
                    minX = Math.min(minX, x);
                    maxX = Math.max(maxX, x);
                    minY = Math.min(minY, y);
                    maxY = Math.max(maxY, y);
                    continue;
                }
                minX = maxX = x;
                minY = maxY = y;
                any = true;
            }
            advance = (int)((float)advance + (float)advances[i] / scaleEMSquare);
            ++i;
        }
        minX = (int)((float)minX * scaleEMSquare);
        maxX = (int)((float)maxX * scaleEMSquare);
        minY = (int)((float)minY * scaleEMSquare) + this.scaleBaseline(scaleEMSquare);
        maxY = (int)((float)maxY * scaleEMSquare) + this.scaleBaseline(scaleEMSquare);
        return new FSBounds(minX, minY, maxX, maxY);
    }

    private ArrayList charactersForGlyphs(int[] codes, int[] advances) {
        ArrayList<FSCharacter> characters = new ArrayList<FSCharacter>(codes.length);
        int i = 0;
        while (i < codes.length) {
            characters.add(new FSCharacter(codes[i], advances[i]));
            ++i;
        }
        return characters;
    }

    private boolean canDisplay(char c) {
        boolean canDisplay = false;
        if (c < this.characterTable.length && this.characterTable[c] != 0) {
            canDisplay = true;
        }
        return canDisplay;
    }

    private int[] glyphIndicesForString(String aString) {
        int[] glyphCodes = new int[aString.length()];
        int i = 0;
        while (i < aString.length()) {
            char character = aString.charAt(i);
            short glyphIndex = this.characterTable[character];
            int index = 0;
            index = 0;
            while (index < 65536) {
                if (this.orderTable[index] == glyphIndex) break;
                if (this.orderTable[index] == -1) {
                    this.orderTable[index] = glyphIndex;
                    break;
                }
                ++index;
            }
            glyphCodes[i] = index;
            ++i;
        }
        return glyphCodes;
    }

    private int[] advancesForGlyphIndices(int[] glyphCodes, float scaleFactor) {
        int[] glyphAdvances = new int[glyphCodes.length];
        int i = 0;
        while (i < glyphCodes.length) {
            short index = this.orderTable[glyphCodes[i]];
            glyphAdvances[i] = (int)((float)this.glyphTable[index].advance * scaleFactor);
            ++i;
        }
        return glyphAdvances;
    }

    private int scaleBaseline(float scaleFactor) {
        int newBaseline = (int)((float)this.baseline * scaleFactor);
        newBaseline += 20 - newBaseline % 20;
        return newBaseline;
    }

    private byte[] dataFromFile(String filename) throws FileNotFoundException, IOException {
        File aFile = new File(filename);
        FileInputStream imageContents = null;
        byte[] bytes = new byte[(int)aFile.length()];
        imageContents = new FileInputStream(aFile);
        imageContents.read(bytes);
        imageContents.close();
        return bytes;
    }

    private void decodeOpenTypeFont(String fontName) throws IOException, DataFormatException {
        FSCoder coder = new FSCoder(1, this.dataFromFile(fontName));
        float version = coder.readFixedBits(32, 16);
        int tableCount = coder.readWord(2, false);
        int searchRange = coder.readWord(2, false);
        int entrySelector = coder.readWord(2, false);
        int rangeShift = coder.readWord(2, false);
        int os_2Offset = 0;
        int headOffset = 0;
        int hheaOffset = 0;
        int maxpOffset = 0;
        int locaOffset = 0;
        int cmapOffset = 0;
        int glyfOffset = 0;
        int hmtxOffset = 0;
        int nameOffset = 0;
        int os_2Length = 0;
        int headLength = 0;
        int hheaLength = 0;
        int maxpLength = 0;
        int locaLength = 0;
        int cmapLength = 0;
        int hmtxLength = 0;
        int nameLength = 0;
        int glyfLength = 0;
        int chunkType = 0;
        int checksum = 0;
        int offset = 0;
        int length = 0;
        int i = 0;
        while (i < tableCount) {
            chunkType = coder.readWord(4, false);
            checksum = coder.readWord(4, false);
            offset = coder.readWord(4, false) << 3;
            length = coder.readWord(4, false);
            switch (chunkType) {
                case 1330851634: {
                    os_2Offset = offset;
                    os_2Length = length;
                    break;
                }
                case 1668112752: {
                    cmapOffset = offset;
                    cmapLength = length;
                    break;
                }
                case 1735162214: {
                    glyfOffset = offset;
                    glyfLength = length;
                    break;
                }
                case 1751474532: {
                    headOffset = offset;
                    headLength = length;
                    break;
                }
                case 1751672161: {
                    hheaOffset = offset;
                    hheaLength = length;
                    break;
                }
                case 1752003704: {
                    hmtxOffset = offset;
                    hmtxLength = length;
                    break;
                }
                case 1819239265: {
                    locaOffset = offset;
                    locaLength = length;
                    break;
                }
                case 1835104368: {
                    maxpOffset = offset;
                    maxpLength = length;
                    break;
                }
                case 1851878757: {
                    nameOffset = offset;
                    nameLength = length;
                    break;
                }
            }
            ++i;
        }
        int bytesRead = 0;
        if (maxpOffset != 0) {
            coder.setPointer(maxpOffset);
            this.decodeMAXP(coder);
            bytesRead = coder.getPointer() - maxpOffset >> 3;
        }
        if (os_2Offset != 0) {
            coder.setPointer(os_2Offset);
            this.decodeOS_2(coder);
            bytesRead = coder.getPointer() - os_2Offset >> 3;
        }
        if (headOffset != 0) {
            coder.setPointer(headOffset);
            this.decodeHEAD(coder);
            bytesRead = coder.getPointer() - headOffset >> 3;
        }
        if (hheaOffset != 0) {
            coder.setPointer(hheaOffset);
            this.decodeHHEA(coder);
            bytesRead = coder.getPointer() - hheaOffset >> 3;
        }
        if (nameOffset != 0) {
            coder.setPointer(nameOffset);
            this.decodeNAME(coder);
            bytesRead = coder.getPointer() - nameOffset >> 3;
        }
        this.glyphTable = new FSGlyph[this.numberOfGlyphs];
        if (locaOffset != 0) {
            coder.setPointer(locaOffset);
            this.decodeGlyphs(coder, glyfOffset);
            bytesRead = coder.getPointer() - locaOffset >> 3;
        }
        if (hmtxOffset != 0) {
            coder.setPointer(hmtxOffset);
            this.decodeHMTX(coder);
            bytesRead = coder.getPointer() - hmtxOffset >> 3;
        }
        if (cmapOffset != 0) {
            coder.setPointer(cmapOffset);
            this.decodeCMAP(coder);
            bytesRead = coder.getPointer() - cmapOffset >> 3;
        }
        this.orderTable[0] = this.characterTable[32];
        int i2 = 0;
        while (i2 < this.characterTable.length) {
            if (this.characterTable[i2] >= this.glyphTable.length) {
                this.characterTable[i2] = (short)this.missingGlyph;
            }
            ++i2;
        }
        short spaceIndex = this.characterTable[32];
        this.glyphTable[spaceIndex].shape = new FSShape();
        this.glyphTable[spaceIndex].advance = 250;
    }

    private void decodeHEAD(FSCoder coder) {
        byte[] date = new byte[8];
        coder.readFixedBits(32, 16);
        coder.readFixedBits(32, 16);
        coder.readWord(4, false);
        coder.readWord(4, false);
        coder.readBits(1, false);
        coder.readBits(1, false);
        coder.readBits(1, false);
        coder.readBits(1, false);
        coder.readBits(1, false);
        coder.readBits(11, false);
        this.attributes[1] = coder.readWord(2, false) / 1024;
        if (this.attributes[1] == 0) {
            this.attributes[1] = 1;
        }
        coder.readBytes(date);
        coder.readBytes(date);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        this.isBold = coder.readBits(1, false) != 0;
        this.isItalic = coder.readBits(1, false) != 0;
        coder.readBits(14, false);
        coder.readWord(2, false);
        coder.readWord(2, true);
        this.attributes[2] = coder.readWord(2, true);
        coder.readWord(2, true);
    }

    private void decodeHHEA(FSCoder coder) {
        coder.readFixedBits(32, 16);
        this.ascent = coder.readWord(2, true);
        this.descent = coder.readWord(2, true);
        this.leading = coder.readWord(2, true);
        coder.readWord(2, false);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, false);
        coder.readWord(2, false);
        coder.readWord(2, false);
        coder.readWord(2, false);
        coder.readWord(2, true);
        this.attributes[0] = coder.readWord(2, false);
    }

    private void decodeOS_2(FSCoder coder) {
        byte[] panose = new byte[10];
        int[] unicodeRange = new int[4];
        byte[] vendor = new byte[4];
        int version = coder.readWord(2, false);
        coder.readWord(2, true);
        switch (coder.readWord(2, false)) {
            case 700: {
                this.isBold = true;
                break;
            }
        }
        coder.readWord(2, false);
        coder.readWord(2, false);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readWord(2, true);
        coder.readBytes(panose);
        int i = 0;
        while (i < 4) {
            unicodeRange[i] = coder.readWord(4, false);
            ++i;
        }
        coder.readBytes(vendor);
        this.isItalic = coder.readBits(1, false) != 0;
        coder.readBits(4, false);
        this.isBold = coder.readBits(1, false) != 0;
        coder.readBits(10, false);
        coder.readWord(2, false);
        coder.readWord(2, false);
        this.ascent = coder.readWord(2, false);
        this.descent = coder.readWord(2, false);
        this.leading = coder.readWord(2, false);
        coder.readWord(2, false);
        coder.readWord(2, false);
        if (version > 0) {
            coder.readWord(4, false);
            coder.readWord(4, false);
            if (version > 1) {
                coder.readWord(2, true);
                coder.readWord(2, true);
                this.missingGlyph = coder.readWord(2, false);
                coder.readWord(2, false);
                coder.readWord(2, false);
            }
        }
    }

    private void decodeNAME(FSCoder coder) {
        int stringTableBase = coder.getPointer() >>> 3;
        int format = coder.readWord(2, false);
        int numberOfNameRecords = coder.readWord(2, false);
        int stringTable = coder.readWord(2, false) + stringTableBase;
        int i = 0;
        while (i < numberOfNameRecords) {
            int platformId = coder.readWord(2, false);
            int encodingId = coder.readWord(2, false);
            int languageId = coder.readWord(2, false);
            int nameId = coder.readWord(2, false);
            int stringLength = coder.readWord(2, false);
            int stringOffset = coder.readWord(2, false);
            int current = coder.getPointer();
            coder.setPointer(stringTable + stringOffset << 3);
            byte[] b = new byte[stringLength];
            coder.readBytes(b);
            String nameEncoding = "UTF-8";
            if (platformId == 0) {
                nameEncoding = "UTF-16";
            } else if (platformId == 1) {
                if (encodingId == 0 && languageId == 0) {
                    nameEncoding = "ISO8859-1";
                }
            } else if (platformId == 3) {
                switch (encodingId) {
                    case 1: {
                        nameEncoding = "UTF-16";
                        break;
                    }
                    case 2: {
                        nameEncoding = "SJIS";
                        break;
                    }
                    case 4: {
                        nameEncoding = "Big5";
                    }
                }
            }
            try {
                if (nameId == 1) {
                    this.name = new String(b, nameEncoding);
                }
            }
            catch (UnsupportedEncodingException e) {
                this.name = new String(b);
            }
            coder.setPointer(current);
            ++i;
        }
    }

    private void decodeMAXP(FSCoder coder) {
        float version = coder.readFixedBits(32, 16);
        this.numberOfGlyphs = coder.readWord(2, false);
        if ((double)version == 1.0) {
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
            coder.readWord(2, false);
        }
    }

    private void decodeHMTX(FSCoder coder) {
        int i = 0;
        i = 0;
        while (i < this.attributes[0]) {
            this.glyphTable[i].advance = coder.readWord(2, false) / this.attributes[1];
            coder.readWord(2, true);
            ++i;
        }
        int advance = this.glyphTable[i - 1].advance;
        while (i < this.numberOfGlyphs) {
            this.glyphTable[i].advance = advance;
            ++i;
        }
        while (i < this.numberOfGlyphs) {
            coder.readWord(2, true);
            ++i;
        }
    }

    private void decodeCMAP(FSCoder coder) {
        int tableStart = coder.getPointer();
        int version = coder.readWord(2, false);
        int numberOfTables = coder.readWord(2, false);
        int platformId = 0;
        int encodingId = 0;
        int offset = 0;
        int current = 0;
        int format = 0;
        int length = 0;
        int language = 0;
        int segmentCount = 0;
        int[] startCount = null;
        int[] endCount = null;
        int[] delta = null;
        int[] range = null;
        int[] rangeAdr = null;
        int i = 0;
        int n = 0;
        i = 0;
        while (i < numberOfTables) {
            platformId = coder.readWord(2, false);
            encodingId = coder.readWord(2, false);
            offset = coder.readWord(4, false) << 3;
            current = coder.getPointer();
            if (platformId == 0) {
                this.encoding = 0;
            } else if (platformId == 1) {
                switch (encodingId) {
                    case 1: {
                        this.encoding = 2;
                        break;
                    }
                    default: {
                        this.encoding = 1;
                        break;
                    }
                }
            } else if (platformId == 3) {
                switch (encodingId) {
                    case 1: {
                        this.encoding = 0;
                        break;
                    }
                    case 2: {
                        this.encoding = 2;
                        break;
                    }
                    default: {
                        this.encoding = 1;
                    }
                }
            }
            coder.setPointer(tableStart + offset);
            format = coder.readWord(2, false);
            length = coder.readWord(2, false);
            language = coder.readWord(2, false);
            switch (format) {
                case 0: {
                    n = 0;
                    while (n < 256) {
                        this.characterTable[n] = (short)coder.readWord(1, false);
                        ++n;
                    }
                    break;
                }
                case 4: {
                    segmentCount = coder.readWord(2, false) / 2;
                    coder.readWord(2, false);
                    coder.readWord(2, false);
                    coder.readWord(2, false);
                    startCount = new int[segmentCount];
                    endCount = new int[segmentCount];
                    delta = new int[segmentCount];
                    range = new int[segmentCount];
                    rangeAdr = new int[segmentCount];
                    n = 0;
                    while (n < segmentCount) {
                        endCount[n] = coder.readWord(2, false);
                        ++n;
                    }
                    coder.readWord(2, false);
                    n = 0;
                    while (n < segmentCount) {
                        startCount[n] = coder.readWord(2, false);
                        ++n;
                    }
                    n = 0;
                    while (n < segmentCount) {
                        delta[n] = coder.readWord(2, true);
                        ++n;
                    }
                    n = 0;
                    while (n < segmentCount) {
                        rangeAdr[n] = coder.getPointer() >> 3;
                        range[n] = coder.readWord(2, true);
                        ++n;
                    }
                    int glyphIndex = 0;
                    int location = 0;
                    n = 0;
                    while (n < segmentCount) {
                        int code = startCount[n];
                        while (code <= endCount[n]) {
                            if (range[n] != 0) {
                                location = rangeAdr[n] + range[n] + (code - startCount[n] << 1);
                                coder.setPointer(location << 3);
                                glyphIndex = coder.readWord(2, false);
                                if (glyphIndex != 0) {
                                    glyphIndex = (glyphIndex + delta[n]) % 65536;
                                }
                            } else {
                                glyphIndex = (delta[n] + code) % 65536;
                            }
                            this.characterTable[code] = (short)glyphIndex;
                            ++code;
                        }
                        ++n;
                    }
                    break;
                }
                case 2: 
                case 6: {
                    System.err.println("Unimplemented encoding table format: " + format);
                    break;
                }
                default: {
                    System.err.println("Illegal value for encoding table format: " + format);
                }
            }
            coder.setPointer(current);
            ++i;
        }
        this.encoding = 2;
    }

    private void decodeGlyphs(FSCoder coder, int glyfOffset) {
        int numberOfContours = 0;
        boolean glyphStart = false;
        int start = coder.getPointer();
        int end = 0;
        int[] offsets = new int[this.numberOfGlyphs];
        offsets[0] = this.attributes[2] == 0 ? glyfOffset + (coder.readWord(2, false) * 2 << 3) : glyfOffset + (coder.readWord(4, false) << 3);
        int i = 1;
        while (i < this.numberOfGlyphs) {
            offsets[i] = this.attributes[2] == 0 ? glyfOffset + (coder.readWord(2, false) * 2 << 3) : glyfOffset + (coder.readWord(4, false) << 3);
            if (offsets[i] == offsets[i - 1]) {
                offsets[i - 1] = 0;
            }
            ++i;
        }
        end = coder.getPointer();
        i = 0;
        while (i < this.numberOfGlyphs) {
            if (offsets[i] == 0) {
                this.glyphTable[i] = new FSGlyph(new FSShape(), new FSBounds(0, 0, 0, 0));
            } else {
                coder.setPointer(offsets[i]);
                numberOfContours = coder.readWord(2, true);
                if (numberOfContours >= 0) {
                    this.decodeSimpleGlyph(coder, i, numberOfContours);
                }
            }
            ++i;
        }
        coder.setPointer(start);
        i = 0;
        while (i < this.numberOfGlyphs) {
            if (offsets[i] != 0) {
                coder.setPointer(offsets[i]);
                if (coder.readWord(2, true) == -1) {
                    this.decodeCompositeGlyph(coder, i);
                }
            }
            ++i;
        }
        coder.setPointer(end);
    }

    private void decodeSimpleGlyph(FSCoder coder, int glyphIndex, int numberOfContours) {
        int xMin = coder.readWord(2, true) / this.attributes[1];
        int yMin = coder.readWord(2, true) / this.attributes[1];
        int xMax = coder.readWord(2, true) / this.attributes[1];
        int yMax = coder.readWord(2, true) / this.attributes[1];
        int[] endPtsOfContours = new int[numberOfContours];
        int i = 0;
        while (i < numberOfContours) {
            endPtsOfContours[i] = coder.readWord(2, false);
            ++i;
        }
        int instructionCount = coder.readWord(2, false);
        int[] instructions = new int[instructionCount];
        int i2 = 0;
        while (i2 < instructionCount) {
            instructions[i2] = coder.readWord(1, false);
            ++i2;
        }
        int numberOfPoints = numberOfContours == 0 ? 0 : endPtsOfContours[endPtsOfContours.length - 1] + 1;
        int[] flags = new int[numberOfPoints];
        int[] xCoordinates = new int[numberOfPoints];
        int[] yCoordinates = new int[numberOfPoints];
        boolean[] onCurve = new boolean[numberOfPoints];
        int repeatCount = 0;
        int repeatFlag = 0;
        int i3 = 0;
        while (i3 < numberOfPoints) {
            if (repeatCount > 0) {
                flags[i3] = repeatFlag;
                --repeatCount;
            } else {
                flags[i3] = coder.readWord(1, false);
                if ((flags[i3] & 8) > 0) {
                    repeatCount = coder.readWord(1, false);
                    repeatFlag = flags[i3];
                }
            }
            onCurve[i3] = (flags[i3] & 1) > 0;
            ++i3;
        }
        int last = 0;
        int i4 = 0;
        while (i4 < numberOfPoints) {
            last = (flags[i4] & 2) > 0 ? ((flags[i4] & 0x10) > 0 ? (xCoordinates[i4] = last + coder.readWord(1, false)) : (xCoordinates[i4] = last - coder.readWord(1, false))) : ((flags[i4] & 0x10) > 0 ? (xCoordinates[i4] = last) : (xCoordinates[i4] = last + coder.readWord(2, true)));
            ++i4;
        }
        last = 0;
        i4 = 0;
        while (i4 < numberOfPoints) {
            last = (flags[i4] & 4) > 0 ? ((flags[i4] & 0x20) > 0 ? (yCoordinates[i4] = last + coder.readWord(1, false)) : (yCoordinates[i4] = last - coder.readWord(1, false))) : ((flags[i4] & 0x20) > 0 ? (yCoordinates[i4] = last) : (yCoordinates[i4] = last + coder.readWord(2, true)));
            ++i4;
        }
        FSShapeConstructor path = new FSShapeConstructor();
        boolean contourStart = true;
        boolean offPoint = false;
        int contour = 0;
        int x = 0;
        int y = 0;
        int prevX = 0;
        int prevY = 0;
        int initX = 0;
        int initY = 0;
        int i5 = 0;
        while (i5 < numberOfPoints) {
            x = xCoordinates[i5] / this.attributes[1];
            y = yCoordinates[i5] / this.attributes[1];
            if (onCurve[i5]) {
                if (contourStart) {
                    path.moveForFont(x, -y);
                    contourStart = false;
                    initX = x;
                    initY = y;
                } else if (offPoint) {
                    path.curve(prevX, -prevY, x, -y);
                    offPoint = false;
                } else {
                    path.line(x, -y);
                }
            } else {
                if (offPoint) {
                    path.curve(prevX, -prevY, (x + prevX) / 2, -(y + prevY) / 2);
                }
                prevX = x;
                prevY = y;
                offPoint = true;
            }
            if (i5 == endPtsOfContours[contour]) {
                if (offPoint) {
                    path.curve(x, -y, initX, -initY);
                } else {
                    path.closePath();
                }
                contourStart = true;
                offPoint = false;
                prevX = 0;
                prevY = 0;
                ++contour;
            }
            ++i5;
        }
        this.glyphTable[glyphIndex] = new FSGlyph(path.shape(), new FSBounds(xMin, -yMax, xMax, -yMin));
        this.glyphTable[glyphIndex].xCoordinates = xCoordinates;
        this.glyphTable[glyphIndex].yCoordinates = yCoordinates;
        this.glyphTable[glyphIndex].onCurve = onCurve;
        this.glyphTable[glyphIndex].endPoints = endPtsOfContours;
    }

    private void decodeCompositeGlyph(FSCoder coder, int glyphIndex) {
        FSShape shape = new FSShape();
        FSCoordTransform transform = null;
        int xMin = coder.readWord(2, true);
        int yMin = coder.readWord(2, true);
        int xMax = coder.readWord(2, true);
        int yMax = coder.readWord(2, true);
        FSGlyph points = null;
        int numberOfPoints = 0;
        int[] endPtsOfContours = null;
        int[] xCoordinates = null;
        int[] yCoordinates = null;
        boolean[] onCurve = null;
        int flags = 0;
        int sourceGlyph = 0;
        int xOffset = 0;
        int yOffset = 0;
        int sourceIndex = 0;
        int destIndex = 0;
        do {
            transform = new FSCoordTransform();
            flags = coder.readWord(2, false);
            sourceGlyph = coder.readWord(2, false);
            if (sourceGlyph >= this.glyphTable.length || this.glyphTable[sourceGlyph] == null) {
                this.glyphTable[glyphIndex] = new FSGlyph();
                this.glyphTable[glyphIndex].bounds = new FSBounds(xMin, yMin, xMax, yMax);
                return;
            }
            points = this.glyphTable[sourceGlyph];
            numberOfPoints = points.xCoordinates.length;
            endPtsOfContours = new int[points.endPoints.length];
            int i = 0;
            while (i < points.endPoints.length) {
                endPtsOfContours[i] = points.endPoints[i];
                ++i;
            }
            xCoordinates = new int[numberOfPoints];
            i = 0;
            while (i < numberOfPoints) {
                xCoordinates[i] = points.xCoordinates[i];
                ++i;
            }
            yCoordinates = new int[numberOfPoints];
            i = 0;
            while (i < numberOfPoints) {
                yCoordinates[i] = points.yCoordinates[i];
                ++i;
            }
            onCurve = new boolean[numberOfPoints];
            i = 0;
            while (i < numberOfPoints) {
                onCurve[i] = points.onCurve[i];
                ++i;
            }
            if ((flags & 1) == 0 && (flags & 2) == 0) {
                destIndex = coder.readWord(1, false);
                sourceIndex = coder.readWord(1, false);
                transform.translate(0, 0);
            } else if ((flags & 1) == 0 && (flags & 2) > 0) {
                xOffset = coder.readWord(1, false) << 24 >> 24;
                yOffset = coder.readWord(1, false) << 24 >> 24;
                transform.translate(xOffset, yOffset);
            } else if ((flags & 1) > 0 && (flags & 2) == 0) {
                destIndex = coder.readWord(2, false);
                sourceIndex = coder.readWord(2, false);
                transform.translate(0, 0);
            } else {
                xOffset = coder.readWord(2, true);
                yOffset = coder.readWord(2, true);
                transform.translate(xOffset, yOffset);
            }
            if ((flags & 8) > 0) {
                float scaleXY = coder.readFixedBits(16, 14);
                transform.scale(scaleXY, scaleXY);
            } else if ((flags & 0x40) > 0) {
                float scaleX = coder.readFixedBits(16, 14);
                float scaleY = coder.readFixedBits(16, 14);
                transform.scale(scaleX, scaleY);
            } else if ((flags & 0x80) > 0) {
                float scaleX = coder.readFixedBits(16, 14);
                float scale01 = coder.readFixedBits(16, 14);
                float scale10 = coder.readFixedBits(16, 14);
                float scaleY = coder.readFixedBits(16, 14);
                float[][] matrix = new float[][]{{scaleX, scale01, 0.0f}, {scale10, scaleY, 0.0f}, {0.0f, 0.0f, 1.0f}};
                transform.composite(new FSCoordTransform(matrix));
            }
            i = 0;
            while (i < numberOfPoints) {
                int[] xy = transform.transformPoint(xCoordinates[i], yCoordinates[i]);
                xCoordinates[i] = xy[0];
                yCoordinates[i] = xy[1];
                ++i;
            }
            FSShapeConstructor path = new FSShapeConstructor();
            boolean contourStart = true;
            boolean offPoint = false;
            int contour = 0;
            int x = 0;
            int y = 0;
            int prevX = 0;
            int prevY = 0;
            int initX = 0;
            int initY = 0;
            int i2 = 0;
            while (i2 < numberOfPoints) {
                x = xCoordinates[i2] / this.attributes[1];
                y = yCoordinates[i2] / this.attributes[1];
                if (onCurve[i2]) {
                    if (contourStart) {
                        path.moveForFont(x, -y);
                        contourStart = false;
                        initX = x;
                        initY = y;
                    } else if (offPoint) {
                        path.curve(prevX, -prevY, x, -y);
                        offPoint = false;
                    } else {
                        path.line(x, -y);
                    }
                } else {
                    if (offPoint) {
                        path.curve(prevX, -prevY, (x + prevX) / 2, -(y + prevY) / 2);
                    }
                    prevX = x;
                    prevY = y;
                    offPoint = true;
                }
                if (i2 == endPtsOfContours[contour]) {
                    if (offPoint) {
                        path.curve(x, -y, initX, -initY);
                    } else {
                        path.closePath();
                    }
                    contourStart = true;
                    offPoint = false;
                    prevX = 0;
                    prevY = 0;
                    ++contour;
                }
                ++i2;
            }
            shape.getObjects().addAll(path.shape().getObjects());
        } while ((flags & 0x10) > 0);
        this.glyphTable[glyphIndex] = new FSGlyph(shape, new FSBounds(xMin, yMin, xMax, yMax));
        this.glyphTable[glyphIndex].xCoordinates = xCoordinates;
        this.glyphTable[glyphIndex].yCoordinates = yCoordinates;
        this.glyphTable[glyphIndex].onCurve = onCurve;
        this.glyphTable[glyphIndex].endPoints = endPtsOfContours;
    }

    private class FSGlyph {
        FSShape shape = null;
        FSBounds bounds = new FSBounds(0, 0, 0, 0);
        int advance = 0;
        int[] xCoordinates = null;
        int[] yCoordinates = null;
        boolean[] onCurve = null;
        int[] endPoints = null;

        FSGlyph() {
            this.shape = new FSShape();
            this.bounds = new FSBounds(0, 0, 0, 0);
            this.advance = 0;
            this.xCoordinates = new int[0];
            this.yCoordinates = new int[0];
            this.onCurve = new boolean[0];
            this.endPoints = new int[0];
        }

        FSGlyph(FSShape aShape, FSBounds aBounds) {
            this.shape = aShape;
            this.bounds = aBounds;
            this.advance = 0;
            this.xCoordinates = new int[0];
            this.yCoordinates = new int[0];
            this.onCurve = new boolean[0];
            this.endPoints = new int[0];
        }
    }
}

