/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.dao;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.lamsfoundation.lams.AbstractLamsTestCase;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.SimpleCredentials;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.RepositoryProxy;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.dao.IWorkspaceFolderDAO;
import org.lamsfoundation.lams.workspace.WorkspaceFolderContent;
import org.lamsfoundation.lams.workspace.dao.IWorkspaceFolderContentDAO;

public class TestWorkspaceFolderContentDAO
extends AbstractLamsTestCase {
    protected IWorkspaceFolderContentDAO workspaceFolderContentDAO;
    protected IWorkspaceFolderDAO workspaceFolderDAO;
    protected WorkspaceFolder workspaceFolder;
    protected IRepositoryService repositoryService;
    protected String workspaceUser = "workspaceManager";
    protected String password = "flashClient";
    protected String workspaceName = "FlashClientsWorkspace";
    protected ICredentials credentials;
    protected ITicket ticket;

    public TestWorkspaceFolderContentDAO(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.workspaceFolderContentDAO = (IWorkspaceFolderContentDAO)this.context.getBean("workspaceFolderContentDAO");
        this.workspaceFolderDAO = (IWorkspaceFolderDAO)this.context.getBean("workspaceFolderDAO");
        this.workspaceFolderContentDAO = (IWorkspaceFolderContentDAO)this.context.getBean("workspaceFolderContentDAO");
        this.repositoryService = RepositoryProxy.getLocalRepositoryService();
    }

    protected String[] getContextConfigLocation() {
        return new String[]{"org/lamsfoundation/lams/contentrepository/localApplicationContext.xml", "org/lamsfoundation/lams/applicationContext.xml", "org/lamsfoundation/lams/authoring/authoringApplicationContext.xml", "org/lamsfoundation/lams/workspace/workspaceApplicationContext.xml"};
    }

    protected String getHibernateSessionFactoryName() {
        return "coreSessionFactory";
    }

    public void testInsertWorkspaceFolderContent() {
        this.workspaceFolder = this.workspaceFolderDAO.getWorkspaceFolderByID(new Integer(4));
        WorkspaceFolderContent workspaceFolderContent = new WorkspaceFolderContent(new Integer(1), "Test File", "Test Description", new Date(), new Date(), "TXT", this.workspaceFolder);
        this.workspaceFolderContentDAO.insert(workspaceFolderContent);
        TestWorkspaceFolderContentDAO.assertNotNull((Object)workspaceFolderContent.getFolderContentID());
    }

    public void testGetContentByWorkspaceFolder() {
        List list = this.workspaceFolderContentDAO.getContentByWorkspaceFolder(new Long(3L));
        TestWorkspaceFolderContentDAO.assertEquals((int)list.size(), (int)4);
    }

    public void testGetContentByTypeFromWorkspaceFolder() {
        List list = this.workspaceFolderContentDAO.getContentByTypeFromWorkspaceFolder(new Long(3L), "TXT");
        TestWorkspaceFolderContentDAO.assertEquals((int)list.size(), (int)2);
    }

    public void testAddFlashClientWorkspaceCredentials() throws Exception {
        this.credentials = new SimpleCredentials(this.workspaceUser, this.password.toCharArray());
        this.ticket = this.repositoryService.login(this.credentials, this.workspaceName);
        TestWorkspaceFolderContentDAO.assertNotNull((String)("Add workspace succeeded - can login to workspace. Ticket is " + this.ticket), (Object)this.ticket);
        this.testAddFile(this.ticket);
    }

    private void testAddFile(ITicket iTicket) throws Exception {
        WorkspaceFolderContent workspaceFolderContent = this.workspaceFolderContentDAO.getWorkspaceFolderContentByID(new Long(7L));
        FileInputStream fileInputStream = new FileInputStream("C:/test/Text File.txt");
        NodeKey nodeKey = this.repositoryService.addFileItem(iTicket, (InputStream)fileInputStream, workspaceFolderContent.getName(), workspaceFolderContent.getMimeType(), null);
        workspaceFolderContent.setUuid(nodeKey.getUuid());
        workspaceFolderContent.setVersionID(nodeKey.getVersion());
        this.workspaceFolderContentDAO.update(workspaceFolderContent);
        TestWorkspaceFolderContentDAO.assertNotNull((Object)workspaceFolderContent.getUuid());
    }

    public void testUpdateFile() throws Exception {
        WorkspaceFolderContent workspaceFolderContent = this.workspaceFolderContentDAO.getWorkspaceFolderContentByID(new Long(7L));
        FileInputStream fileInputStream = new FileInputStream("C:/test/Text File.txt");
        this.credentials = new SimpleCredentials(this.workspaceUser, this.password.toCharArray());
        this.ticket = this.repositoryService.login(this.credentials, this.workspaceName);
        NodeKey nodeKey = this.repositoryService.updateFileItem(this.ticket, workspaceFolderContent.getUuid(), workspaceFolderContent.getName(), (InputStream)fileInputStream, workspaceFolderContent.getMimeType(), null);
        workspaceFolderContent.setVersionID(nodeKey.getVersion());
        workspaceFolderContent.setUuid(nodeKey.getUuid());
        this.workspaceFolderContentDAO.update(workspaceFolderContent);
        System.out.println(nodeKey.getVersion() + ": " + workspaceFolderContent.getVersionID());
    }
}

