/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.sbmt.InstructionFiles;
import org.lamsfoundation.lams.tool.sbmt.SubmitUser;

public class SubmitFilesContent
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9072799761861936838L;
    private static Logger log = Logger.getLogger(SubmitFilesContent.class);
    private Long contentID;
    private String title;
    private String instruction;
    private boolean lockOnFinished;
    private String offlineInstruction;
    private String onlineInstruction;
    private Set instructionFiles;
    private boolean defineLater;
    private boolean runOffline;
    private boolean contentInUse;
    private boolean limitUpload;
    private int limitUploadNumber;
    private boolean reflectOnActivity;
    private String reflectInstructions;
    private Date created;
    private Date updated;
    private SubmitUser createdBy;
    private IToolContentHandler toolContentHandler;

    public static SubmitFilesContent newInstance(SubmitFilesContent content, Long newContentID, IToolContentHandler toolContentHandler) {
        content.toolContentHandler = toolContentHandler;
        SubmitFilesContent newContent = (SubmitFilesContent)content.clone();
        newContent.setContentID(newContentID);
        return newContent;
    }

    public Long getContentID() {
        return this.contentID;
    }

    public void setContentID(Long contentID) {
        this.contentID = contentID;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instructions) {
        this.instruction = instructions;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("contentID", (Object)this.getContentID()).append("title", (Object)this.getTitle()).append("instructions", (Object)this.getInstruction()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SubmitFilesContent)) {
            return false;
        }
        SubmitFilesContent castOther = (SubmitFilesContent)other;
        return new EqualsBuilder().append((Object)this.getContentID(), (Object)castOther.getContentID()).append((Object)this.getTitle(), (Object)castOther.getTitle()).append((Object)this.getInstruction(), (Object)castOther.getInstruction()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getContentID()).append((Object)this.getTitle()).append((Object)this.getInstruction()).toHashCode();
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public boolean isRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(boolean runOffline) {
        this.runOffline = runOffline;
    }

    public String getOfflineInstruction() {
        return this.offlineInstruction;
    }

    public void setOfflineInstruction(String offlineInstruction) {
        this.offlineInstruction = offlineInstruction;
    }

    public String getOnlineInstruction() {
        return this.onlineInstruction;
    }

    public void setOnlineInstruction(String onlineInstruction) {
        this.onlineInstruction = onlineInstruction;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public Set getInstructionFiles() {
        return this.instructionFiles;
    }

    public void setInstructionFiles(Set instructionFiles) {
        this.instructionFiles = instructionFiles;
    }

    public boolean isLockOnFinished() {
        return this.lockOnFinished;
    }

    public void setLockOnFinished(boolean lockOnFinished) {
        this.lockOnFinished = lockOnFinished;
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
            ((SubmitFilesContent)obj).setContentID(null);
            if (this.instructionFiles != null) {
                Iterator iter = this.instructionFiles.iterator();
                HashSet<InstructionFiles> set = new HashSet<InstructionFiles>();
                while (iter.hasNext()) {
                    InstructionFiles file = (InstructionFiles)iter.next();
                    InstructionFiles newFile = (InstructionFiles)file.clone();
                    set.add(newFile);
                }
                ((SubmitFilesContent)obj).instructionFiles = set;
                if (this.createdBy != null) {
                    ((SubmitFilesContent)obj).setCreatedBy((SubmitUser)this.createdBy.clone());
                }
            }
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + SubmitFilesContent.class + " failed"));
        }
        return obj;
    }

    public IToolContentHandler getToolContentHandler() {
        return this.toolContentHandler;
    }

    public void setToolContentHandler(IToolContentHandler toolContentHandler) {
        this.toolContentHandler = toolContentHandler;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public boolean isLimitUpload() {
        return this.limitUpload;
    }

    public void setLimitUpload(boolean limitUpload) {
        this.limitUpload = limitUpload;
    }

    public int getLimitUploadNumber() {
        return this.limitUploadNumber;
    }

    public void setLimitUploadNumber(int limitUploadNumber) {
        this.limitUploadNumber = limitUploadNumber;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public SubmitUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(SubmitUser createdBy) {
        this.createdBy = createdBy;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }
}

