/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.dao;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;
import org.lamsfoundation.lams.tool.sbmt.SubmissionDetails;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesContent;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesReport;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesSession;

public class TestModel
extends TestCase {
    private static String commA = "commA";
    private static Float markA = new Float(100.0f);
    private static Long repA = new Long(100L);
    private static int dayA = 10;
    private static int mthA = 9;
    private static int yearA = 2003;
    private static String commB = "commB";
    private static Float markB = new Float(201.0f);
    private static Long repB = new Long(201L);
    private static int dayB = 11;
    private static int mthB = 8;
    private static int yearB = 2004;
    private static String insA = "InstructionsA";
    private static String insB = "InstructionsB";
    private static String titA = "titleA";
    private static String titB = "titleB";
    private static boolean deA = false;
    private static boolean deB = true;
    private static boolean offA = false;
    private static boolean offB = false;
    private static Long sessA = new Long(100L);
    private static Integer statA = new Integer(100);
    private static Long sessB = new Long(200L);
    private static Integer statB = new Integer(200);
    private String filePathA = "fpA";
    private String filePathB = "fpB";
    private SubmitFilesContent content;
    private SubmitFilesReport report;
    private SubmitFilesSession session;
    private SubmissionDetails detail;

    protected void setUp() throws Exception {
        this.content = new SubmitFilesContent();
        this.content.setContentID(new Long(1L));
        this.session = new SubmitFilesSession();
        this.detail = new SubmissionDetails();
        this.report = new SubmitFilesReport();
    }

    public void testReportClone() {
        this.fillReportA(this.report);
        SubmitFilesReport submitFilesReport = (SubmitFilesReport)this.report.clone();
        this.fillReportB(this.report);
        TestModel.assertEquals((String)submitFilesReport.getComments(), (String)commA);
        Calendar calendar = Calendar.getInstance();
        calendar.set(yearA, mthA, dayA);
        TestModel.assertEquals((Object)submitFilesReport.getDateMarksReleased(), (Object)calendar.getTime());
        TestModel.assertEquals((Object)submitFilesReport.getMarks(), (Object)markA);
        TestModel.assertEquals((Object)submitFilesReport.getReportID(), (Object)repA);
    }

    public void testSessionClone() {
        this.fillSessionA(this.session);
        SubmitFilesSession submitFilesSession = (SubmitFilesSession)this.session.clone();
        this.fillSessionB(this.session);
        TestModel.assertEquals((Object)submitFilesSession.getSessionID(), (Object)sessA);
        TestModel.assertEquals((Object)submitFilesSession.getStatus(), (Object)statA);
        Iterator iterator = submitFilesSession.getSubmissionDetails().iterator();
        SubmissionDetails submissionDetails = new SubmissionDetails();
        this.fillDetailA(submissionDetails);
        TestModel.assertEquals(iterator.next(), (Object)submissionDetails);
        iterator = this.session.getSubmissionDetails().iterator();
        submissionDetails = new SubmissionDetails();
        this.fillDetailB(submissionDetails);
        TestModel.assertEquals(iterator.next(), (Object)submissionDetails);
    }

    public void testDetailClone() {
        this.fillDetailA(this.detail);
        SubmissionDetails submissionDetails = (SubmissionDetails)this.detail.clone();
        this.fillDetailB(this.detail);
        TestModel.assertEquals((String)submissionDetails.getFilePath(), (String)this.filePathA);
        SubmitFilesReport submitFilesReport = new SubmitFilesReport();
        this.fillReportA(submitFilesReport);
        TestModel.assertEquals((Object)submissionDetails.getReport(), (Object)submitFilesReport);
    }

    public void testContentClone() {
        this.fillContentA(this.content);
        SubmitFilesContent submitFilesContent = (SubmitFilesContent)this.content.clone();
        this.fillContentB(this.content);
        TestModel.assertEquals((String)submitFilesContent.getInstruction(), (String)insA);
        TestModel.assertEquals((String)submitFilesContent.getTitle(), (String)titA);
        TestModel.assertEquals((boolean)submitFilesContent.isDefineLater(), (boolean)deA);
        TestModel.assertEquals((boolean)submitFilesContent.isRunOffline(), (boolean)offA);
        TestModel.assertEquals((String)this.content.getInstruction(), (String)insB);
        TestModel.assertEquals((String)this.content.getTitle(), (String)titB);
        TestModel.assertEquals((boolean)this.content.isDefineLater(), (boolean)deB);
        TestModel.assertEquals((boolean)this.content.isRunOffline(), (boolean)offB);
    }

    private void fillReportA(SubmitFilesReport submitFilesReport) {
        submitFilesReport.setComments(commA);
        Calendar calendar = Calendar.getInstance();
        calendar.set(yearA, mthA, dayA);
        submitFilesReport.setDateMarksReleased(calendar.getTime());
        submitFilesReport.setMarks(markA);
        submitFilesReport.setReportID(repA);
    }

    private void fillReportB(SubmitFilesReport submitFilesReport) {
        submitFilesReport.setComments(commB);
        Calendar calendar = Calendar.getInstance();
        calendar.set(yearB, mthB, dayB);
        submitFilesReport.setDateMarksReleased(calendar.getTime());
        submitFilesReport.setMarks(markB);
        submitFilesReport.setReportID(repB);
    }

    private void fillContentA(SubmitFilesContent submitFilesContent) {
        submitFilesContent.setDefineLater(deA);
        submitFilesContent.setInstruction(insA);
        submitFilesContent.setRunOffline(offA);
        submitFilesContent.setTitle(titA);
        SubmitFilesSession submitFilesSession = new SubmitFilesSession();
        this.fillSessionA(submitFilesSession);
        HashSet<SubmitFilesSession> hashSet = new HashSet<SubmitFilesSession>();
        hashSet.add(submitFilesSession);
    }

    private void fillContentB(SubmitFilesContent submitFilesContent) {
        submitFilesContent.setDefineLater(deB);
        submitFilesContent.setInstruction(insB);
        submitFilesContent.setRunOffline(offB);
        submitFilesContent.setTitle(titB);
        SubmitFilesSession submitFilesSession = new SubmitFilesSession();
        this.fillSessionB(submitFilesSession);
        HashSet<SubmitFilesSession> hashSet = new HashSet<SubmitFilesSession>();
        hashSet.add(submitFilesSession);
    }

    private void fillSessionA(SubmitFilesSession submitFilesSession) {
        submitFilesSession.setSessionID(sessA);
        submitFilesSession.setStatus(statA);
        SubmissionDetails submissionDetails = new SubmissionDetails();
        this.fillDetailA(submissionDetails);
        HashSet<SubmissionDetails> hashSet = new HashSet<SubmissionDetails>();
        hashSet.add(submissionDetails);
        submitFilesSession.setSubmissionDetails(hashSet);
    }

    private void fillSessionB(SubmitFilesSession submitFilesSession) {
        submitFilesSession.setSessionID(sessB);
        submitFilesSession.setStatus(statB);
        SubmissionDetails submissionDetails = new SubmissionDetails();
        this.fillDetailB(submissionDetails);
        HashSet<SubmissionDetails> hashSet = new HashSet<SubmissionDetails>();
        hashSet.add(submissionDetails);
        submitFilesSession.setSubmissionDetails(hashSet);
    }

    private void fillDetailA(SubmissionDetails submissionDetails) {
        submissionDetails.setFilePath(this.filePathA);
        SubmitFilesReport submitFilesReport = new SubmitFilesReport();
        this.fillReportA(submitFilesReport);
        submissionDetails.setReport(submitFilesReport);
    }

    private void fillDetailB(SubmissionDetails submissionDetails) {
        submissionDetails.setFilePath(this.filePathB);
        SubmitFilesReport submitFilesReport = new SubmitFilesReport();
        this.fillReportB(submitFilesReport);
        submissionDetails.setReport(submitFilesReport);
    }
}

