/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.tool.sbmt.SubmissionDetails;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesSession;
import org.lamsfoundation.lams.tool.sbmt.dao.ISubmissionDetailsDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmissionDetailsDAO
extends BaseDAO
implements ISubmissionDetailsDAO {
    private static final String FIND_BY_SESSION = "from " + SubmissionDetails.class.getName() + " as d where d.submitFileSession.sessionID=? ";
    private static final String FIND_BY_SESSION_LEARNER = "from " + SubmissionDetails.class.getName() + " as d where d.submitFileSession.sessionID=? and d.learner.userID=?";

    @Override
    public SubmissionDetails getSubmissionDetailsByID(Long submissionID) {
        return (SubmissionDetails)this.getHibernateTemplate().get(SubmissionDetails.class, (Serializable)submissionID);
    }

    @Override
    public void saveOrUpdate(SubmitFilesSession session) {
        this.getHibernateTemplate().saveOrUpdate((Object)session);
    }

    @Override
    public List getSubmissionDetailsBySession(Long sessionID) {
        if (sessionID != null) {
            return this.getSession().createQuery(FIND_BY_SESSION).setLong(0, sessionID.longValue()).list();
        }
        return null;
    }

    @Override
    public List<SubmissionDetails> getBySessionAndLearner(Long sessionID, Integer userID) {
        return this.getHibernateTemplate().find(FIND_BY_SESSION_LEARNER, new Object[]{sessionID, userID});
    }
}

