/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.dto;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.tool.sbmt.InstructionFiles;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesContent;
import org.lamsfoundation.lams.tool.sbmt.dto.DTOException;

public class AuthoringDTO
implements Serializable {
    private static final long serialVersionUID = 3555065437595921234L;
    private Long contentID;
    private String title;
    private String instruction;
    private String onlineInstruction;
    private String offlineInstruction;
    private List onlineFiles;
    private List offlineFiles;
    private boolean lockOnFinished;

    public AuthoringDTO() {
    }

    public AuthoringDTO(SubmitFilesContent content) {
        if (content == null) {
            return;
        }
        try {
            PropertyUtils.copyProperties((Object)this, (Object)content);
        }
        catch (IllegalAccessException e) {
            throw new DTOException(e);
        }
        catch (InvocationTargetException e) {
            throw new DTOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new DTOException(e);
        }
        this.onlineFiles = new ArrayList();
        this.offlineFiles = new ArrayList();
        Set fileSet = content.getInstructionFiles();
        if (fileSet != null) {
            for (InstructionFiles file : fileSet) {
                if (StringUtils.equalsIgnoreCase((String)file.getType(), (String)"OFFLINE")) {
                    this.offlineFiles.add(file);
                    continue;
                }
                this.onlineFiles.add(file);
            }
        }
    }

    public Long getContentID() {
        return this.contentID;
    }

    public void setContentID(Long contentID) {
        this.contentID = contentID;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public boolean isLockOnFinished() {
        return this.lockOnFinished;
    }

    public void setLockOnFinished(boolean lockOnFinished) {
        this.lockOnFinished = lockOnFinished;
    }

    public List getOfflineFiles() {
        return this.offlineFiles;
    }

    public void setOfflineFiles(List offlineFiles) {
        this.offlineFiles = offlineFiles;
    }

    public String getOfflineInstruction() {
        return this.offlineInstruction;
    }

    public void setOfflineInstruction(String offlineInstruction) {
        this.offlineInstruction = offlineInstruction;
    }

    public List getOnlineFiles() {
        return this.onlineFiles;
    }

    public void setOnlineFiles(List onlineFiles) {
        this.onlineFiles = onlineFiles;
    }

    public String getOnlineInstruction() {
        return this.onlineInstruction;
    }

    public void setOnlineInstruction(String onlineInstruction) {
        this.onlineInstruction = onlineInstruction;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

