/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.dto;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.sbmt.SubmissionDetails;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesReport;
import org.lamsfoundation.lams.tool.sbmt.SubmitUser;
import org.lamsfoundation.lams.tool.sbmt.dto.SubmitUserDTO;
import org.lamsfoundation.lams.util.NumberUtil;

public class FileDetailsDTO
implements Serializable {
    private Logger log = Logger.getLogger(FileDetailsDTO.class);
    private static final long serialVersionUID = 2964711101016972263L;
    private Long submissionID;
    private String filePath;
    private String fileDescription;
    private SubmitUserDTO owner;
    private Long reportID;
    private String comments;
    private String marks;
    private Date dateOfSubmission;
    private Date dateMarksReleased;
    private Long uuID;
    private Long versionID;
    private boolean finished;
    private boolean currentLearner;
    private String exportedURL;

    public FileDetailsDTO(SubmissionDetails details, NumberFormat numberFormat) {
        if (details == null) {
            this.log.warn((Object)"SubmissionDetails is null, failed to initial FileDetailDTO");
            return;
        }
        SubmitUser learner = details.getLearner();
        if (learner != null) {
            this.owner = new SubmitUserDTO(learner);
        }
        this.submissionID = details.getSubmissionID();
        this.filePath = details.getFilePath();
        this.fileDescription = details.getFileDescription();
        this.dateOfSubmission = details.getDateOfSubmission();
        this.uuID = details.getUuid();
        this.versionID = details.getVersionID();
        SubmitFilesReport report = details.getReport();
        if (report != null) {
            this.reportID = report.getReportID();
            this.dateMarksReleased = report.getDateMarksReleased();
            this.comments = report.getComments();
            this.marks = report.getMarks() != null ? NumberUtil.formatLocalisedNumber((Number)report.getMarks(), (NumberFormat)numberFormat, (int)2) : "";
        }
    }

    public String getExportedURL() {
        return this.exportedURL;
    }

    public void setExportedURL(String exportedURL) {
        this.exportedURL = exportedURL;
    }

    public Long getReportID() {
        return this.reportID;
    }

    public void setReportID(Long reportID) {
        this.reportID = reportID;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getDateOfSubmission() {
        return this.dateOfSubmission;
    }

    public void setDateOfSubmission(Date dateOfSubmission) {
        this.dateOfSubmission = dateOfSubmission;
    }

    public String getFileDescription() {
        return this.fileDescription;
    }

    public void setFileDescription(String fileDescription) {
        this.fileDescription = fileDescription;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getMarks() {
        return this.marks;
    }

    public void setMarks(String marks) {
        this.marks = marks;
    }

    public Date getDateMarksReleased() {
        return this.dateMarksReleased;
    }

    public void setDateMarksReleased(Date dateMarksReleased) {
        this.dateMarksReleased = dateMarksReleased;
    }

    public Long getUuID() {
        return this.uuID;
    }

    public void setUuID(Long uuID) {
        this.uuID = uuID;
    }

    public Long getVersionID() {
        return this.versionID;
    }

    public void setVersionID(Long versionID) {
        this.versionID = versionID;
    }

    public Long getSubmissionID() {
        return this.submissionID;
    }

    public void setSubmissionID(Long submissionID) {
        this.submissionID = submissionID;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean isCurrentLearner() {
        return this.currentLearner;
    }

    public void setCurrentLearner(boolean currentLearner) {
        this.currentLearner = currentLearner;
    }

    public SubmitUserDTO getOwner() {
        return this.owner;
    }

    public void setOwner(SubmitUserDTO owner) {
        this.owner = owner;
    }
}

