/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.RepositoryProxy;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.sbmt.InstructionFiles;
import org.lamsfoundation.lams.tool.sbmt.SubmissionDetails;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesContent;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesReport;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesSession;
import org.lamsfoundation.lams.tool.sbmt.SubmitUser;
import org.lamsfoundation.lams.tool.sbmt.dao.IAttachmentDAO;
import org.lamsfoundation.lams.tool.sbmt.dao.ISubmissionDetailsDAO;
import org.lamsfoundation.lams.tool.sbmt.dao.ISubmitFilesContentDAO;
import org.lamsfoundation.lams.tool.sbmt.dao.ISubmitFilesReportDAO;
import org.lamsfoundation.lams.tool.sbmt.dao.ISubmitFilesSessionDAO;
import org.lamsfoundation.lams.tool.sbmt.dao.ISubmitUserDAO;
import org.lamsfoundation.lams.tool.sbmt.dto.FileDetailsDTO;
import org.lamsfoundation.lams.tool.sbmt.dto.SubmitUserDTO;
import org.lamsfoundation.lams.tool.sbmt.exception.SubmitFilesException;
import org.lamsfoundation.lams.tool.sbmt.service.ISubmitFilesService;
import org.lamsfoundation.lams.tool.sbmt.util.SbmtToolContentHandler;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.usermanagement.util.LastNameAlphabeticComparator;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitFilesService
implements ToolContentManager,
ToolSessionManager,
ISubmitFilesService,
ToolContentImport102Manager {
    private static Logger log = Logger.getLogger(SubmitFilesService.class);
    private ISubmitFilesContentDAO submitFilesContentDAO;
    private ISubmitFilesReportDAO submitFilesReportDAO;
    private ISubmitFilesSessionDAO submitFilesSessionDAO;
    private ISubmissionDetailsDAO submissionDetailsDAO;
    private ISubmitUserDAO submitUserDAO;
    private IAttachmentDAO attachmentDAO;
    private IToolContentHandler sbmtToolContentHandler;
    private ILamsToolService toolService;
    private ILearnerService learnerService;
    private IRepositoryService repositoryService;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;
    private IUserManagementService userManagementService;

    @Override
    public Long createNotebookEntry(Long sessionId, Integer notebookToolType, String toolSignature, Integer userId, String entryText) {
        return this.coreNotebookService.createNotebookEntry(sessionId, notebookToolType, toolSignature, userId, "", entryText);
    }

    @Override
    public NotebookEntry getEntry(Long sessionId, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(sessionId, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (toContentId == null) {
            throw new ToolException("Failed to create the SubmitFiles tool seession");
        }
        SubmitFilesContent fromContent = null;
        if (fromContentId != null) {
            fromContent = this.submitFilesContentDAO.getContentByID(fromContentId);
        }
        if (fromContent == null) {
            fromContent = this.getDefaultSubmit();
        }
        SubmitFilesContent toContent = SubmitFilesContent.newInstance(fromContent, toContentId, this.sbmtToolContentHandler);
        this.submitFilesContentDAO.saveOrUpdate(toContent);
    }

    public void setAsRunOffline(Long toolContentId, boolean value) {
        if (toolContentId == null) {
            throw new SubmitFilesException("Fail to set tool content to run offline -  based on null toolContentId");
        }
        try {
            SubmitFilesContent content = this.getSubmitFilesContent(toolContentId);
            if (content == null || !toolContentId.equals(content.getContentID())) {
                content = this.duplicateDefaultToolContent(toolContentId);
            }
            content.setRunOffline(value);
            this.submitFilesContentDAO.saveOrUpdate(content);
        }
        catch (DataAccessException e) {
            throw new SubmitFilesException("Exception occured when LAMS is setting content to run offline" + e.getMessage(), e);
        }
    }

    private SubmitFilesContent duplicateDefaultToolContent(Long toolContentId) {
        long contentId = 0L;
        contentId = this.toolService.getToolDefaultContentIdBySignature("lasbmt11");
        SubmitFilesContent content = new SubmitFilesContent();
        content.setContentID(new Long(contentId));
        return content;
    }

    public void setAsDefineLater(Long toolContentId, boolean value) {
        if (toolContentId == null) {
            throw new SubmitFilesException("Fail to set tool content to define later -  based on null toolContentId");
        }
        try {
            SubmitFilesContent content = this.getSubmitFilesContent(toolContentId);
            if (content == null || !toolContentId.equals(content.getContentID())) {
                content = this.duplicateDefaultToolContent(toolContentId);
            }
            content.setDefineLater(value);
            this.submitFilesContentDAO.saveOrUpdate(content);
        }
        catch (DataAccessException e) {
            throw new SubmitFilesException("Exception occured when LAMS is setting content to run define later" + e.getMessage(), e);
        }
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException {
        SubmitFilesContent submitFilesContent = this.submitFilesContentDAO.getContentByID(toolContentId);
        if (submitFilesContent != null) {
            List<SubmitFilesSession> submissionData = this.submitFilesSessionDAO.getSubmitFilesSessionByContentID(toolContentId);
            if (submissionData != null && !submissionData.isEmpty() && !removeSessionData) {
                throw new SessionDataExistsException("Delete failed: There is session data that belongs to this tool content id");
            }
            if (submissionData != null) {
                for (SubmitFilesSession element : submissionData) {
                    this.removeToolSession(element);
                }
            }
            this.submitFilesContentDAO.delete(submitFilesContent);
        }
    }

    @Override
    public List<SubmitFilesSession> getSessionsByContentID(Long toolContentID) {
        return this.submitFilesSessionDAO.getSubmitFilesSessionByContentID(toolContentID);
    }

    public void exportToolContent(Long toolContentId, String toPath) throws ToolException, DataMissingException {
        this.exportContentService.registerFileClassForExport(InstructionFiles.class.getName(), "uuID", "versionID");
        SubmitFilesContent toolContentObj = this.submitFilesContentDAO.getContentByID(toolContentId);
        if (toolContentObj == null) {
            toolContentObj = this.getDefaultSubmit();
        }
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to find default content for the submit files tool");
        }
        toolContentObj = SubmitFilesContent.newInstance(toolContentObj, toolContentId, null);
        toolContentObj.setToolContentHandler(null);
        try {
            this.exportContentService.exportToolContent(toolContentId, (Object)toolContentObj, this.sbmtToolContentHandler, toPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(InstructionFiles.class.getName(), "uuID", "versionID", "name", "type", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, this.sbmtToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof SubmitFilesContent)) {
                throw new ImportToolContentException("Import Submit tool content failed. Deserialized object is " + toolPOJO);
            }
            SubmitFilesContent toolContentObj = (SubmitFilesContent)toolPOJO;
            toolContentObj.setContentID(toolContentId);
            SubmitUser user = this.submitUserDAO.getContentUser(toolContentId, newUserUid);
            if (user == null) {
                user = new SubmitUser();
                UserDTO sysUser = ((User)this.userManagementService.findById(User.class, (Serializable)newUserUid)).getUserDTO();
                user.setFirstName(sysUser.getFirstName());
                user.setLastName(sysUser.getLastName());
                user.setLogin(sysUser.getLogin());
                user.setUserID(newUserUid);
                user.setContentID(toolContentId);
                this.submitUserDAO.saveOrUpdateUser(user);
            }
            toolContentObj.setCreatedBy(user);
            toolContentObj.setCreated(new Date());
            toolContentObj.setUpdated(new Date());
            this.submitFilesContentDAO.saveOrUpdate(toolContentObj);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId) throws ToolException {
        return new TreeMap<String, ToolOutputDefinition>();
    }

    @Override
    public void saveOrUpdateContent(SubmitFilesContent submitFilesContent) {
        submitFilesContent.setUpdated(new Date());
        this.submitFilesContentDAO.saveOrUpdate(submitFilesContent);
    }

    @Override
    public SubmitFilesContent getSubmitFilesContent(Long contentID) {
        SubmitFilesContent content = null;
        try {
            content = this.submitFilesContentDAO.getContentByID(contentID);
        }
        catch (Exception e) {
            log.error((Object)("Could not find the content by given ID:" + contentID + ". Excpetion is " + e));
        }
        if (content == null) {
            log.error((Object)("Could not find the content by given ID:" + contentID));
        }
        return content;
    }

    @Override
    public SubmitFilesReport getSubmitFilesReport(Long reportID) {
        return this.submitFilesReportDAO.getReportByID(reportID);
    }

    private ITicket getRepositoryLoginTicket() throws SubmitFilesException {
        this.repositoryService = RepositoryProxy.getRepositoryService();
        SimpleCredentials credentials = new SimpleCredentials(SbmtToolContentHandler.repositoryUser, SbmtToolContentHandler.repositoryId);
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, SbmtToolContentHandler.repositoryWorkspaceName);
            return ticket;
        }
        catch (AccessDeniedException ae) {
            throw new SubmitFilesException("Access Denied to repository." + ae.getMessage());
        }
        catch (WorkspaceNotFoundException we) {
            throw new SubmitFilesException("Workspace not found." + we.getMessage());
        }
        catch (LoginException e) {
            throw new SubmitFilesException("Login failed." + e.getMessage());
        }
    }

    @Override
    public void deleteFromRepository(Long uuid, Long versionID) throws SubmitFilesException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            this.repositoryService.deleteVersion(ticket, uuid, versionID);
        }
        catch (Exception e) {
            throw new SubmitFilesException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    @Override
    public void deleteInstructionFile(Long uid) {
        this.attachmentDAO.deleteById(InstructionFiles.class, uid);
    }

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) {
        if (toolSessionId == null || toolContentId == null) {
            throw new SubmitFilesException("Fail to create a submission session based on null toolSessionId or toolContentId");
        }
        log.debug((Object)("Start to create submission session based on toolSessionId[" + toolSessionId + "] and toolContentId[" + toolContentId + "]"));
        try {
            SubmitFilesContent submitContent = this.getSubmitFilesContent(toolContentId);
            if (submitContent == null || !toolContentId.equals(submitContent.getContentID())) {
                submitContent = new SubmitFilesContent();
                submitContent.setContentID(toolContentId);
            }
            SubmitFilesSession submitSession = new SubmitFilesSession();
            submitSession.setSessionID(toolSessionId);
            submitSession.setSessionName(toolSessionName);
            submitSession.setStatus(new Integer(0));
            submitSession.setContent(submitContent);
            this.submitFilesSessionDAO.createSession(submitSession);
            log.debug((Object)"Submit File session created");
        }
        catch (DataAccessException e) {
            throw new SubmitFilesException("Exception occured when lams is creating a submission Session: " + e.getMessage(), e);
        }
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        if (toolSessionId == null) {
            log.error((Object)"Fail to leave tool Session based on null tool session id.");
            throw new ToolException("Fail to remove tool Session based on null tool session id.");
        }
        if (learnerId == null) {
            log.error((Object)"Fail to leave tool Session based on null learner.");
            throw new ToolException("Fail to remove tool Session based on null learner.");
        }
        SubmitFilesSession session = this.submitFilesSessionDAO.getSessionByID(toolSessionId);
        if (session == null) {
            log.error((Object)("Fail to leave tool Session.Could not find submit file session by given session id: " + toolSessionId));
            throw new DataMissingException("Fail to leave tool Session.Could not find submit file session by given session id: " + toolSessionId);
        }
        session.setStatus(new Integer(1));
        this.submitFilesSessionDAO.update(session);
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) {
        return null;
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) {
        return null;
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        if (toolSessionId == null) {
            log.error((Object)"Fail to remove tool Session based on null tool session id.");
            throw new ToolException("Fail to remove tool Session based on null tool session id.");
        }
        SubmitFilesSession session = this.submitFilesSessionDAO.getSessionByID(toolSessionId);
        if (session == null) {
            log.error((Object)("Could not find submit file session by given session id: " + toolSessionId));
            throw new DataMissingException("Could not find submit file session by given session id: " + toolSessionId);
        }
        this.removeToolSession(session);
    }

    private void removeToolSession(SubmitFilesSession session) {
        Set filesUploaded = session.getSubmissionDetails();
        if (filesUploaded != null) {
            for (SubmissionDetails details : filesUploaded) {
                this.deleteFromRepository(details.getUuid(), details.getVersionID());
                this.submissionDetailsDAO.delete(details);
            }
        }
        this.submitFilesSessionDAO.delete(session);
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        return new TreeMap<String, ToolOutput>();
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        return null;
    }

    @Override
    public InstructionFiles uploadFileToContent(Long contentID, FormFile uploadFile, String fileType) throws SubmitFilesException {
        if (uploadFile == null || StringUtils.isEmpty((String)uploadFile.getFileName())) {
            throw new SubmitFilesException("Could not find upload file: " + uploadFile);
        }
        NodeKey nodeKey = this.processFile(uploadFile, fileType);
        InstructionFiles file = new InstructionFiles();
        file.setType(fileType);
        file.setUuID(nodeKey.getUuid());
        file.setVersionID(nodeKey.getVersion());
        file.setName(uploadFile.getFileName());
        return file;
    }

    @Override
    public void uploadFileToSession(Long sessionID, FormFile uploadFile, String fileDescription, Integer userID) throws SubmitFilesException {
        if (uploadFile == null || StringUtils.isEmpty((String)uploadFile.getFileName())) {
            throw new SubmitFilesException("Could not find upload file: " + uploadFile);
        }
        SubmitFilesSession session = this.submitFilesSessionDAO.getSessionByID(sessionID);
        if (session == null) {
            throw new SubmitFilesException("No such session with a sessionID of: " + sessionID + " found.");
        }
        NodeKey nodeKey = this.processFile(uploadFile, "ONLINE");
        SubmissionDetails details = new SubmissionDetails();
        details.setFileDescription(fileDescription);
        details.setFilePath(uploadFile.getFileName());
        details.setDateOfSubmission(new Date());
        SubmitUser learner = this.submitUserDAO.getLearner(sessionID, userID);
        details.setLearner(learner);
        details.setUuid(nodeKey.getUuid());
        details.setVersionID(nodeKey.getVersion());
        SubmitFilesReport report = new SubmitFilesReport();
        details.setReport(report);
        details.setSubmitFileSession(session);
        Set detailSet = session.getSubmissionDetails();
        detailSet.add(details);
        session.setSubmissionDetails(detailSet);
        this.submissionDetailsDAO.saveOrUpdate(session);
    }

    private NodeKey processFile(FormFile file, String fileType) {
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)file.getFileName())) {
            String fileName = file.getFileName();
            try {
                node = this.getSbmtToolContentHandler().uploadFile(file.getInputStream(), fileName, file.getContentType(), fileType);
            }
            catch (InvalidParameterException e) {
                throw new SubmitFilesException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new SubmitFilesException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (RepositoryCheckedException e) {
                throw new SubmitFilesException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (IOException e) {
                throw new SubmitFilesException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
        }
        return node;
    }

    @Override
    public List getFilesUploadedByUser(Integer userID, Long sessionID, Locale currentLocale) {
        List<SubmissionDetails> list = this.submissionDetailsDAO.getBySessionAndLearner(sessionID, userID);
        TreeSet<FileDetailsDTO> details = new TreeSet<FileDetailsDTO>(new FileDtoComparator());
        if (list == null) {
            return new ArrayList<FileDetailsDTO>(details);
        }
        NumberFormat numberFormat = currentLocale != null ? NumberFormat.getInstance(currentLocale) : null;
        for (SubmissionDetails submissionDetails : list) {
            FileDetailsDTO detailDto = new FileDetailsDTO(submissionDetails, numberFormat);
            details.add(detailDto);
        }
        return new ArrayList<FileDetailsDTO>(details);
    }

    @Override
    public SortedMap getFilesUploadedBySession(Long sessionID, Locale currentLocale) {
        List list = this.submissionDetailsDAO.getSubmissionDetailsBySession(sessionID);
        if (list != null) {
            NumberFormat numberFormat;
            TreeMap<SubmitUserDTO, ArrayList<FileDetailsDTO>> map = new TreeMap<SubmitUserDTO, ArrayList<FileDetailsDTO>>((Comparator<SubmitUserDTO>)new LastNameAlphabeticComparator());
            Iterator iterator = list.iterator();
            NumberFormat numberFormat2 = numberFormat = currentLocale != null ? NumberFormat.getInstance(currentLocale) : null;
            while (iterator.hasNext()) {
                SubmissionDetails submissionDetails = (SubmissionDetails)iterator.next();
                SubmitUser learner = submissionDetails.getLearner();
                if (learner == null) {
                    log.error((Object)("Could not find learer for special submission item:" + submissionDetails));
                    return null;
                }
                SubmitUserDTO submitUserDTO = new SubmitUserDTO(learner);
                FileDetailsDTO detailDto = new FileDetailsDTO(submissionDetails, numberFormat);
                ArrayList<FileDetailsDTO> userFileList = (ArrayList<FileDetailsDTO>)map.get(submitUserDTO);
                if (userFileList == null) {
                    userFileList = new ArrayList<FileDetailsDTO>();
                }
                userFileList.add(detailDto);
                map.put(submitUserDTO, userFileList);
            }
            return map;
        }
        return null;
    }

    @Override
    public FileDetailsDTO getFileDetails(Long detailID, Locale currentLocale) {
        SubmissionDetails details = this.submissionDetailsDAO.getSubmissionDetailsByID(detailID);
        return new FileDetailsDTO(details, currentLocale != null ? NumberFormat.getInstance(currentLocale) : null);
    }

    @Override
    public List<SubmitUser> getUsersBySession(Long sessionID) {
        return this.submitUserDAO.getUsersBySession(sessionID);
    }

    @Override
    public void updateMarks(Long reportID, Float marks, String comments) {
        SubmitFilesReport report = this.submitFilesReportDAO.getReportByID(reportID);
        if (report != null) {
            report.setComments(comments);
            report.setMarks(marks);
            this.submitFilesReportDAO.update(report);
        }
    }

    @Override
    public IVersionedNode downloadFile(Long uuid, Long versionID) throws SubmitFilesException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            IVersionedNode node = this.repositoryService.getFileItem(ticket, uuid, null);
            return node;
        }
        catch (AccessDeniedException ae) {
            throw new SubmitFilesException("AccessDeniedException occured while trying to download file " + ae.getMessage());
        }
        catch (FileException fe) {
            throw new SubmitFilesException("FileException occured while trying to download file " + fe.getMessage());
        }
        catch (ItemNotFoundException ie) {
            throw new SubmitFilesException("ItemNotFoundException occured while trying to download file " + ie.getMessage());
        }
    }

    @Override
    public SubmitFilesSession getSessionById(Long sessionID) {
        return this.submitFilesSessionDAO.getSessionByID(sessionID);
    }

    @Override
    public boolean releaseMarksForSession(Long sessionID) {
        List list = this.submissionDetailsDAO.getSubmissionDetailsBySession(sessionID);
        for (SubmissionDetails details : list) {
            SubmitFilesReport report = details.getReport();
            report.setDateMarksReleased(new Date());
            this.submitFilesReportDAO.updateReport(report);
        }
        return true;
    }

    @Override
    public void finishSubmission(Long sessionID, Integer userID) {
        SubmitUser learner = this.submitUserDAO.getLearner(sessionID, userID);
        learner.setFinished(true);
        this.submitUserDAO.saveOrUpdateUser(learner);
    }

    @Override
    public Long getToolDefaultContentIdBySignature(String toolSignature) {
        Long contentId = null;
        contentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (contentId == null) {
            String error = "Could not retrieve default content id for this tool";
            log.error((Object)error);
            throw new SubmitFilesException(error);
        }
        return contentId;
    }

    @Override
    public SubmitFilesContent createDefaultContent(Long contentID) {
        if (contentID == null) {
            String error = "Could not retrieve default content id for this tool";
            log.error((Object)error);
            throw new SubmitFilesException(error);
        }
        SubmitFilesContent defaultContent = this.getDefaultSubmit();
        SubmitFilesContent content = new SubmitFilesContent();
        content = SubmitFilesContent.newInstance(defaultContent, contentID, this.sbmtToolContentHandler);
        content.setContentID(contentID);
        return content;
    }

    private SubmitFilesContent getDefaultSubmit() {
        Long defaultToolContentId = this.getToolDefaultContentIdBySignature("lasbmt11");
        SubmitFilesContent defaultContent = this.getSubmitFilesContent(defaultToolContentId);
        if (defaultContent == null) {
            String error = "Could not retrieve default content record for this tool";
            log.error((Object)error);
            throw new SubmitFilesException(error);
        }
        return defaultContent;
    }

    @Override
    public List getSubmitFilesSessionByContentID(Long contentID) {
        List<SubmitFilesSession> learners = this.submitFilesSessionDAO.getSubmitFilesSessionByContentID(contentID);
        if (learners == null) {
            learners = new ArrayList<SubmitFilesSession>();
        }
        return learners;
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        SubmitFilesContent toolContentObj = new SubmitFilesContent();
        toolContentObj.setTitle((String)importValues.get("title"));
        toolContentObj.setContentID(toolContentId);
        toolContentObj.setContentInUse(Boolean.FALSE);
        toolContentObj.setCreated(now);
        toolContentObj.setDefineLater(Boolean.FALSE);
        toolContentObj.setInstruction(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
        toolContentObj.setOfflineInstruction(null);
        toolContentObj.setOnlineInstruction(null);
        toolContentObj.setRunOffline(Boolean.FALSE);
        toolContentObj.setUpdated(now);
        toolContentObj.setLockOnFinished(Boolean.TRUE);
        toolContentObj.setReflectOnActivity(Boolean.FALSE);
        toolContentObj.setReflectInstructions(null);
        SubmitUser suser = this.createContentUser(user, toolContentId);
        toolContentObj.setCreatedBy(suser);
        this.submitFilesContentDAO.saveOrUpdate(toolContentObj);
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        SubmitFilesContent toolContentObj = this.getSubmitFilesContent(toolContentId);
        if (toolContentObj == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        toolContentObj.setReflectOnActivity(Boolean.TRUE);
        toolContentObj.setReflectInstructions(description);
    }

    @Override
    public SubmitUser getUserByUid(Long learnerID) {
        return (SubmitUser)this.submitUserDAO.find(SubmitUser.class, learnerID);
    }

    @Override
    public SubmitUser createSessionUser(UserDTO userDto, Long sessionID) {
        SubmitUser learner = this.submitUserDAO.getLearner(sessionID, userDto.getUserID());
        if (learner != null) {
            return learner;
        }
        learner = new SubmitUser();
        learner.setUserID(userDto.getUserID());
        learner.setFirstName(userDto.getFirstName());
        learner.setLastName(userDto.getLastName());
        learner.setLogin(userDto.getLogin());
        learner.setSessionID(sessionID);
        learner.setFinished(false);
        this.submitUserDAO.saveOrUpdateUser(learner);
        return learner;
    }

    @Override
    public SubmitUser getSessionUser(Long sessionID, Integer userID) {
        return this.submitUserDAO.getLearner(sessionID, userID);
    }

    @Override
    public SubmitUser createContentUser(UserDTO userDto, Long contentId) {
        SubmitUser learner = this.submitUserDAO.getContentUser(contentId, userDto.getUserID());
        if (learner != null) {
            return learner;
        }
        learner = new SubmitUser();
        learner.setUserID(userDto.getUserID());
        learner.setFirstName(userDto.getFirstName());
        learner.setLastName(userDto.getLastName());
        learner.setLogin(userDto.getLogin());
        learner.setContentID(contentId);
        learner.setFinished(false);
        this.submitUserDAO.saveOrUpdateUser(learner);
        return learner;
    }

    @Override
    public SubmitUser getContentUser(Long contentId, Integer userID) {
        return this.submitUserDAO.getContentUser(contentId, userID);
    }

    public void setSubmitFilesContentDAO(ISubmitFilesContentDAO submitFilesContentDAO) {
        this.submitFilesContentDAO = submitFilesContentDAO;
    }

    public void setSubmitFilesReportDAO(ISubmitFilesReportDAO submitFilesReportDAO) {
        this.submitFilesReportDAO = submitFilesReportDAO;
    }

    public void setSubmitFilesSessionDAO(ISubmitFilesSessionDAO submitFilesSessionDAO) {
        this.submitFilesSessionDAO = submitFilesSessionDAO;
    }

    public void setSubmissionDetailsDAO(ISubmissionDetailsDAO submissionDetailsDAO) {
        this.submissionDetailsDAO = submissionDetailsDAO;
    }

    public IToolContentHandler getSbmtToolContentHandler() {
        return this.sbmtToolContentHandler;
    }

    public void setSbmtToolContentHandler(IToolContentHandler sbmtToolContentHandler) {
        this.sbmtToolContentHandler = sbmtToolContentHandler;
    }

    public ISubmitUserDAO getSubmitUserDAO() {
        return this.submitUserDAO;
    }

    public void setSubmitUserDAO(ISubmitUserDAO learnerDAO) {
        this.submitUserDAO = learnerDAO;
    }

    public ILearnerService getLearnerService() {
        return this.learnerService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public ILamsToolService getToolService() {
        return this.toolService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    public void setAttachmentDAO(IAttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileDtoComparator
    implements Comparator<FileDetailsDTO> {
        private FileDtoComparator() {
        }

        @Override
        public int compare(FileDetailsDTO o1, FileDetailsDTO o2) {
            if (o1 != null && o2 != null && o1.getDateOfSubmission() != null && o2.getDateOfSubmission() != null) {
                return o1.getDateOfSubmission().getTime() - o2.getDateOfSubmission().getTime() > 0L ? 1 : -1;
            }
            if (o1 != null) {
                return 1;
            }
            return -1;
        }
    }
}

