/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.service;

import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.sbmt.SbmtBaseTestCase;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesContent;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesSession;
import org.lamsfoundation.lams.tool.sbmt.dao.ISubmissionDetailsDAO;
import org.lamsfoundation.lams.tool.sbmt.dao.ISubmitFilesContentDAO;
import org.lamsfoundation.lams.tool.sbmt.dao.ISubmitFilesSessionDAO;
import org.lamsfoundation.lams.tool.sbmt.service.ISubmitFilesService;

public class TestSubmitFilesService
extends SbmtBaseTestCase {
    protected ISubmitFilesService submitFilesService;
    protected ToolContentManager submitFilesToolContentManager;
    protected ToolSessionManager submitFilesToolSessionManager;
    protected ISubmitFilesSessionDAO submitFilesSessionDAO = null;
    protected ISubmitFilesContentDAO submitFilesContentDAO = null;
    protected ISubmissionDetailsDAO submissionDetailsDAO;
    protected SubmitFilesContent submitFilesContent;

    public TestSubmitFilesService(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.submitFilesService = (ISubmitFilesService)this.context.getBean("submitFilesService");
        this.submitFilesToolContentManager = (ToolContentManager)this.submitFilesService;
        this.submitFilesToolSessionManager = (ToolSessionManager)this.submitFilesService;
        this.submitFilesSessionDAO = (ISubmitFilesSessionDAO)this.context.getBean("submitFilesSessionDAO");
        this.submitFilesContentDAO = (ISubmitFilesContentDAO)this.context.getBean("submitFilesContentDAO");
    }

    public void testCopyContent() {
        Long l = this.copyTestContent();
    }

    private Long copyTestContent() {
        Long l = new Long(this.getMaxContentId() + 1L);
        try {
            this.submitFilesToolContentManager.copyToolContent(TEST_CONTENT_ID, l);
        }
        catch (ToolException toolException) {
            toolException.printStackTrace();
            TestSubmitFilesService.fail((String)"Tool exception thrown copying the content");
        }
        return l;
    }

    public void testCreateSession() {
        this.createSession(this.copyTestContent());
    }

    private SubmitFilesSession createSession(Long l) {
        Long l2 = new Long(this.getMaxSessionId() + 1L);
        try {
            this.submitFilesToolSessionManager.createToolSession(l2, "sessionName", l);
        }
        catch (ToolException toolException) {
            toolException.printStackTrace();
            TestSubmitFilesService.fail((String)"Tool exception thrown while creating session");
        }
        SubmitFilesSession submitFilesSession = this.submitFilesSessionDAO.getSessionByID(l2);
        TestSubmitFilesService.assertNotNull((String)"submitFilesSession", (Object)submitFilesSession);
        TestSubmitFilesService.assertEquals((Object)l2, (Object)submitFilesSession.getSessionID());
        return submitFilesSession;
    }

    public void testRemoveToolContentSessionDataExists() {
        Long l = this.copyTestContent();
        SubmitFilesSession submitFilesSession = this.createSession(l);
        Long l2 = submitFilesSession.getSessionID();
        try {
            this.submitFilesToolContentManager.removeToolContent(l, false);
            TestSubmitFilesService.fail((String)("Expected SessionDataExistsException to be thrown, toolSessionId = " + l2));
        }
        catch (SessionDataExistsException sessionDataExistsException) {
            TestSubmitFilesService.assertTrue((String)"SessionDataExistsException thrown as expected", (boolean)true);
        }
        catch (ToolException toolException) {
            toolException.printStackTrace();
            TestSubmitFilesService.fail((String)("Tool exception thrown deleting the content toolContentId=" + l));
        }
        SubmitFilesContent submitFilesContent = this.submitFilesContentDAO.getContentByID(l);
        TestSubmitFilesService.assertNotNull((String)"Tool content data", (Object)submitFilesContent);
        SubmitFilesSession submitFilesSession2 = this.submitFilesSessionDAO.getSessionByID(l2);
        TestSubmitFilesService.assertNotNull((String)"Tool session data", (Object)submitFilesSession2);
        try {
            this.submitFilesToolContentManager.removeToolContent(l, true);
        }
        catch (SessionDataExistsException sessionDataExistsException) {
            sessionDataExistsException.printStackTrace();
            TestSubmitFilesService.fail((String)("SessionDataExistsException thrown deleting the content toolContentId=" + l));
        }
        catch (ToolException toolException) {
            toolException.printStackTrace();
            TestSubmitFilesService.fail((String)("Tool exception thrown deleting the content toolContentId=" + l));
        }
        SubmitFilesContent submitFilesContent2 = this.submitFilesContentDAO.getContentByID(l);
        TestSubmitFilesService.assertNull((String)"Tool Content has been deleted as expected", (Object)submitFilesContent2);
        SubmitFilesSession submitFilesSession3 = this.submitFilesSessionDAO.getSessionByID(l2);
        TestSubmitFilesService.assertNull((String)"Tool session has been deleted as expected", (Object)submitFilesSession3);
    }

    public void testRemoveToolContentNoSessionData() {
        Long l = this.copyTestContent();
        try {
            this.submitFilesToolContentManager.removeToolContent(l, true);
        }
        catch (SessionDataExistsException sessionDataExistsException) {
            sessionDataExistsException.printStackTrace();
            TestSubmitFilesService.fail((String)("SessionDataExistsException thrown deleting the content toolContentId=" + l));
        }
        catch (ToolException toolException) {
            toolException.printStackTrace();
            TestSubmitFilesService.fail((String)("Tool exception thrown deleting the content toolContentId=" + l));
        }
        SubmitFilesContent submitFilesContent = this.submitFilesContentDAO.getContentByID(l);
        TestSubmitFilesService.assertNull((String)"Tool Content has been deleted as expected", (Object)submitFilesContent);
    }
}

