/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.web;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.sbmt.InstructionFiles;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesContent;
import org.lamsfoundation.lams.tool.sbmt.SubmitUser;
import org.lamsfoundation.lams.tool.sbmt.form.AuthoringForm;
import org.lamsfoundation.lams.tool.sbmt.service.ISubmitFilesService;
import org.lamsfoundation.lams.tool.sbmt.service.SubmitFilesServiceProxy;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;

public class AuthoringAction
extends LamsDispatchAction {
    private Logger log = Logger.getLogger(AuthoringAction.class);
    public ISubmitFilesService submitFilesService;

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ToolAccessMode mode = null;
        try {
            mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)true);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mode == null) {
            mode = ToolAccessMode.AUTHOR;
        }
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        Long contentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        this.submitFilesService = this.getService();
        SubmitFilesContent persistContent = this.submitFilesService.getSubmitFilesContent(contentID);
        if (mode.isTeacher()) {
            persistContent.setDefineLater(true);
            this.submitFilesService.saveOrUpdateContent(persistContent);
        }
        if (persistContent == null) {
            persistContent = this.submitFilesService.createDefaultContent(contentID);
        }
        List attachmentList = this.getAttachmentList(sessionMap);
        attachmentList.clear();
        attachmentList.addAll(persistContent.getInstructionFiles());
        List delAttachmentList = this.getDeletedAttachmentList(sessionMap);
        delAttachmentList.clear();
        AuthoringForm authForm = (AuthoringForm)form;
        authForm.initContentValue(persistContent);
        authForm.setSessionMapID(sessionMap.getSessionID());
        authForm.setCurrentTab(request.getParameter("currentTab"));
        authForm.setContentFolderID(contentFolderID);
        return mapping.findForward("success");
    }

    public ActionForward updateContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionMessages errors;
        AuthoringForm authForm = (AuthoringForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(authForm.getSessionMapID());
        ToolAccessMode mode = null;
        try {
            mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)true);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mode == null) {
            mode = ToolAccessMode.AUTHOR;
        }
        if (!(errors = this.validate(authForm, mapping, request)).isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.getInputForward();
        }
        SubmitFilesContent content = this.getContent(form);
        this.submitFilesService = this.getService();
        SubmitFilesContent persistContent = this.submitFilesService.getSubmitFilesContent(content.getContentID());
        if (persistContent == null) {
            persistContent = content;
            content.setCreated(new Date());
        } else if (mode.isAuthor()) {
            Long uid = persistContent.getContentID();
            PropertyUtils.copyProperties((Object)persistContent, (Object)content);
            persistContent.setContentID(uid);
        } else {
            persistContent.setInstruction(content.getInstruction());
            persistContent.setTitle(content.getTitle());
            persistContent.setDefineLater(false);
        }
        HttpSession ss = SessionManager.getSession();
        UserDTO userDto = (UserDTO)ss.getAttribute("user");
        Long contentId = authForm.getToolContentID();
        SubmitUser user = this.submitFilesService.getContentUser(contentId, userDto.getUserID());
        if (user == null) {
            user = this.submitFilesService.createContentUser(userDto, contentId);
        }
        persistContent.setCreatedBy(user);
        HashSet<InstructionFiles> attPOSet = persistContent.getInstructionFiles();
        if (attPOSet == null) {
            attPOSet = new HashSet<InstructionFiles>();
        }
        List attachmentList = this.getAttachmentList(sessionMap);
        for (InstructionFiles newAtt : attachmentList) {
            attPOSet.add(newAtt);
        }
        attachmentList.clear();
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        for (InstructionFiles delAtt : deleteAttachmentList) {
            if (delAtt.getUid() == null) continue;
            Iterator attIter = attPOSet.iterator();
            while (attIter.hasNext()) {
                InstructionFiles att = (InstructionFiles)attIter.next();
                if (!delAtt.getUid().equals(att.getUid())) continue;
                attIter.remove();
                break;
            }
            this.submitFilesService.deleteInstructionFile(delAtt.getUid());
        }
        deleteAttachmentList.clear();
        persistContent.setInstructionFiles(attPOSet);
        this.submitFilesService.saveOrUpdateContent(persistContent);
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        return mapping.findForward("success");
    }

    public ActionForward uploadOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, form, "ONLINE", request);
    }

    public ActionForward uploadOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, form, "OFFLINE", request);
    }

    private ActionForward uploadFile(ActionMapping mapping, ActionForm form, String type, HttpServletRequest request) {
        AuthoringForm authForm = (AuthoringForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(authForm.getSessionMapID());
        FormFile file = StringUtils.equals((String)"OFFLINE", (String)type) ? authForm.getOfflineFile() : authForm.getOnlineFile();
        if (file == null || StringUtils.isBlank((String)file.getFileName())) {
            return mapping.getInputForward();
        }
        InstructionFiles att = this.submitFilesService.uploadFileToContent(authForm.getToolContentID(), file, type);
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            InstructionFiles existAtt = (InstructionFiles)iter.next();
            if (!StringUtils.equals((String)existAtt.getName(), (String)att.getName()) || !StringUtils.equals((String)existAtt.getType(), (String)att.getType())) continue;
            deleteAttachmentList.add(existAtt);
            iter.remove();
            break;
        }
        attachmentList.add(att);
        return mapping.getInputForward();
    }

    public ActionForward deleteOfflineFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, form, request, response, "OFFLINE");
    }

    public ActionForward deleteOnlineFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, form, request, response, "ONLINE");
    }

    private ActionForward deleteFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String type) {
        Long versionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"fileVersionId"));
        Long uuID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"fileUuid"));
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        List attachmentList = this.getAttachmentList(sessionMap);
        List deleteAttachmentList = this.getDeletedAttachmentList(sessionMap);
        Iterator iter = attachmentList.iterator();
        while (iter.hasNext()) {
            InstructionFiles existAtt = (InstructionFiles)iter.next();
            if (!existAtt.getUuID().equals(uuID) || !existAtt.getVersionID().equals(versionID)) continue;
            deleteAttachmentList.add(existAtt);
            iter.remove();
        }
        request.setAttribute("fileTypeFlag", (Object)type);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        return mapping.findForward("instructionFileList");
    }

    private SubmitFilesContent getContent(ActionForm form) {
        AuthoringForm authForm = (AuthoringForm)form;
        Long contentId = authForm.getToolContentID();
        SubmitFilesContent content = new SubmitFilesContent();
        content.setContentID(contentId);
        content.setInstruction(authForm.getInstructions());
        content.setOfflineInstruction(authForm.getOfflineInstruction());
        content.setOnlineInstruction(authForm.getOnlineInstruction());
        content.setTitle(authForm.getTitle());
        content.setLockOnFinished(authForm.isLockOnFinished());
        content.setReflectInstructions(authForm.getReflectInstructions());
        content.setReflectOnActivity(authForm.isReflectOnActivity());
        content.setLimitUpload(authForm.isLimitUpload());
        content.setLimitUploadNumber(authForm.getLimitUploadNumber());
        return content;
    }

    private List getAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "attachmentList");
    }

    private List getDeletedAttachmentList(SessionMap sessionMap) {
        return this.getListFromSession(sessionMap, "deletedAttachmentList");
    }

    private List getListFromSession(SessionMap sessionMap, String name) {
        ArrayList list = (ArrayList)sessionMap.get((Object)name);
        if (list == null) {
            list = new ArrayList();
            sessionMap.put((Object)name, list);
        }
        return list;
    }

    private ISubmitFilesService getService() {
        if (this.submitFilesService == null) {
            return SubmitFilesServiceProxy.getSubmitFilesService(this.getServlet().getServletContext());
        }
        return this.submitFilesService;
    }

    private ActionMessages validate(AuthoringForm sbmtForm, ActionMapping mapping, HttpServletRequest request) {
        ActionMessages errors = new ActionMessages();
        String modeStr = request.getParameter("mode");
        if (StringUtils.equals((String)modeStr, (String)ToolAccessMode.TEACHER.toString())) {
            return errors;
        }
        return errors;
    }
}

