/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.web;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesContent;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesSession;
import org.lamsfoundation.lams.tool.sbmt.SubmitUser;
import org.lamsfoundation.lams.tool.sbmt.dto.FileDetailsDTO;
import org.lamsfoundation.lams.tool.sbmt.dto.SubmitUserDTO;
import org.lamsfoundation.lams.tool.sbmt.exception.SubmitFilesException;
import org.lamsfoundation.lams.tool.sbmt.service.ISubmitFilesService;
import org.lamsfoundation.lams.tool.sbmt.service.SubmitFilesServiceProxy;
import org.lamsfoundation.lams.usermanagement.util.LastNameAlphabeticComparator;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;
import org.lamsfoundation.lams.web.util.SessionMap;

public class ExportServlet
extends AbstractExportPortfolioServlet {
    private static final long serialVersionUID = -4529093489007108143L;
    private static Logger logger = Logger.getLogger(ExportServlet.class);
    private final String FILENAME = "sbmt_main.html";
    private ISubmitFilesService sbmtService;

    public void init() throws ServletException {
        this.sbmtService = SubmitFilesServiceProxy.getSubmitFilesService(this.getServletContext());
        super.init();
    }

    public String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        Map map = null;
        if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
            map = this.learner(request, response, directoryName, cookies, (HashMap)sessionMap);
        } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
            map = this.teacher(request, response, directoryName, cookies, (HashMap)sessionMap);
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        LinkedList<String> attachmentList = new LinkedList<String>();
        for (SubmitUserDTO user : map.keySet()) {
            List fileList = (List)map.get(user);
            Iterator fileListIter = fileList.iterator();
            int submissionCount = 1;
            while (fileListIter.hasNext()) {
                FileDetailsDTO submittedFile = (FileDetailsDTO)fileListIter.next();
                IVersionedNode node = this.sbmtService.downloadFile(submittedFile.getUuID(), submittedFile.getVersionID());
                if (node.isNodeType("FILENODE")) {
                    String error;
                    try {
                        InputStream is = node.getFile();
                        File outFileDir = new File(directoryName + File.separator + user.getLogin() + File.separator + submissionCount);
                        outFileDir.mkdirs();
                        logger.debug((Object)("doExport: starting to write file in zip compatible format:" + node.getZipCompatibleFilename()));
                        File outFile = new File(outFileDir, node.getZipCompatibleFilename());
                        FileOutputStream fos = new FileOutputStream(outFile);
                        byte[] out = new byte[8192];
                        int len = -1;
                        while ((len = is.read(out)) != -1) {
                            fos.write(out, 0, len);
                        }
                        logger.debug((Object)"doExport: finished writing to file");
                        is.close();
                        fos.close();
                    }
                    catch (FileException fe) {
                        error = "Unable to retrieve file from repository";
                        logger.error((Object)error);
                        throw new SubmitFilesException(error);
                    }
                    catch (IOException ioe) {
                        error = "An IO error occured while writing file to disk";
                        logger.error((Object)error);
                        throw new SubmitFilesException(error);
                    }
                } else {
                    String error = "Node in repository is not a FILENODE";
                    logger.error((Object)error);
                    throw new SubmitFilesException(error);
                }
                logger.debug((Object)"doExport: encoding exportedURL");
                String exportedURL = user.getLogin() + "/" + submissionCount + "/" + node.getZipCompatibleFilename();
                attachmentList.add(exportedURL);
                try {
                    URLEncoder.encode(exportedURL, "UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    exportedURL = "/";
                    String error = "Unable to URL encode the file path, files written to disk";
                    logger.error((Object)error);
                    throw new SubmitFilesException(error);
                }
                exportedURL = exportedURL.replaceAll("\\+", "%20");
                submittedFile.setExportedURL(exportedURL);
                ++submissionCount;
                logger.debug((Object)("doExport: finished file:" + submittedFile.getFilePath()));
            }
        }
        sessionMap.put((Object)"attachmentList", attachmentList);
        this.writeResponseToFile(basePath + "/export/exportAttachmentList.jsp?sessionMapID=" + sessionMap.getSessionID(), directoryName, "attachment_list.txt", cookies);
        this.writeResponseToFile(basePath + "/export/exportportfolio.jsp?sessionMapID=" + sessionMap.getSessionID(), directoryName, "sbmt_main.html", cookies);
        return "sbmt_main.html";
    }

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            logger.error((Object)"Tool content Id or and session Id are null. Unable to activity title");
        } else {
            ISubmitFilesService service = SubmitFilesServiceProxy.getSubmitFilesService(this.getServletContext());
            SubmitFilesContent content = null;
            if (this.toolContentID != null) {
                content = service.getSubmitFilesContent(this.toolContentID);
            } else {
                SubmitFilesSession session = service.getSessionById(this.toolSessionID);
                if (session != null) {
                    content = session.getContent();
                }
            }
            if (content != null) {
                this.activityTitle = content.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    public Map learner(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies, HashMap sessionMap) {
        if (this.userID == null || this.toolSessionID == null) {
            String error = "Tool session Id or user Id is null. Unable to continue";
            logger.error((Object)error);
            throw new SubmitFilesException(error);
        }
        SubmitUser learner = this.sbmtService.getSessionUser(this.toolSessionID, new Integer(this.userID.intValue()));
        if (learner == null) {
            String error = "The user with user id " + this.userID + " does not exist in this session or session may not exist.";
            logger.error((Object)error);
            throw new SubmitFilesException(error);
        }
        SubmitUserDTO submitUserDTO = new SubmitUserDTO(learner);
        SubmitFilesSession session = this.sbmtService.getSessionById(this.toolSessionID);
        if (session == null) {
            String error = "The session does not exist.";
            logger.error((Object)error);
            throw new SubmitFilesException(error);
        }
        SubmitFilesContent content = session.getContent();
        if (content == null) {
            String error = "The content for this activity has not been defined yet.";
            logger.error((Object)error);
            throw new SubmitFilesException(error);
        }
        List fileList = this.sbmtService.getFilesUploadedByUser(new Integer(this.userID.intValue()), this.toolSessionID, request.getLocale());
        for (FileDetailsDTO filedto : fileList) {
            if (filedto.getDateMarksReleased() != null) continue;
            filedto.setComments(null);
            filedto.setMarks(null);
        }
        if (content.isReflectOnActivity()) {
            submitUserDTO.setReflect(this.getReflectionEntry(learner.getSessionID(), learner.getUserID()));
        }
        HashMap<SubmitUserDTO, List> userFilesMap = new HashMap<SubmitUserDTO, List>();
        userFilesMap.put(submitUserDTO, fileList);
        sessionMap.put("reflectOn", content.isReflectOnActivity());
        TreeMap<String, HashMap<SubmitUserDTO, List>> report = new TreeMap<String, HashMap<SubmitUserDTO, List>>(new StringComparator());
        report.put(this.sbmtService.getSessionById(this.toolSessionID).getSessionName(), userFilesMap);
        sessionMap.put("report", report);
        return userFilesMap;
    }

    public Map teacher(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies, HashMap sessionMap) {
        if (this.toolContentID == null) {
            String error = "Tool Content Id is missing. Unable to continue";
            logger.error((Object)error);
            throw new SubmitFilesException(error);
        }
        SubmitFilesContent content = this.sbmtService.getSubmitFilesContent(this.toolContentID);
        if (content == null) {
            String error = "Data is missing from the database. Unable to Continue";
            logger.error((Object)error);
            throw new SubmitFilesException(error);
        }
        TreeMap report = new TreeMap(new StringComparator());
        TreeMap allFileMap = new TreeMap(new LastNameAlphabeticComparator());
        List<SubmitFilesSession> sessionList = this.sbmtService.getSessionsByContentID(this.toolContentID);
        for (SubmitFilesSession session : sessionList) {
            TreeMap userFilesMap = new TreeMap(new LastNameAlphabeticComparator());
            userFilesMap.putAll(this.sbmtService.getFilesUploadedBySession(session.getSessionID(), request.getLocale()));
            if (content.isReflectOnActivity()) {
                for (SubmitUserDTO submitUserDTO : userFilesMap.keySet()) {
                    submitUserDTO.setReflect(this.getReflectionEntry(session.getSessionID(), submitUserDTO.getUserID()));
                }
            }
            allFileMap.putAll(userFilesMap);
            report.put(session.getSessionName(), userFilesMap);
        }
        sessionMap.put("reflectOn", content.isReflectOnActivity());
        sessionMap.put("report", report);
        return allFileMap;
    }

    private String getReflectionEntry(Long toolSessionID, Integer userId) {
        NotebookEntry notebookEntry = this.sbmtService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lasbmt11", userId);
        if (notebookEntry != null) {
            return notebookEntry.getEntry();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 != null && o2 != null) {
                return o1.compareTo(o2);
            }
            if (o1 != null) {
                return 1;
            }
            return -1;
        }
    }
}

