/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.web;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesContent;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesSession;
import org.lamsfoundation.lams.tool.sbmt.SubmitUser;
import org.lamsfoundation.lams.tool.sbmt.dto.FileDetailsDTO;
import org.lamsfoundation.lams.tool.sbmt.dto.SubmitUserDTO;
import org.lamsfoundation.lams.tool.sbmt.exception.SubmitFilesException;
import org.lamsfoundation.lams.tool.sbmt.form.LearnerForm;
import org.lamsfoundation.lams.tool.sbmt.service.ISubmitFilesService;
import org.lamsfoundation.lams.tool.sbmt.service.SubmitFilesServiceProxy;
import org.lamsfoundation.lams.tool.sbmt.util.SbmtConstants;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;

public class LearnerAction
extends DispatchAction {
    private static final boolean MODE_OPTIONAL = false;
    public static Logger logger = Logger.getLogger(LearnerAction.class);

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        ((LearnerForm)form).setSessionMapID(sessionMap.getSessionID());
        ToolAccessMode mode = null;
        try {
            mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mode == null) {
            mode = ToolAccessMode.LEARNER;
        }
        Long sessionID = new Long(request.getParameter("toolSessionID"));
        HttpSession ss = SessionManager.getSession();
        Integer userID = null;
        if (mode != null && mode.isTeacher()) {
            userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID", (boolean)false);
        } else {
            UserDTO user = (UserDTO)ss.getAttribute("user");
            userID = user.getUserID();
        }
        ISubmitFilesService submitFilesService = this.getService();
        SubmitFilesSession session = submitFilesService.getSessionById(sessionID);
        SubmitFilesContent content = session.getContent();
        SubmitUser learner = this.getCurrentLearner(sessionID, submitFilesService);
        List filesUploaded = submitFilesService.getFilesUploadedByUser(userID, sessionID, request.getLocale());
        boolean lock = content.isLockOnFinished() && learner.isFinished();
        sessionMap.put((Object)"mode", (Object)mode);
        sessionMap.put((Object)"toolSessionID", (Object)sessionID);
        sessionMap.put((Object)"finishLock", (Object)lock);
        sessionMap.put((Object)"lockOnFinish", (Object)content.isLockOnFinished());
        sessionMap.put((Object)"reflectOn", (Object)content.isReflectOnActivity());
        sessionMap.put((Object)"reflectInstructions", (Object)content.getReflectInstructions());
        sessionMap.put((Object)"title", (Object)content.getTitle());
        sessionMap.put((Object)"instruction", (Object)content.getInstruction());
        sessionMap.put((Object)"limitUpload", (Object)content.isLimitUpload());
        sessionMap.put((Object)"limitUploadNumber", (Object)content.getLimitUploadNumber());
        sessionMap.put((Object)"userFinished", (Object)learner.isFinished());
        this.setLearnerDTO(request, sessionMap, learner, filesUploaded, mode);
        if (content.isDefineLater()) {
            return mapping.findForward("defineLater");
        }
        content.setContentInUse(true);
        content.setDefineLater(false);
        submitFilesService.saveOrUpdateContent(content);
        if (content.isRunOffline()) {
            return mapping.findForward("runOffline");
        }
        return mapping.findForward("success");
    }

    public ActionForward uploadFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LearnerForm learnerForm = (LearnerForm)form;
        String sessionMapID = learnerForm.getSessionMapID();
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        Long sessionID = (Long)sessionMap.get((Object)"toolSessionID");
        if (this.validateUploadForm(learnerForm, request)) {
            HttpSession ss = SessionManager.getSession();
            UserDTO user = (UserDTO)ss.getAttribute("user");
            Integer userID = user.getUserID();
            ISubmitFilesService submitFilesService = this.getService();
            List filesUploaded = submitFilesService.getFilesUploadedByUser(userID, sessionID, request.getLocale());
            SubmitUser learner = this.getCurrentLearner(sessionID, submitFilesService);
            ToolAccessMode mode = (ToolAccessMode)sessionMap.get((Object)"mode");
            this.setLearnerDTO(request, sessionMap, learner, filesUploaded, mode);
            return mapping.getInputForward();
        }
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Integer userID = user.getUserID();
        FormFile uploadedFile = learnerForm.getFile();
        String fileDescription = learnerForm.getDescription();
        learnerForm.setDescription("");
        ISubmitFilesService submitFilesService = this.getService();
        submitFilesService.uploadFileToSession(sessionID, uploadedFile, fileDescription, userID);
        List filesUploaded = submitFilesService.getFilesUploadedByUser(userID, sessionID, request.getLocale());
        SubmitUser learner = this.getCurrentLearner(sessionID, submitFilesService);
        ToolAccessMode mode = (ToolAccessMode)sessionMap.get((Object)"mode");
        this.setLearnerDTO(request, sessionMap, learner, filesUploaded, mode);
        return mapping.getInputForward();
    }

    public ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        ToolAccessMode mode = (ToolAccessMode)sessionMap.get((Object)"mode");
        Long sessionID = (Long)sessionMap.get((Object)"toolSessionID");
        if (mode == ToolAccessMode.LEARNER || mode.equals((Object)ToolAccessMode.AUTHOR)) {
            ToolSessionManager sessionMgrService = SubmitFilesServiceProxy.getToolSessionManager(this.getServlet().getServletContext());
            ISubmitFilesService submitFilesService = this.getService();
            HttpSession ss = SessionManager.getSession();
            UserDTO user = (UserDTO)ss.getAttribute("user");
            Integer userID = user.getUserID();
            submitFilesService.finishSubmission(sessionID, userID);
            try {
                String nextActivityUrl = sessionMgrService.leaveToolSession(sessionID, new Long(userID.intValue()));
                response.sendRedirect(nextActivityUrl);
            }
            catch (DataMissingException e) {
                throw new SubmitFilesException(e);
            }
            catch (ToolException e) {
                throw new SubmitFilesException(e);
            }
            catch (IOException e) {
                throw new SubmitFilesException(e);
            }
        }
        return null;
    }

    private ISubmitFilesService getService() {
        ISubmitFilesService submitFilesService = SubmitFilesServiceProxy.getSubmitFilesService(this.getServlet().getServletContext());
        return submitFilesService;
    }

    private boolean validateUploadForm(LearnerForm learnerForm, HttpServletRequest request) {
        ActionMessages errors = new ActionMessages();
        Locale preferredLocale = (Locale)request.getSession().getAttribute("org.apache.struts.action.LOCALE");
        if (learnerForm.getFile() == null || StringUtils.isBlank((String)learnerForm.getFile().getFileName())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.required", (Object)this.getResources(request).getMessage(preferredLocale, "learner.form.filepath.displayname")));
        }
        if (StringUtils.isBlank((String)learnerForm.getDescription())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.required", (Object)this.getResources(request).getMessage(preferredLocale, "label.learner.fileDescription")));
        }
        FileValidatorUtil.validateFileSize((FormFile)learnerForm.getFile(), (boolean)false, (ActionMessages)errors);
        if (learnerForm.getFile() != null) {
            log.debug((Object)("Learner submit file : " + learnerForm.getFile().getFileName()));
        }
        if (learnerForm.getFile() != null && FileUtil.isExecutableFile((String)learnerForm.getFile().getFileName())) {
            log.debug((Object)("File is executatable : " + learnerForm.getFile().getFileName()));
            ActionMessage msg = new ActionMessage("error.attachment.executable");
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", msg);
        }
        if (!errors.isEmpty()) {
            this.addErrors(request, errors);
            return true;
        }
        return false;
    }

    private void setLearnerDTO(HttpServletRequest request, SessionMap sessionMap, SubmitUser currUser, List filesUploaded, ToolAccessMode mode) {
        ISubmitFilesService submitFilesService;
        NotebookEntry notebookEntry;
        boolean limitUpload;
        SubmitUserDTO dto = new SubmitUserDTO(currUser);
        if (currUser != null) {
            if (filesUploaded != null) {
                for (FileDetailsDTO filedto : filesUploaded) {
                    if (mode.isTeacher() || currUser.getUid().equals(filedto.getOwner().getUserUid())) {
                        filedto.setCurrentLearner(true);
                    } else {
                        filedto.setCurrentLearner(false);
                    }
                    if (filedto.getDateMarksReleased() != null) continue;
                    filedto.setComments(null);
                    filedto.setMarks(null);
                }
            }
            dto.setFilesUploaded(filesUploaded);
        }
        if ((limitUpload = ((Boolean)sessionMap.get((Object)"limitUpload")).booleanValue()) && filesUploaded != null) {
            int limit = (Integer)sessionMap.get((Object)"limitUploadNumber");
            if (limit == filesUploaded.size()) {
                sessionMap.put(SbmtConstants.ATTR_ARRIVE_LIMIT, (Object)true);
            }
            int limitUploadLeft = limit - filesUploaded.size();
            dto.setLimitUploadLeft(limitUploadLeft);
        }
        if ((notebookEntry = (submitFilesService = this.getService()).getEntry((Long)sessionMap.get((Object)"toolSessionID"), CoreNotebookConstants.NOTEBOOK_TOOL, "lasbmt11", currUser.getUserID())) != null) {
            dto.setReflect(notebookEntry.getEntry());
        }
        request.setAttribute("learner", (Object)dto);
    }

    private SubmitUser getCurrentLearner(Long sessionID, ISubmitFilesService submitFilesService) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Integer userID = user.getUserID();
        SubmitUser learner = submitFilesService.getSessionUser(sessionID, userID);
        if (learner == null) {
            learner = submitFilesService.createSessionUser(user, sessionID);
        }
        return learner;
    }
}

