/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesContent;
import org.lamsfoundation.lams.tool.sbmt.SubmitFilesSession;
import org.lamsfoundation.lams.tool.sbmt.SubmitUser;
import org.lamsfoundation.lams.tool.sbmt.dto.AuthoringDTO;
import org.lamsfoundation.lams.tool.sbmt.dto.FileDetailsDTO;
import org.lamsfoundation.lams.tool.sbmt.dto.SessionDTO;
import org.lamsfoundation.lams.tool.sbmt.dto.StatisticDTO;
import org.lamsfoundation.lams.tool.sbmt.dto.SubmitUserDTO;
import org.lamsfoundation.lams.tool.sbmt.service.ISubmitFilesService;
import org.lamsfoundation.lams.tool.sbmt.service.SubmitFilesServiceProxy;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.NumberUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class MonitoringAction
extends LamsDispatchAction {
    public ISubmitFilesService submitFilesService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        Long contentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        this.submitFilesService = this.getSubmitFilesService();
        request.setAttribute("contentFolderID", (Object)contentFolderID);
        List submitFilesSessionList = this.submitFilesService.getSubmitFilesSessionByContentID(contentID);
        this.summary(request, submitFilesSessionList);
        this.statistic(request, submitFilesSessionList);
        SubmitFilesContent persistContent = this.submitFilesService.getSubmitFilesContent(contentID);
        persistContent.setContentID(contentID);
        AuthoringDTO authorDto = new AuthoringDTO(persistContent);
        request.setAttribute("authoring", (Object)authorDto);
        request.setAttribute("isPageEditable", (Object)persistContent.isContentInUse());
        DynaActionForm smbtMonitoringForm = (DynaActionForm)form;
        return mapping.findForward("success");
    }

    public ActionForward doStatistic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long contentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        this.submitFilesService = this.getSubmitFilesService();
        List submitFilesSessionList = this.submitFilesService.getSubmitFilesSessionByContentID(contentID);
        this.statistic(request, submitFilesSessionList);
        return mapping.findForward("statistic");
    }

    public ActionForward releaseMarks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.submitFilesService = this.getSubmitFilesService();
        Long sessionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        this.submitFilesService.releaseMarksForSession(sessionID);
        try {
            PrintWriter out = response.getWriter();
            SubmitFilesSession session = this.submitFilesService.getSessionById(sessionID);
            String sessionName = "";
            if (session != null) {
                sessionName = session.getSessionName();
            }
            out.write(this.getMessageService().getMessage("msg.mark.released", (Object[])new String[]{sessionName}));
            out.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public ActionForward downloadMarks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        this.submitFilesService = this.getSubmitFilesService();
        SortedMap userFilesMap = this.submitFilesService.getFilesUploadedBySession(sessionID, request.getLocale());
        String errors = null;
        try {
            int idx;
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet("Marks");
            sheet.setColumnWidth((short)0, (short)5000);
            Iterator iter = userFilesMap.values().iterator();
            int n = idx = 0;
            idx = (short)(idx + 1);
            HSSFRow row = sheet.createRow(n);
            HSSFCell cell = row.createCell((short)2);
            cell.setEncoding((short)1);
            cell.setCellValue(this.getMessageService().getMessage("label.learner.fileName"));
            cell = row.createCell((short)3);
            cell.setEncoding((short)1);
            cell.setCellValue(this.getMessageService().getMessage("label.learner.fileDescription"));
            cell = row.createCell((short)4);
            cell.setEncoding((short)1);
            cell.setCellValue(this.getMessageService().getMessage("label.learner.marks"));
            cell = row.createCell((short)5);
            cell.setEncoding((short)1);
            cell.setCellValue(this.getMessageService().getMessage("label.learner.comments"));
            while (iter.hasNext()) {
                List list = (List)iter.next();
                for (FileDetailsDTO dto : list) {
                    short count;
                    int n2 = idx;
                    idx = (short)(idx + 1);
                    row = sheet.createRow(n2);
                    short s = count = 0;
                    count = (short)(count + 1);
                    cell = row.createCell(s);
                    cell.setEncoding((short)1);
                    cell.setCellValue(dto.getOwner().getFirstName() + " " + dto.getOwner().getLastName());
                    count = (short)(count + 1);
                    sheet.setColumnWidth(count, (short)8000);
                    short s2 = count;
                    count = (short)(count + 1);
                    cell = row.createCell(s2);
                    cell.setEncoding((short)1);
                    cell.setCellValue(dto.getFilePath());
                    short s3 = count;
                    count = (short)(count + 1);
                    cell = row.createCell(s3);
                    cell.setEncoding((short)1);
                    cell.setCellValue(dto.getFileDescription());
                    short s4 = count;
                    count = (short)(count + 1);
                    cell = row.createCell(s4);
                    String marks = dto.getMarks();
                    cell.setCellValue(marks != null ? marks : "");
                    short s5 = count;
                    count = (short)(count + 1);
                    cell = row.createCell(s5);
                    cell.setEncoding((short)1);
                    cell.setCellValue(dto.getComments());
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            wb.write((OutputStream)bos);
            String fileName = "marks" + sessionID + ".xls";
            String mineType = "application/vnd.ms-excel";
            String header = "attachment; filename=\"" + fileName + "\";";
            response.setContentType(mineType);
            response.setHeader("Content-Disposition", header);
            byte[] data = bos.toByteArray();
            response.getOutputStream().write(data, 0, data.length);
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            log.error((Object)e);
            errors = new ActionMessage("monitoring.download.error", (Object)e.toString()).toString();
        }
        if (errors != null) {
            try {
                PrintWriter out = response.getWriter();
                out.write(errors);
                out.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public ActionForward listMark(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
        this.submitFilesService = this.getSubmitFilesService();
        List files = this.submitFilesService.getFilesUploadedByUser(userID, sessionID, request.getLocale());
        request.setAttribute("toolSessionID", (Object)sessionID);
        request.setAttribute("report", (Object)files);
        return mapping.findForward("listMark");
    }

    public ActionForward newMark(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        Long detailID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"detailID"));
        String updateMode = request.getParameter("updateMode");
        this.submitFilesService = this.getSubmitFilesService();
        ArrayList<FileDetailsDTO> report = new ArrayList<FileDetailsDTO>();
        report.add(this.submitFilesService.getFileDetails(detailID, request.getLocale()));
        request.setAttribute("report", report);
        request.setAttribute("updateMode", (Object)updateMode);
        request.setAttribute("toolSessionID", (Object)sessionID);
        return mapping.findForward("updateMark");
    }

    public ActionForward updateMark(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        Integer userID = WebUtil.readIntParam((HttpServletRequest)request, (String)"userID");
        Long detailID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"detailID"));
        String updateMode = request.getParameter("updateMode");
        Long reportID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"reportID"));
        ActionMessages errors = new ActionMessages();
        Float marks = null;
        String markStr = request.getParameter("marks");
        try {
            marks = NumberUtil.getLocalisedFloat((String)markStr, (Locale)request.getLocale());
        }
        catch (Exception e) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.mark.invalid.number"));
        }
        String comments = WebUtil.readStrParam((HttpServletRequest)request, (String)"comments", (boolean)true);
        if (!errors.isEmpty()) {
            this.submitFilesService = this.getSubmitFilesService();
            ArrayList<FileDetailsDTO> report = new ArrayList<FileDetailsDTO>();
            FileDetailsDTO fileDetail = this.submitFilesService.getFileDetails(detailID, request.getLocale());
            fileDetail.setComments(comments);
            fileDetail.setMarks(markStr);
            report.add(fileDetail);
            request.setAttribute("report", report);
            request.setAttribute("updateMode", (Object)updateMode);
            request.setAttribute("toolSessionID", (Object)sessionID);
            this.saveErrors(request, errors);
            return mapping.findForward("updateMark");
        }
        this.submitFilesService = this.getSubmitFilesService();
        this.submitFilesService.updateMarks(reportID, marks, comments);
        request.setAttribute("toolSessionID", (Object)sessionID);
        if (StringUtils.equals((String)updateMode, (String)"listMark")) {
            List report = this.submitFilesService.getFilesUploadedByUser(userID, sessionID, request.getLocale());
            request.setAttribute("report", (Object)report);
            return mapping.findForward("listMark");
        }
        SortedMap report = this.submitFilesService.getFilesUploadedBySession(sessionID, request.getLocale());
        request.setAttribute("reports", (Object)report);
        return mapping.findForward("listAllMarks");
    }

    public ActionForward listAllMarks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        this.submitFilesService = this.getSubmitFilesService();
        SortedMap userFilesMap = this.submitFilesService.getFilesUploadedBySession(sessionID, request.getLocale());
        request.setAttribute("toolSessionID", (Object)sessionID);
        request.setAttribute("reports", (Object)userFilesMap);
        return mapping.findForward("listAllMarks");
    }

    private ISubmitFilesService getSubmitFilesService() {
        return SubmitFilesServiceProxy.getSubmitFilesService(this.getServlet().getServletContext());
    }

    private MessageService getMessageService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (MessageService)wac.getBean("sbmtMessageService");
    }

    private void setMarkPage(HttpServletRequest request, Long sessionID, Long userID, Long detailID, String updateMode) {
    }

    private void statistic(HttpServletRequest request, List submitFilesSessionList) {
        TreeMap<SessionDTO, StatisticDTO> sessionStatisticMap = new TreeMap<SessionDTO, StatisticDTO>(new SessionComparator());
        for (SubmitFilesSession sfs : submitFilesSessionList) {
            Long sessionID = sfs.getSessionID();
            String sessionName = sfs.getSessionName();
            SortedMap userFilesMap = this.submitFilesService.getFilesUploadedBySession(sessionID, request.getLocale());
            Iterator iter = userFilesMap.values().iterator();
            int notMarkedCount = 0;
            int markedCount = 0;
            while (iter.hasNext()) {
                List list = (List)iter.next();
                for (FileDetailsDTO dto : list) {
                    if (dto.getMarks() == null) {
                        ++notMarkedCount;
                        continue;
                    }
                    ++markedCount;
                }
            }
            StatisticDTO statisticDto = new StatisticDTO();
            SessionDTO sessionDto = new SessionDTO();
            statisticDto.setMarkedCount(markedCount);
            statisticDto.setNotMarkedCount(notMarkedCount);
            statisticDto.setTotalUploadedFiles(markedCount + notMarkedCount);
            sessionDto.setSessionID(sessionID);
            sessionDto.setSessionName(sessionName);
            sessionStatisticMap.put(sessionDto, statisticDto);
        }
        request.setAttribute("statisticList", sessionStatisticMap);
    }

    private void summary(HttpServletRequest request, List submitFilesSessionList) {
        TreeMap sessionUserMap = new TreeMap(new SessionComparator());
        Iterator it = submitFilesSessionList.iterator();
        while (it.hasNext()) {
            SessionDTO sessionDto = new SessionDTO();
            SubmitFilesSession sfs = (SubmitFilesSession)it.next();
            Long sessionID = sfs.getSessionID();
            sessionDto.setSessionID(sessionID);
            sessionDto.setSessionName(sfs.getSessionName());
            boolean hasReflect = sfs.getContent().isReflectOnActivity();
            SortedMap userFilesMap = this.submitFilesService.getFilesUploadedBySession(sessionID, request.getLocale());
            List<SubmitUser> userList = this.submitFilesService.getUsersBySession(sessionID);
            ArrayList<SubmitUserDTO> learnerList = new ArrayList<SubmitUserDTO>();
            for (SubmitUser user : userList) {
                SubmitUserDTO learnerDto = new SubmitUserDTO(user);
                learnerDto.setHasRefection(hasReflect);
                learnerDto.setAnyFilesMarked(false);
                List files = (List)userFilesMap.get(user);
                if (files != null && files.size() > 0) {
                    for (FileDetailsDTO file : files) {
                        if (file.getMarks() == null || file.getMarks().trim().length() <= 0) continue;
                        learnerDto.setAnyFilesMarked(true);
                        break;
                    }
                }
                learnerList.add(learnerDto);
            }
            sessionUserMap.put(sessionDto, learnerList);
        }
        request.setAttribute("sessionUserMap", sessionUserMap);
    }

    public ActionForward viewReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long userUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"userUid");
        Long sessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        this.submitFilesService = this.getSubmitFilesService();
        SubmitUser userDto = this.submitFilesService.getUserByUid(userUid);
        this.submitFilesService = this.getSubmitFilesService();
        NotebookEntry notebookEntry = this.submitFilesService.getEntry(sessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lasbmt11", userDto.getUserID());
        SubmitFilesSession session = this.submitFilesService.getSessionById(sessionID);
        SubmitUserDTO userDTO = new SubmitUserDTO(userDto);
        if (notebookEntry == null) {
            userDTO.setFinishReflection(false);
            userDTO.setReflect(null);
        } else {
            userDTO.setFinishReflection(true);
            userDTO.setReflect(notebookEntry.getEntry());
        }
        userDTO.setReflectInstrctions(session.getContent().getReflectInstructions());
        request.setAttribute("userDTO", (Object)userDTO);
        return mapping.findForward("viewReflect");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SessionComparator
    implements Comparator<SessionDTO> {
        private SessionComparator() {
        }

        @Override
        public int compare(SessionDTO o1, SessionDTO o2) {
            if (o1 != null && o2 != null) {
                return o1.getSessionName().compareTo(o2.getSessionName());
            }
            if (o1 != null) {
                return 1;
            }
            return -1;
        }
    }
}

