/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.sbmt.web;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.sbmt.form.ReflectionForm;
import org.lamsfoundation.lams.tool.sbmt.service.ISubmitFilesService;
import org.lamsfoundation.lams.tool.sbmt.service.SubmitFilesServiceProxy;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;

public class ReflectAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = mapping.getParameter();
        if (param.equals("newReflection")) {
            return this.newReflection(mapping, form, request, response);
        }
        if (param.equals("submitReflection")) {
            return this.submitReflection(mapping, form, request, response);
        }
        return mapping.findForward("success");
    }

    public ActionForward newReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        ReflectionForm refForm = (ReflectionForm)form;
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        refForm.setUserID(user.getUserID());
        refForm.setSessionMapID(sessionMapID);
        ISubmitFilesService submitFilesService = this.getService();
        SessionMap map = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long toolSessionID = (Long)map.get((Object)"toolSessionID");
        NotebookEntry entry = submitFilesService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lasbmt11", user.getUserID());
        if (entry != null) {
            refForm.setEntryText(entry.getEntry());
        }
        return mapping.findForward("success");
    }

    public ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReflectionForm refForm = (ReflectionForm)form;
        Integer userId = refForm.getUserID();
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        request.setAttribute("sessionMapID", (Object)sessionMapID);
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        ISubmitFilesService submitFilesService = this.getService();
        NotebookEntry entry = submitFilesService.getEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lasbmt11", userId);
        if (entry == null) {
            submitFilesService.createNotebookEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lasbmt11", userId, refForm.getEntryText());
        } else {
            entry.setEntry(refForm.getEntryText());
            entry.setLastModified(new Date());
            submitFilesService.updateEntry(entry);
        }
        return mapping.findForward("success");
    }

    private ISubmitFilesService getService() {
        ISubmitFilesService submitFilesService = SubmitFilesServiceProxy.getSubmitFilesService(this.getServlet().getServletContext());
        return submitFilesService;
    }

    public static ActionErrors validateBeforeFinish(HttpServletRequest request, ISubmitFilesService submitFilesService) {
        ActionErrors errors = new ActionErrors();
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Integer userID = user.getUserID();
        List list = submitFilesService.getFilesUploadedByUser(userID, sessionId, request.getLocale());
        int minUpload = (Integer)sessionMap.get((Object)"minUpload");
        if (minUpload > 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.learning.minimum.upload.number.less"));
        }
        return errors;
    }
}

