/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.survey.dto;

import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.survey.model.SurveyAnswer;
import org.lamsfoundation.lams.tool.survey.model.SurveyOption;
import org.lamsfoundation.lams.tool.survey.model.SurveyQuestion;
import org.lamsfoundation.lams.tool.survey.model.SurveyUser;
import org.lamsfoundation.lams.tool.survey.util.SurveyOptionComparator;

public class AnswerDTO
extends SurveyQuestion {
    private static final int SHORT_TITLE_LENGTH = 60;
    private SurveyAnswer answer;
    private double openResponse;
    private String openResponseFormatStr;
    private int openResponseCount;
    private SurveyUser replier;
    static Logger logger = Logger.getLogger((String)AnswerDTO.class.getName());

    public AnswerDTO(SurveyQuestion question) {
        try {
            PropertyUtils.copyProperties((Object)this, (Object)question);
        }
        catch (Exception e) {
            logger.error((Object)"Error occurs during creating AnswerDTO");
        }
        Set<SurveyOption> optList = question.getOptions();
        if (optList != null) {
            TreeSet<SurveyOption> newOptions = new TreeSet<SurveyOption>(new SurveyOptionComparator());
            for (SurveyOption option : optList) {
                SurveyOption newOption = (SurveyOption)option.clone();
                newOption.setUid(option.getUid());
                newOptions.add(newOption);
            }
            this.setOptions(newOptions);
        }
        String desc = this.getDescription();
        desc = desc.replaceAll("<(.|\n)*?>", "");
        this.setShortTitle(StringUtils.abbreviate((String)desc, (int)60));
    }

    public SurveyAnswer getAnswer() {
        return this.answer;
    }

    public void setAnswer(SurveyAnswer answer) {
        this.answer = answer;
    }

    public double getOpenResponse() {
        return this.openResponse;
    }

    public void setOpenResponse(double openResponse) {
        this.openResponse = openResponse;
    }

    public int getOpenResponseCount() {
        return this.openResponseCount;
    }

    public void setOpenResponseCount(int openResponseCount) {
        this.openResponseCount = openResponseCount;
    }

    public String getOpenResponseFormatStr() {
        return this.openResponseFormatStr;
    }

    public void setOpenResponseFormatStr(String openResponseFormatStr) {
        this.openResponseFormatStr = openResponseFormatStr;
    }

    public SurveyUser getReplier() {
        return this.replier;
    }

    public void setReplier(SurveyUser replier) {
        this.replier = replier;
    }
}

