/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.survey.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.survey.model.SurveyAttachment;
import org.lamsfoundation.lams.tool.survey.model.SurveyQuestion;
import org.lamsfoundation.lams.tool.survey.model.SurveyUser;
import org.lamsfoundation.lams.tool.survey.util.SurveyToolContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Survey
implements Cloneable {
    private static final Logger log = Logger.getLogger(Survey.class);
    private Long uid;
    private Long contentId;
    private String title;
    private String instructions;
    private boolean showOnePage;
    private boolean lockWhenFinished;
    private boolean reflectOnActivity;
    private String reflectInstructions;
    private boolean defineLater;
    private boolean runOffline;
    private boolean contentInUse;
    private String onlineInstructions;
    private String offlineInstructions;
    private Set<SurveyAttachment> attachments = new HashSet<SurveyAttachment>();
    private Date created;
    private Date updated;
    private SurveyUser createdBy;
    private Set<SurveyQuestion> questions = new HashSet<SurveyQuestion>();
    private IToolContentHandler toolContentHandler;
    private List<SurveyAttachment> onlineFileList;
    private List<SurveyAttachment> offlineFileList;

    public static Survey newInstance(Survey defaultContent, Long contentId, SurveyToolContentHandler surveyToolContentHandler) {
        Survey toContent = new Survey();
        defaultContent.toolContentHandler = surveyToolContentHandler;
        toContent = (Survey)defaultContent.clone();
        toContent.setContentId(contentId);
        if (toContent.getCreatedBy() != null) {
            toContent.getCreatedBy().setSurvey(toContent);
            Set<SurveyQuestion> items = toContent.getQuestions();
            for (SurveyQuestion item : items) {
                item.setCreateBy(toContent.getCreatedBy());
            }
        }
        return toContent;
    }

    public Object clone() {
        Survey survey = null;
        try {
            HashSet<SurveyQuestion> set;
            Iterator<Cloneable> iter;
            survey = (Survey)super.clone();
            survey.setUid(null);
            if (this.questions != null) {
                iter = this.questions.iterator();
                set = new HashSet<SurveyQuestion>();
                while (iter.hasNext()) {
                    SurveyQuestion item = (SurveyQuestion)iter.next();
                    SurveyQuestion newItem = (SurveyQuestion)item.clone();
                    set.add(newItem);
                }
                survey.questions = set;
            }
            if (this.attachments != null) {
                iter = this.attachments.iterator();
                set = new HashSet();
                while (iter.hasNext()) {
                    SurveyAttachment file = (SurveyAttachment)iter.next();
                    SurveyAttachment newFile = (SurveyAttachment)file.clone();
                    set.add((SurveyQuestion)((Object)newFile));
                }
                survey.attachments = set;
            }
            if (this.createdBy != null) {
                survey.setCreatedBy((SurveyUser)this.createdBy.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + Survey.class + " failed"));
        }
        return survey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Survey)) {
            return false;
        }
        Survey genericEntity = (Survey)o;
        return new EqualsBuilder().append((Object)this.uid, (Object)genericEntity.uid).append((Object)this.title, (Object)genericEntity.title).append((Object)this.instructions, (Object)genericEntity.instructions).append((Object)this.onlineInstructions, (Object)genericEntity.onlineInstructions).append((Object)this.offlineInstructions, (Object)genericEntity.offlineInstructions).append((Object)this.created, (Object)genericEntity.created).append((Object)this.updated, (Object)genericEntity.updated).append((Object)this.createdBy, (Object)genericEntity.createdBy).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).append((Object)this.title).append((Object)this.instructions).append((Object)this.onlineInstructions).append((Object)this.offlineInstructions).append((Object)this.created).append((Object)this.updated).append((Object)this.createdBy).toHashCode();
    }

    public void updateModificationData() {
        long now = System.currentTimeMillis();
        if (this.created == null) {
            this.setCreated(new Date(now));
        }
        this.setUpdated(new Date(now));
    }

    public void toDTO() {
        this.onlineFileList = new ArrayList<SurveyAttachment>();
        this.offlineFileList = new ArrayList<SurveyAttachment>();
        Set fileSet = this.getAttachments();
        if (fileSet != null) {
            for (SurveyAttachment file : fileSet) {
                if (StringUtils.equalsIgnoreCase((String)file.getFileType(), (String)"OFFLINE")) {
                    this.offlineFileList.add(file);
                    continue;
                }
                this.onlineFileList.add(file);
            }
        }
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public SurveyUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(SurveyUser createdBy) {
        this.createdBy = createdBy;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(boolean forceOffline) {
        this.runOffline = forceOffline;
    }

    public boolean getLockWhenFinished() {
        return this.lockWhenFinished;
    }

    public void setLockWhenFinished(boolean lockWhenFinished) {
        this.lockWhenFinished = lockWhenFinished;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public Set getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Set attachments) {
        this.attachments = attachments;
    }

    public Set<SurveyQuestion> getQuestions() {
        return this.questions;
    }

    public void setQuestions(Set questions) {
        this.questions = questions;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public Long getContentId() {
        return this.contentId;
    }

    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    public List<SurveyAttachment> getOfflineFileList() {
        return this.offlineFileList;
    }

    public void setOfflineFileList(List<SurveyAttachment> offlineFileList) {
        this.offlineFileList = offlineFileList;
    }

    public List<SurveyAttachment> getOnlineFileList() {
        return this.onlineFileList;
    }

    public void setOnlineFileList(List<SurveyAttachment> onlineFileList) {
        this.onlineFileList = onlineFileList;
    }

    public void setToolContentHandler(IToolContentHandler toolContentHandler) {
        this.toolContentHandler = toolContentHandler;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public boolean isShowOnePage() {
        return this.showOnePage;
    }

    public void setShowOnePage(boolean showOnePage) {
        this.showOnePage = showOnePage;
    }
}

