/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.survey.model;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.survey.model.Survey;
import org.lamsfoundation.lams.tool.survey.model.SurveySession;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;

public class SurveyUser
implements Cloneable {
    private static final long serialVersionUID = -7043502180037866257L;
    private static Logger log = Logger.getLogger(SurveyUser.class);
    private Long uid;
    private Long userId;
    private String firstName;
    private String lastName;
    private String loginName;
    private boolean sessionFinished;
    private SurveySession session;
    private Survey survey;

    public SurveyUser() {
    }

    public SurveyUser(UserDTO user, SurveySession session) {
        this.userId = new Long(user.getUserID().intValue());
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.loginName = user.getLogin();
        this.session = session;
        this.survey = null;
        this.sessionFinished = false;
    }

    public SurveyUser(UserDTO user, Survey content) {
        this.userId = new Long(user.getUserID().intValue());
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.loginName = user.getLogin();
        this.session = null;
        this.survey = content;
        this.sessionFinished = false;
    }

    public Object clone() {
        SurveyUser user = null;
        try {
            user = (SurveyUser)super.clone();
            user.setUid(null);
            user.setSession(null);
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("When clone " + SurveyUser.class + " failed"));
        }
        return user;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long userID) {
        this.uid = userID;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userID) {
        this.userId = userID;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public SurveySession getSession() {
        return this.session;
    }

    public void setSession(SurveySession session) {
        this.session = session;
    }

    public Survey getSurvey() {
        return this.survey;
    }

    public void setSurvey(Survey content) {
        this.survey = content;
    }

    public boolean isSessionFinished() {
        return this.sessionFinished;
    }

    public void setSessionFinished(boolean sessionFinished) {
        this.sessionFinished = sessionFinished;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SurveyUser)) {
            return false;
        }
        SurveyUser user = (SurveyUser)obj;
        return new EqualsBuilder().append((Object)this.uid, (Object)user.uid).append((Object)this.firstName, (Object)user.firstName).append((Object)this.lastName, (Object)user.lastName).append((Object)this.loginName, (Object)user.loginName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uid).append((Object)this.firstName).append((Object)this.lastName).append((Object)this.loginName).toHashCode();
    }
}

