/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.survey.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.tool.survey.dto.AnswerDTO;
import org.lamsfoundation.lams.tool.survey.dto.ReflectDTO;
import org.lamsfoundation.lams.tool.survey.model.Survey;
import org.lamsfoundation.lams.tool.survey.model.SurveyAnswer;
import org.lamsfoundation.lams.tool.survey.model.SurveyAttachment;
import org.lamsfoundation.lams.tool.survey.model.SurveyQuestion;
import org.lamsfoundation.lams.tool.survey.model.SurveySession;
import org.lamsfoundation.lams.tool.survey.model.SurveyUser;
import org.lamsfoundation.lams.tool.survey.service.SurveyApplicationException;
import org.lamsfoundation.lams.tool.survey.service.UploadSurveyFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ISurveyService {
    public Survey getSurveyByContentId(Long var1);

    public Survey getSurveyBySessionId(Long var1);

    public Survey getDefaultContent(Long var1) throws SurveyApplicationException;

    public void saveOrUpdateSurvey(Survey var1);

    public SurveyAttachment uploadInstructionFile(FormFile var1, String var2) throws UploadSurveyFileException;

    public void deleteSurveyAttachment(Long var1);

    public SurveyQuestion getQuestion(Long var1);

    public void deleteQuestion(Long var1);

    public List<AnswerDTO> getQuestionAnswers(Long var1, Long var2);

    public AnswerDTO getQuestionResponse(Long var1, Long var2);

    public void updateAnswerList(List<SurveyAnswer> var1);

    public void createUser(SurveyUser var1);

    public SurveyUser getUserByIDAndContent(Long var1, Long var2);

    public SurveyUser getUserByIDAndSession(Long var1, Long var2);

    public SurveyUser getUser(Long var1);

    public List<SurveyUser> getSessionUsers(Long var1);

    public void deleteFromRepository(Long var1, Long var2) throws SurveyApplicationException;

    public SurveySession getSurveySessionBySessionId(Long var1);

    public void saveOrUpdateSurveySession(SurveySession var1);

    public String finishToolSession(Long var1, Long var2) throws SurveyApplicationException;

    public SortedMap<SurveySession, List<AnswerDTO>> getSummary(Long var1);

    public SortedMap<SurveySession, Integer> getStatistic(Long var1);

    public SortedMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> exportByLearner(SurveyUser var1);

    public SortedMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> exportByContentId(Long var1);

    public SortedMap<SurveySession, SortedMap<SurveyQuestion, List<AnswerDTO>>> exportBySessionId(Long var1);

    public Long createNotebookEntry(Long var1, Integer var2, String var3, Integer var4, String var5);

    public NotebookEntry getEntry(Long var1, Integer var2, String var3, Integer var4);

    public void updateEntry(NotebookEntry var1);

    public Map<Long, Set<ReflectDTO>> getReflectList(Long var1, boolean var2);
}

